/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceTree;

public class SMSPrintUtil {
    protected static SimpleDateFormat sdf = new SimpleDateFormat();
    protected static Printer sysout = SMSPrintUtil.sysPrinter(System.out);

    protected static Printer gcubeLogPrinter(final GCUBELog logger) {
        return new Printer(){

            @Override
            public void println(String ... message) {
                if (message != null) {
                    if (message.length == 0) {
                        logger.trace((Object)"");
                    } else {
                        for (String msg : message) {
                            logger.trace((Object)msg);
                        }
                    }
                }
            }
        };
    }

    protected static Printer logPrinter(final Logger logger) {
        return new Printer(){

            @Override
            public void println(String ... message) {
                if (message != null) {
                    if (message.length == 0) {
                        logger.trace((Object)"");
                    } else {
                        for (String msg : message) {
                            logger.trace((Object)msg);
                        }
                    }
                }
            }
        };
    }

    protected static Printer sysPrinter(final PrintStream out) {
        return new Printer(){

            @Override
            public void println(String ... message) {
                if (message != null) {
                    if (message.length == 0) {
                        out.println();
                    } else {
                        for (String msg : message) {
                            out.println(msg);
                        }
                    }
                }
            }
        };
    }

    public static void printAsTree(InfoObjectTree io) {
        SMSPrintUtil.printAsTree(SMSPrintUtil.sysPrinter(System.out), "", io);
    }

    public static void printAsTree(InfoObjectTree io, GCUBELog logger) {
        SMSPrintUtil.printAsTree(SMSPrintUtil.gcubeLogPrinter(logger), "", io);
    }

    public static void printAsTree(InfoObjectTree io, Logger logger) {
        SMSPrintUtil.printAsTree(SMSPrintUtil.logPrinter(logger), "", io);
    }

    protected static void printAsTree(Printer printer, String indentation, InfoObjectTree io) {
        printer.println(indentation + "OID: " + io.getObjectID() + " Name: " + io.getName() + " RawContent: " + (io.getRawContent() != null));
        if (io.getProperties() != null) {
            SMSPrintUtil.printProperties(printer, indentation + "\t", io.getProperties());
        }
        if (io.getReferences() != null) {
            printer.println(indentation + "\tReferences [" + io.getReferences().length + "]:");
            for (ReferenceTree reference : io.getReferences()) {
                printer.println(indentation + "\tRole: " + reference.getRole() + ", SecondaryRole: " + reference.getSecondaryRole());
                SMSPrintUtil.printAsTree(printer, indentation + "\t\t", reference.getTargetObject());
            }
        }
        printer.println(new String[0]);
    }

    protected static void printProperties(Printer printer, String indentation, PropertyDescription[] properties) {
        printer.println(indentation + "Properties [" + properties.length + "]:");
        for (PropertyDescription property : properties) {
            printer.println(indentation + "Name: " + property.getName() + " Value: " + property.getValue() + " Type: " + property.getType());
        }
    }

    protected static interface Printer {
        public void println(String ... var1);
    }
}

