/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util;

import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSAndCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSBooleanPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSNotCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSOrCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyExistenceCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSStringPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSTimeInMillisecondsPropertyValueBetweenCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSTimeInMillisecondsPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.AndCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.BooleanPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.NotCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.OrCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyExistenceCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.StringPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.TimeInMillisecondsPropertyValueBetweenCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.TimeInMillisecondsPropertyValueCondition;

public class ObjectToWSConditionsConverter {
    public static WSPropertyCondition convertToWsPropertyCondition(PropertyCondition condition) {
        WSPropertyCondition wsPropertyCondition = new WSPropertyCondition();
        switch (condition.getConditionType()) {
            case AND: {
                wsPropertyCondition.setAndCondition(ObjectToWSConditionsConverter.convertToWsAndCondition((AndCondition)condition));
                break;
            }
            case OR: {
                wsPropertyCondition.setOrCondition(ObjectToWSConditionsConverter.convertToWsOrCondition((OrCondition)condition));
                break;
            }
            case NOT: {
                wsPropertyCondition.setNotCondition(ObjectToWSConditionsConverter.convertToWsNotCondition((NotCondition)condition));
                break;
            }
            case BOOLEAN_PROPERTY_VALUE: {
                wsPropertyCondition.setBooleanPropertyValueCondition(ObjectToWSConditionsConverter.convertToWsBooleanPropertyValueCondition((BooleanPropertyValueCondition)condition));
                break;
            }
            case STRING_PROPERTY_VALUE: {
                wsPropertyCondition.setStringPropertyValueCondition(ObjectToWSConditionsConverter.convertToWsStringPropertyValueCondition((StringPropertyValueCondition)condition));
                break;
            }
            case TIME_IN_MILLISECONDS_PROPERTY_VALUE: {
                wsPropertyCondition.setTimeInMillisecondsPropertyValueCondition(ObjectToWSConditionsConverter.convertToWsTimeInMillisecondsPropertyValueCondition((TimeInMillisecondsPropertyValueCondition)condition));
                break;
            }
            case TIME_IN_MILLISECONDS_PROPERTY_VALUE_BETWEEN: {
                wsPropertyCondition.setTimeInMillisecondsPropertyValueBetweenCondition(ObjectToWSConditionsConverter.convertToWsTimeInMillisecondsPropertyValueBetweenCondition((TimeInMillisecondsPropertyValueBetweenCondition)condition));
                break;
            }
            case PROPERTY_EXIST: {
                wsPropertyCondition.setPropertyExistenceCondition(ObjectToWSConditionsConverter.convertToWsPropertyExistenceCondition((PropertyExistenceCondition)condition));
            }
        }
        return wsPropertyCondition;
    }

    public static WSNotCondition convertToWsNotCondition(NotCondition condition) {
        WSPropertyCondition notCondition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(condition.getCondition());
        return new WSNotCondition(notCondition);
    }

    public static WSAndCondition convertToWsAndCondition(AndCondition condition) {
        WSPropertyCondition leftCondition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(condition.getLeftCondition());
        WSPropertyCondition rightCondition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(condition.getRightCondition());
        return new WSAndCondition(leftCondition, rightCondition);
    }

    public static WSOrCondition convertToWsOrCondition(OrCondition condition) {
        WSPropertyCondition leftCondition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(condition.getLeftCondition());
        WSPropertyCondition rightCondition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(condition.getRightCondition());
        return new WSOrCondition(leftCondition, rightCondition);
    }

    public static WSStringPropertyValueCondition convertToWsStringPropertyValueCondition(StringPropertyValueCondition condition) {
        return new WSStringPropertyValueCondition(condition.getPropertyName(), condition.getPropertyValue());
    }

    public static WSBooleanPropertyValueCondition convertToWsBooleanPropertyValueCondition(BooleanPropertyValueCondition condition) {
        return new WSBooleanPropertyValueCondition(condition.getPropertyName(), condition.getPropertyValue());
    }

    public static WSTimeInMillisecondsPropertyValueCondition convertToWsTimeInMillisecondsPropertyValueCondition(TimeInMillisecondsPropertyValueCondition condition) {
        return new WSTimeInMillisecondsPropertyValueCondition(condition.getPropertyName(), condition.getPropertyValue().longValue());
    }

    public static WSTimeInMillisecondsPropertyValueBetweenCondition convertToWsTimeInMillisecondsPropertyValueBetweenCondition(TimeInMillisecondsPropertyValueBetweenCondition condition) {
        return new WSTimeInMillisecondsPropertyValueBetweenCondition(condition.getLowerBound(), condition.getPropertyName(), condition.getUpperBound());
    }

    public static WSPropertyExistenceCondition convertToWsPropertyExistenceCondition(PropertyExistenceCondition condition) {
        return new WSPropertyExistenceCondition(condition.getPropertyName());
    }
}

