/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util;

import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSURLConnection;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInLocation;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;

public class RawContentUtil {
    public static String getTargetFileLocation(RawContentLocationConfig contentLocation) {
        switch (contentLocation.getType()) {
            case NONE: {
                return "/dev/null";
            }
            case INMESSAGE: {
                return "inmessage://";
            }
            case INMESSAGE_CONDITIONAL: {
                return "/dev/null";
            }
            case LOCATION: {
                return ((RawContentInLocation)contentLocation).getLocation();
            }
            case AS_URL: {
                return "/dev/null";
            }
        }
        return null;
    }

    public static PropertyDescription getRawContentUrlProperty(String oid) {
        String rawContentUrl = SMSURLConnection.getOIDUrl(oid);
        PropertyDescription urlProperty = new PropertyDescription("contentmanagement:ContentUrl", oid, "xsd:string", rawContentUrl);
        return urlProperty;
    }
}

