/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicReferenceDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.FilterChainComposer;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertiesFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.ConversionUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.RawContentUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.TreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInMessageConditional;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationType;

public class InfoObjectTreeUtil {
    protected static Logger logger = Logger.getLogger(InfoObjectTreeUtil.class);

    public static InfoObjectTree getInfoObjectTree(String oid, RawContentLocationConfig locationConfig, BasicStorageHints hints, List<TreeWalkRule> walkRules, int hops) throws StorageLayerException, GCUBEUnrecoverableValueNotValidFault {
        logger.trace((Object)"calculating rawContent location");
        String targetFileLocation = RawContentUtil.getTargetFileLocation(locationConfig);
        if (locationConfig.getType() == RawContentLocationType.INMESSAGE_CONDITIONAL) {
            Map properties = StorageManager.retrieveObjectStorageProperties((String)oid);
            RawContentInMessageConditional conditional = (RawContentInMessageConditional)locationConfig;
            PropertiesFilter filter = FilterChainComposer.convertToPropertyFilter(conditional.getPropertyCondition());
            if (filter.accept(properties)) {
                targetFileLocation = "inmessage://";
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getting IO: " + oid));
        }
        BasicInfoObjectDescription info = StorageManager.getInfoObject((String)oid, (String)targetFileLocation, (BasicStorageHints)hints);
        InfoObjectTree newinfo = ConversionUtil.convertInfoObjectTree(info);
        if (locationConfig.getType() == RawContentLocationType.AS_URL && StorageManager.hasRawContent((String)oid)) {
            logger.trace((Object)"Adding ContentUrlProperty");
            LinkedList<PropertyDescription> properties = new LinkedList<PropertyDescription>(Arrays.asList(newinfo.getProperties()));
            PropertyDescription urlProperty = RawContentUtil.getRawContentUrlProperty(newinfo.getObjectID());
            properties.add(urlProperty);
            newinfo.setProperties(properties.toArray(new PropertyDescription[properties.size()]));
        }
        if (info.transportsRawContent()) {
            logger.trace((Object)"Adding raw content");
            newinfo.setRawContent(info.getTemporaryRawContent());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("hops: " + hops));
        }
        if (hops > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("the IO have " + info.getReferencesCollection().size() + " references"));
            }
            List<BasicReferenceDescription> filteredReferences = InfoObjectTreeUtil.filterReferences(info.getReferencesCollection(), walkRules);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("filtered references: " + filteredReferences.size()));
            }
            LinkedList<ReferenceTree> references = new LinkedList<ReferenceTree>();
            --hops;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("new hops value: " + hops));
            }
            for (BasicReferenceDescription reference : filteredReferences) {
                if (reference.getTargetOID().equals(oid)) continue;
                InfoObjectTree subTree = InfoObjectTreeUtil.getInfoObjectTree(reference.getTargetOID(), locationConfig, hints, walkRules, hops);
                ReferenceTree referenceTree = new ReferenceTree();
                referenceTree.setPosition(Integer.valueOf(reference.getPosition()));
                referenceTree.setRole(reference.getRole());
                referenceTree.setSecondaryRole(reference.getSecondaryRole());
                referenceTree.setTargetObject(subTree);
                references.add(referenceTree);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("retrieved " + references.size() + " references"));
            }
            newinfo.setReferences(references.toArray(new ReferenceTree[references.size()]));
        } else {
            logger.trace((Object)"hops limit reached");
            newinfo.setReferences(new ReferenceTree[0]);
        }
        logger.trace((Object)"returning the object");
        return newinfo;
    }

    public static List<BasicReferenceDescription> filterReferences(List<BasicReferenceDescription> references, List<TreeWalkRule> walkRules) {
        LinkedList<BasicReferenceDescription> filteredReferences = new LinkedList<BasicReferenceDescription>();
        for (BasicReferenceDescription reference : references) {
            if (!InfoObjectTreeUtil.toWalk(walkRules, reference)) continue;
            filteredReferences.add(reference);
        }
        return filteredReferences;
    }

    protected static boolean toWalk(List<TreeWalkRule> walkRules, BasicReferenceDescription reference) {
        for (TreeWalkRule rule : walkRules) {
            boolean secondaryRole;
            boolean role = rule.getRole() != null ? rule.getRole().equals(reference.getRole()) : true;
            boolean bl = secondaryRole = rule.getSecondaryRole() != null ? rule.getSecondaryRole().equals(reference.getSecondaryRole()) : true;
            if (!role || !secondaryRole) continue;
            return true;
        }
        return false;
    }
}

