/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.SMSPortType1;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.SMSPortType1Context;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBERetryEquivalentIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBERetrySameIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableObjectNotFoundFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.faults.BaseFaultTypeDescription;

public class FaultUtil {
    private static final Log log = LogFactory.getLog(SMSPortType1.class);

    public static GCUBEFault convertStorageLayerException(StorageLayerException sle) {
        GCUBEUnrecoverableObjectNotFoundFault fault = null;
        if (sle.isMissingObject()) {
            GCUBEUnrecoverableObjectNotFoundFault onff = new GCUBEUnrecoverableObjectNotFoundFault();
            FaultUtil.initBaseFault((BaseFaultType)onff, "Object with id '" + sle.getInvalidValue() + "' could not be found.", sle);
            onff.setMissingObjectID(sle.getInvalidValue());
            fault = onff;
        }
        return null;
    }

    public static void processStorageLayerException(StorageLayerException sle) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
        FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
        FaultUtil.throwIOFault(sle, true);
    }

    public static void initBaseFault(BaseFaultType bf, String errorMsg, Throwable cause) {
        bf.setFaultReason(errorMsg);
        bf.setDescription(FaultUtil.generateFaultDescription(errorMsg));
        FaultUtil.setTrace(bf, cause);
        FaultUtil.setOriginatorAndTime(bf);
    }

    public static void throwValuaNotValidFaultIfAppropriate(StorageLayerException sle) throws GCUBEUnrecoverableValueNotValidFault {
        if (sle.isInvalidValue()) {
            GCUBEUnrecoverableValueNotValidFault vnvft = new GCUBEUnrecoverableValueNotValidFault();
            FaultUtil.initBaseFault((BaseFaultType)vnvft, sle.getMessage(), sle);
            vnvft.setInvalidValue(sle.getInvalidValue());
            vnvft.setInvalidValueName(sle.getInvalidValueName());
            throw vnvft;
        }
    }

    public static void throwObjectNotFoundFaultIfAppropriate(StorageLayerException sle) throws GCUBEUnrecoverableObjectNotFoundFault {
        if (sle.isMissingObject()) {
            GCUBEUnrecoverableObjectNotFoundFault onff = new GCUBEUnrecoverableObjectNotFoundFault();
            FaultUtil.initBaseFault((BaseFaultType)onff, "Object with id '" + sle.getInvalidValue() + "' could not be found.", sle);
            onff.setMissingObjectID(sle.getInvalidValue());
            throw onff;
        }
    }

    public static void throwIOFault(StorageLayerException sle, boolean tryOtherInstance) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        if (sle.resolvableBySameInstance()) {
            GCUBERetrySameIOFault iof = new GCUBERetrySameIOFault();
            FaultUtil.initBaseFault((BaseFaultType)iof, sle.getMessage(), sle);
            iof.setIOSubSystem(sle.getSubSystem());
            throw iof;
        }
        if (sle.resolvableByEquivalentInstance() || tryOtherInstance) {
            GCUBERetryEquivalentIOFault iof = new GCUBERetryEquivalentIOFault();
            FaultUtil.initBaseFault((BaseFaultType)iof, sle.getMessage(), sle);
            iof.setIOSubSystem(sle.getSubSystem());
            throw iof;
        }
        GCUBEUnrecoverableIOFault iof = new GCUBEUnrecoverableIOFault();
        FaultUtil.initBaseFault((BaseFaultType)iof, sle.getMessage(), sle);
        iof.setIOSubSystem(sle.getSubSystem());
        throw iof;
    }

    public static BaseFaultTypeDescription[] generateFaultDescription(String msg) {
        BaseFaultTypeDescription desc = new BaseFaultTypeDescription(msg);
        return new BaseFaultTypeDescription[]{desc};
    }

    public static void setTrace(BaseFaultType bf, Throwable cause) {
        if (bf != null && cause != null && log.isInfoEnabled()) {
            BaseFaultType newbf = new BaseFaultType();
            FaultUtil.initBaseFault(newbf, cause.getMessage(), cause.getCause());
        }
    }

    public static void setOriginatorAndTime(BaseFaultType bf) {
        EndpointReferenceType EPR = null;
        try {
            EPR = FaultUtil.getEndpointReferenceType();
        }
        catch (Exception e) {
            log.debug((Object)"Cannot retrieve EPR");
            e.printStackTrace();
        }
        bf.setOriginator(EPR);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        bf.setTimestamp((Calendar)cal);
    }

    private static EndpointReferenceType getEndpointReferenceType() throws Exception {
        return SMSPortType1Context.getPortTypeContext().getEPR();
    }
}

