/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicReferenceDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.exception.InvalidHintException;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.SMSPortType1;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.FaultUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfString;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.oasis.wsrf.faults.BaseFaultType;

public class ConversionUtil {
    private static final ArrayOfString EMPTY_ARRAY_OF_STRING = new ArrayOfString(new String[0]);
    private static final PropertyDescription[] EMPTY_PROPERTIES = new PropertyDescription[0];
    private static final ReferenceDescription[] EMPTY_REFERENCES = new ReferenceDescription[0];
    private static final Log log = LogFactory.getLog(SMSPortType1.class);

    public static InfoObjectDescription convertInfoObject(BasicInfoObjectDescription info) {
        if (info == null) {
            log.error((Object)"Recieved unforseen null as convertion input.");
        }
        InfoObjectDescription newinfo = new InfoObjectDescription();
        newinfo.setObjectID(info.getObjectID());
        newinfo.setName(info.getName());
        if (newinfo.getName() == null) {
            log.warn((Object)("InfoObject " + info.getObjectID() + " has no name!"));
            newinfo.setName("(unnamed object)");
        }
        newinfo.setType(info.getType());
        newinfo.setProperties(ConversionUtil.convertProperties(info.getPropertyMap()));
        newinfo.setReferences(ConversionUtil.convertReferences(info.getReferencesCollection()));
        return newinfo;
    }

    public static InfoObjectTree convertInfoObjectTree(BasicInfoObjectDescription info) {
        if (info == null) {
            log.error((Object)"Received unforseen null as convertion input.");
            return null;
        }
        InfoObjectTree newinfo = new InfoObjectTree();
        newinfo.setObjectID(info.getObjectID());
        newinfo.setName(info.getName());
        if (newinfo.getName() == null) {
            log.warn((Object)("InfoObject " + info.getObjectID() + " has no name!"));
            newinfo.setName("(unnamed object)");
        }
        newinfo.setType(info.getType());
        newinfo.setProperties(ConversionUtil.convertProperties(info.getPropertyMap()));
        return newinfo;
    }

    public static ReferenceDescription[] convertReferences(List<BasicReferenceDescription> references) {
        if (references == null || references.size() == 0) {
            return EMPTY_REFERENCES;
        }
        ReferenceDescription[] newRefs = new ReferenceDescription[references.size()];
        int i = 0;
        for (BasicReferenceDescription reference : references) {
            newRefs[i++] = ConversionUtil.convertReference(reference);
        }
        return newRefs;
    }

    public static ReferenceDescription convertReference(BasicReferenceDescription ref) {
        if (ref == null) {
            log.error((Object)"Recieved unforseen null as convertion input.");
        }
        ReferenceDescription newref = new ReferenceDescription();
        newref.setSourceObjectID(ref.getSourceOID());
        newref.setTargetObjectID(ref.getTargetOID());
        newref.setRole(ref.getRole());
        if (ref.getSecondaryRole() != null) {
            newref.setSecondaryRole(ref.getSecondaryRole());
        }
        if (ref.getPosition() != -1) {
            newref.setPosition(new Integer(ref.getPosition()));
        }
        newref.setPropagationRule(ref.getPropagationRule());
        return newref;
    }

    public static PropertyDescription[] convertProperties(Map<String, BasicPropertyDescription> properties) {
        if (properties == null || properties.size() == 0) {
            return EMPTY_PROPERTIES;
        }
        PropertyDescription[] newProps = new PropertyDescription[properties.size()];
        int i = 0;
        for (BasicPropertyDescription property : properties.values()) {
            newProps[i++] = ConversionUtil.convertProperty(property);
        }
        return newProps;
    }

    public static PropertyDescription convertProperty(BasicPropertyDescription prop) {
        if (prop == null) {
            log.error((Object)"Recieved unforseen null as convertion input.");
            return null;
        }
        PropertyDescription newprop = new PropertyDescription();
        newprop.setObjectID(prop.getOid());
        newprop.setName(prop.getName());
        newprop.setType(prop.getType());
        newprop.setValue(prop.getValue());
        return newprop;
    }

    public static InfoObjectDescription convertReduced(BasicInfoObjectDescription info) {
        if (info == null) {
            log.error((Object)"Received unforseen null as convertion input.");
            return null;
        }
        InfoObjectDescription newinfo = new InfoObjectDescription();
        newinfo.setObjectID(info.getObjectID());
        newinfo.setName(info.getName());
        newinfo.setType(info.getType());
        return newinfo;
    }

    public static BasicStorageHints convertHints(StorageHint[] hints) throws InvalidHintException {
        BasicStorageHints bsh = new BasicStorageHints();
        if (hints == null) {
            return bsh;
        }
        for (int i = 0; i < hints.length; ++i) {
            if (hints[i].getName() == null) {
                String errorMsg = "Invalid hint[" + i + "]: Hint name was null, value was " + hints[i].getValue() + "!";
                throw new InvalidHintException(errorMsg, hints[i].getValue(), "contentmanagement:hint");
            }
            if (hints[i].getValue() == null) {
                String errorMsg = "Invalid hint[" + i + "]: Hint '" + hints[i].getName() + "' has no value; value is mandatory, null is never allowed as a value.";
                throw new InvalidHintException(errorMsg, hints[i].getValue(), "contentmanagement:hint");
            }
            bsh.addHint(hints[i].getName(), hints[i].getValue());
        }
        return bsh;
    }

    public static BasicStorageHints convertHints(List<StorageHint> hints) throws InvalidHintException {
        BasicStorageHints bsh = new BasicStorageHints();
        if (hints == null) {
            return bsh;
        }
        for (int i = 0; i < hints.size(); ++i) {
            if (hints.get(i).getName() == null) {
                String errorMsg = "Invalid hint[" + i + "]: Hint name was null, value was " + hints.get(i).getValue() + "!";
                throw new InvalidHintException(errorMsg, hints.get(i).getValue(), "contentmanagement:hint");
            }
            if (hints.get(i).getValue() == null) {
                String errorMsg = "Invalid hint[" + i + "]: Hint '" + hints.get(i).getName() + "' has no value; value is mandatory, null is never allowed as a value.";
                throw new InvalidHintException(errorMsg, hints.get(i).getValue(), "contentmanagement:hint");
            }
            bsh.addHint(hints.get(i).getName(), hints.get(i).getValue());
        }
        return bsh;
    }

    public static GCUBEUnrecoverableValueNotValidFault convertToGCUBEFault(InvalidHintException e) {
        GCUBEUnrecoverableValueNotValidFault vnvft = new GCUBEUnrecoverableValueNotValidFault();
        FaultUtil.initBaseFault((BaseFaultType)vnvft, e.getMessage(), null);
        vnvft.setInvalidValue(e.getInvalidValue());
        vnvft.setInvalidValueName(e.getInvalidValueName());
        return vnvft;
    }

    public static StorageHint[] convertHints(BasicStorageHints hints) {
        StorageHint[] sh;
        if (hints == null) {
            sh = new StorageHint[]{};
        } else {
            Set hintNames = hints.getHintNames();
            sh = new StorageHint[hintNames.size()];
            Iterator nameIt = hintNames.iterator();
            int i = 0;
            while (nameIt.hasNext()) {
                StorageHint newhint = new StorageHint();
                newhint.setName((String)nameIt.next());
                newhint.setValue(hints.getHintValue(newhint.getName()));
                sh[i++] = newhint;
            }
        }
        return sh;
    }

    public static ArrayOfString convertStringCollection(Collection strings) {
        if (strings == null || strings.size() == 0) {
            return EMPTY_ARRAY_OF_STRING;
        }
        ArrayOfString r = new ArrayOfString(strings.toArray(new String[strings.size()]));
        return r;
    }
}

