/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs;

import com.thoughtworks.xstream.XStream;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;

public class RSSenderIterator<T>
implements Runnable {
    protected GCUBELog logger = new GCUBELog(RSSenderIterator.class);
    protected Iterator<T> input;
    protected RecordWriter<GenericRecord> writer;
    protected XStream stream;
    protected long timeout;

    public RSSenderIterator(Iterator<T> input, RecordWriter<GenericRecord> writer, long timeout) {
        this.input = input;
        this.writer = writer;
        this.timeout = timeout;
        this.stream = new XStream();
    }

    @Override
    public void run() {
        this.logger.trace((Object)"Starting sending items");
        long startTime = System.currentTimeMillis();
        long counter = 0L;
        boolean terminate = false;
        while (this.input.hasNext() && !terminate) {
            T item = this.input.next();
            try {
                GenericRecord record;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("sending " + counter + " element"));
                }
                boolean bl = terminate = !this.writer.put((Record)(record = this.createRecord(item)), this.timeout, TimeUnit.SECONDS);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(counter + " sent; terminate: " + terminate));
                }
                ++counter;
            }
            catch (Exception e) {
                this.logger.warn((Object)"Error processing item", (Throwable)e);
            }
        }
        this.logger.info((Object)("sending complete in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds"));
        try {
            this.writer.close();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error closing RSWriter", (Throwable)e);
        }
        this.logger.trace((Object)"rs closed");
    }

    protected GenericRecord createRecord(T item) throws Exception {
        String value = this.stream.toXML(item);
        GenericRecord record = new GenericRecord();
        record.setFields(new Field[]{new StringField(value)});
        return record;
    }
}

