/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs;

import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.SMSIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.InfoObjectTreeUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.TreeWalkRule;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;

public class InfoObjectDescriptionTreeIterator
extends SMSIterator<InfoObjectTree, String> {
    protected RawContentLocationConfig contentLocation;
    protected BasicStorageHints hints;
    protected List<TreeWalkRule> walkRules;
    protected int hops;

    public InfoObjectDescriptionTreeIterator(GCUBELog logger, Iterator<String> inputIterator, RawContentLocationConfig contentLocation, BasicStorageHints hints, List<TreeWalkRule> walkRules, int hops) {
        super(logger, inputIterator);
        this.hints = hints;
        this.walkRules = walkRules;
        this.contentLocation = contentLocation;
        this.hops = hops;
        logger.trace((Object)("contentLocation: " + contentLocation));
    }

    @Override
    public InfoObjectTree generateNext(String input) {
        this.logger.debug((Object)("getting IO " + input));
        long start = System.currentTimeMillis();
        try {
            InfoObjectTree ioTree = InfoObjectTreeUtil.getInfoObjectTree(input, this.contentLocation, this.hints, this.walkRules, this.hops);
            this.logger.debug((Object)("returning IO in " + (System.currentTimeMillis() - start)));
            return ioTree;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving the tree", (Throwable)e);
            return null;
        }
    }
}

