/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.FilterChainComposer;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.SMSIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertiesFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.ConversionUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.HintsUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.RawContentUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInMessageConditional;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationType;

public class InfoObjectDescriptionIterator
extends SMSIterator<InfoObjectDescription, String> {
    protected RawContentLocationConfig contentLocation;
    protected String targetFileLocation;
    protected BasicStorageHints hints;

    public InfoObjectDescriptionIterator(GCUBELog logger, Iterator<String> inputIterator, RawContentLocationConfig contentLocation, BasicStorageHints hints) {
        super(logger, inputIterator);
        this.contentLocation = contentLocation;
        this.hints = hints;
        this.contentLocation = contentLocation;
        this.targetFileLocation = RawContentUtil.getTargetFileLocation(contentLocation);
        logger.trace((Object)("contentLocation: " + contentLocation + ", targetFileLocation: " + this.targetFileLocation));
    }

    @Override
    public InfoObjectDescription generateNext(String input) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("getting IO " + input));
        }
        try {
            InfoObjectDescription newinfo;
            if (this.contentLocation.getType() == RawContentLocationType.INMESSAGE_CONDITIONAL) {
                Map properties = StorageManager.retrieveObjectStorageProperties((String)input);
                RawContentInMessageConditional conditional = (RawContentInMessageConditional)this.contentLocation;
                PropertiesFilter filter = FilterChainComposer.convertToPropertyFilter(conditional.getPropertyCondition());
                if (filter.accept(properties)) {
                    this.targetFileLocation = "inmessage://";
                }
            }
            BasicInfoObjectDescription info = StorageManager.getInfoObject((String)input, (String)this.targetFileLocation, (BasicStorageHints)this.hints);
            if (HintsUtil.requestsFor("return-plain-object", this.hints)) {
                this.hints.addHint("do-not-return-hints", BasicStorageHints.HINT_VALUE_TRUE);
                newinfo = ConversionUtil.convertReduced(info);
            } else {
                newinfo = ConversionUtil.convertInfoObject(info);
            }
            if (this.contentLocation.getType() == RawContentLocationType.AS_URL) {
                LinkedList<PropertyDescription> properties = new LinkedList<PropertyDescription>(Arrays.asList(newinfo.getProperties()));
                PropertyDescription urlProperty = RawContentUtil.getRawContentUrlProperty(newinfo.getObjectID());
                properties.add(urlProperty);
                newinfo.setProperties(properties.toArray(new PropertyDescription[properties.size()]));
            }
            if (info.transportsRawContent()) {
                newinfo.setRawContent(info.getTemporaryRawContent());
            }
            if (!HintsUtil.requestsFor("do-not-return-hints", this.hints)) {
                BasicStorageHints consumed = this.hints.getConsumedHints();
                newinfo.setConsumedHints(ConversionUtil.convertHints(consumed));
                if (this.logger.isDebugEnabled()) {
                    for (String hintName : consumed.getHintNames()) {
                        String hintValue = consumed.getHintValue(hintName);
                        this.logger.debug((Object)("Used hint: " + hintName + "=" + hintValue));
                    }
                }
            }
            this.logger.trace((Object)"returning the object");
            return newinfo;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error getting IOD " + input), (Throwable)e);
            return null;
        }
    }
}

