/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs;

import java.util.Iterator;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.SMSIterator;

public class CreationTimePropertyFilterIterator
extends SMSIterator<String, String> {
    protected Long startTimestamp;
    protected Long endTimestamp;

    public CreationTimePropertyFilterIterator(GCUBELog logger, Iterator<String> inputIterator, Long startTimestamp, Long endTimestamp) {
        super(logger, inputIterator);
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    @Override
    public String generateNext(String input) {
        BasicPropertyDescription updateTimeProperty = null;
        try {
            updateTimeProperty = StorageManager.retrieveStorageProperty((String)input, (String)"contentmanagement:ObjectCreatedMillis");
        }
        catch (StorageLayerException sle) {
            this.logger.error((Object)("Error getting object property oid: " + input), (Throwable)sle);
            return null;
        }
        long lastUpdate = Long.parseLong(updateTimeProperty.getValue());
        if (!(this.startTimestamp != null && lastUpdate <= this.startTimestamp || this.endTimestamp != null && lastUpdate >= this.endTimestamp)) {
            return input;
        }
        return null;
    }
}

