/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex;

import java.util.Map;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertiesFilter;

public class TimeInMillisecondsPropertyValueFilter
implements PropertiesFilter {
    protected String propertyName;
    protected long propertyValue;

    public TimeInMillisecondsPropertyValueFilter(String propertyName, long propertyValue) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @Override
    public boolean accept(Map<String, BasicPropertyDescription> properties) {
        if (!properties.containsKey(this.propertyName)) {
            return false;
        }
        BasicPropertyDescription propertyDescription = properties.get(this.propertyName);
        if (propertyDescription.getType() != null && propertyDescription.getType().equals("contentmanagement:TimeInMilliseconds")) {
            long value = Long.parseLong(propertyDescription.getValue());
            return this.propertyValue == value;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeInMillisecondsPropertyValueFilter [propertyName=");
        builder.append(this.propertyName);
        builder.append(", propertyValue=");
        builder.append(this.propertyValue);
        builder.append("]");
        return builder.toString();
    }
}

