/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex;

import java.util.Map;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertiesFilter;

public class TimeInMillisecondsPropertyValueBetweenFilter
implements PropertiesFilter {
    protected String propertyName;
    protected Long lowerBound;
    protected Long upperBound;

    public TimeInMillisecondsPropertyValueBetweenFilter(String propertyName, Long lowerBound, Long upperBound) {
        this.propertyName = propertyName;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean accept(Map<String, BasicPropertyDescription> properties) {
        if (!properties.containsKey(this.propertyName)) {
            return false;
        }
        BasicPropertyDescription propertyDescription = properties.get(this.propertyName);
        if (propertyDescription.getType() != null && propertyDescription.getType().equals("contentmanagement:TimeInMilliseconds")) {
            long value = Long.parseLong(propertyDescription.getValue());
            return !(this.lowerBound != null && value <= this.lowerBound || this.upperBound != null && value >= this.upperBound);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeInMillisecondsPropertyValueBetweenFilter [lowerBound=");
        builder.append(this.lowerBound);
        builder.append(", propertyName=");
        builder.append(this.propertyName);
        builder.append(", upperBound=");
        builder.append(this.upperBound);
        builder.append("]");
        return builder.toString();
    }
}

