/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class SMSIterator<O, I>
implements Iterator<O> {
    protected GCUBELog logger;
    protected Iterator<I> inputIterator;
    protected O next = null;
    protected boolean nextConsumed = true;

    public SMSIterator(GCUBELog logger, Iterator<I> inputIterator) {
        this.logger = logger;
        this.inputIterator = inputIterator;
    }

    public abstract O generateNext(I var1);

    protected boolean updateNext() {
        this.next = this.getNext();
        this.nextConsumed = false;
        return this.next != null;
    }

    protected O getNext() {
        while (this.inputIterator.hasNext()) {
            I input = this.inputIterator.next();
            O output = this.generateNext(input);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextConsumed) {
            return this.updateNext();
        }
        return this.next != null;
    }

    @Override
    public O next() {
        boolean updated;
        if (this.nextConsumed && !(updated = this.updateNext())) {
            throw new NoSuchElementException();
        }
        this.nextConsumed = true;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

