/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter;

import java.util.Iterator;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.SMSIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceTargetFilter;

public class ReferenceTargetFilterIterator
extends SMSIterator<String, String> {
    protected ReferenceTargetFilter referenceFilter;

    public ReferenceTargetFilterIterator(GCUBELog logger, Iterator<String> inputIterator, ReferenceTargetFilter referenceFilter) {
        super(logger, inputIterator);
        this.referenceFilter = referenceFilter;
    }

    @Override
    public String generateNext(String input) {
        try {
            boolean exist = StorageManager.existsReference((String)input, (String)this.referenceFilter.getTargetOid(), (String)this.referenceFilter.getPrimaryRole(), (String)this.referenceFilter.getSecondaryRole());
            if (exist) {
                return input;
            }
            return null;
        }
        catch (StorageLayerException e) {
            this.logger.error((Object)("Error checking reference " + this.referenceFilter), (Throwable)e);
            return null;
        }
    }
}

