/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter;

import java.util.Iterator;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.SMSIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertiesFilter;

public class PropertyFilterIterator
extends SMSIterator<String, String> {
    protected PropertiesFilter propertyFilter;

    public PropertyFilterIterator(GCUBELog logger, Iterator<String> inputIterator, PropertiesFilter propertyFilter) {
        super(logger, inputIterator);
        this.propertyFilter = propertyFilter;
    }

    @Override
    public String generateNext(String input) {
        try {
            Map properties = StorageManager.retrieveObjectStorageProperties((String)input);
            if (this.propertyFilter.accept(properties)) {
                return input;
            }
        }
        catch (StorageLayerException e) {
            this.logger.error((Object)"Error getting IO properties", (Throwable)e);
        }
        return null;
    }
}

