/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceSourceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceTargetFilter;

public class HeadFilterIterator
implements Iterator<String> {
    protected GCUBELog logger;
    protected boolean initialized = false;
    protected List<String> oids;
    protected Iterator<String> oidIterator;
    protected SMSFilter headFilter;

    public HeadFilterIterator(GCUBELog logger, SMSFilter headFilter) {
        this.logger = logger;
        this.headFilter = headFilter;
    }

    protected void initialize() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("initializing the HeadFilter (" + this.headFilter + ")"));
        }
        try {
            this.oids = this.retrieveFilterOids();
        }
        catch (StorageLayerException e) {
            this.logger.warn((Object)"Error getting the oid list", (Throwable)e);
            this.oids = Collections.emptyList();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("found " + this.oids.size() + " oids"));
        }
        this.oidIterator = this.oids.iterator();
        this.initialized = true;
    }

    protected List<String> retrieveFilterOids() throws StorageLayerException {
        switch (this.headFilter.getType()) {
            case PROPERTY_FILTER: {
                throw new IllegalArgumentException("The propertyFilter can't be used as head filter.");
            }
            case REFERENCE_FILTER: {
                ReferenceFilter referenceFilter = (ReferenceFilter)this.headFilter;
                return this.retrieveReferenceFilterOids(referenceFilter);
            }
        }
        throw new IllegalArgumentException("Unknown filter: " + this.headFilter);
    }

    protected List<String> retrieveReferenceFilterOids(ReferenceFilter referenceFilter) throws StorageLayerException {
        String secondaryRole;
        String primaryRole = referenceFilter.getPrimaryRole();
        if (primaryRole == null) {
            primaryRole = "*";
        }
        if ((secondaryRole = referenceFilter.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        switch (referenceFilter.getReferenceFilterType()) {
            case SOURCE_FILTER: {
                ReferenceSourceFilter sourceFilter = (ReferenceSourceFilter)referenceFilter;
                String sourceOid = sourceFilter.getSourceOid();
                return StorageManager.retrieveReferredTargetOIDs((String)sourceOid, (String)primaryRole, (String)primaryRole);
            }
            case TARGET_FILTER: {
                ReferenceTargetFilter targetFilter = (ReferenceTargetFilter)referenceFilter;
                String targetOid = targetFilter.getTargetOid();
                return StorageManager.retrieveReferredSourceOIDs((String)targetOid, (String)primaryRole, (String)secondaryRole);
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)referenceFilter.getReferenceFilterType()) + ".");
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.oidIterator.hasNext();
    }

    @Override
    public String next() {
        if (!this.initialized) {
            this.initialize();
        }
        String next = this.oidIterator.next();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("[HeadFilterIterator] next: " + next));
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

