/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter;

import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.HeadFilterIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.PropertyFilterIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.ReferenceSourceFilterIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.ReferenceTargetFilterIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.AndFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.BooleanPropertyValueFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.NotFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.OrFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertiesFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.PropertyExistFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.StringPropertyValueFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.TimeInMillisecondsPropertyValueBetweenFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.complex.TimeInMillisecondsPropertyValueFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.AndCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.BooleanPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.NotCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.OrCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyExistenceCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.StringPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.TimeInMillisecondsPropertyValueBetweenCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.TimeInMillisecondsPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceSourceFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceTargetFilter;

public class FilterChainComposer {
    protected GCUBELog logger;

    public FilterChainComposer(GCUBELog logger) {
        this.logger = logger;
    }

    public Iterator<String> composeChain(List<SMSFilter> filters) {
        this.logger.trace((Object)("compose filter chain with " + filters.size() + " filters"));
        if (filters.size() == 0) {
            throw new IllegalArgumentException("No filters specified");
        }
        Iterator<String> parent = this.getHeadFilterIterator(filters.get(0));
        this.logger.trace((Object)("composing the remaining chain: " + (filters.size() - 1)));
        for (int i = 1; i < filters.size(); ++i) {
            parent = this.addChain(parent, filters.get(i));
        }
        return parent;
    }

    protected Iterator<String> addChain(Iterator<String> parent, SMSFilter filter) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("adding " + filter + " to chain"));
        }
        switch (filter.getType()) {
            case REFERENCE_FILTER: {
                return this.addReferenceChain(parent, (ReferenceFilter)filter);
            }
            case PROPERTY_FILTER: {
                return this.addPropertyChain(parent, (PropertyFilter)filter);
            }
        }
        throw new IllegalArgumentException("Unknow filter type: " + filter);
    }

    protected Iterator<String> addReferenceChain(Iterator<String> parent, ReferenceFilter referenceFilter) {
        switch (referenceFilter.getReferenceFilterType()) {
            case SOURCE_FILTER: {
                return new ReferenceSourceFilterIterator(this.logger, parent, (ReferenceSourceFilter)referenceFilter);
            }
            case TARGET_FILTER: {
                return new ReferenceTargetFilterIterator(this.logger, parent, (ReferenceTargetFilter)referenceFilter);
            }
        }
        throw new IllegalArgumentException("Unknow filter type: " + referenceFilter);
    }

    protected Iterator<String> addPropertyChain(Iterator<String> parent, PropertyFilter propertyFilter) {
        PropertiesFilter filter = FilterChainComposer.convertToPropertyFilter(propertyFilter.getPropertyCondition());
        return new PropertyFilterIterator(this.logger, parent, filter);
    }

    protected HeadFilterIterator getHeadFilterIterator(SMSFilter filter) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("getHeadFilterIterator for filter: " + filter));
        }
        return new HeadFilterIterator(this.logger, filter);
    }

    public static PropertiesFilter convertToPropertyFilter(PropertyCondition condition) {
        switch (condition.getConditionType()) {
            case AND: {
                AndCondition andCondition = (AndCondition)condition;
                PropertiesFilter leftFilter = FilterChainComposer.convertToPropertyFilter(andCondition.getLeftCondition());
                PropertiesFilter rightFilter = FilterChainComposer.convertToPropertyFilter(andCondition.getRightCondition());
                return new AndFilter(leftFilter, rightFilter);
            }
            case OR: {
                OrCondition orCondition = (OrCondition)condition;
                PropertiesFilter leftFilter = FilterChainComposer.convertToPropertyFilter(orCondition.getLeftCondition());
                PropertiesFilter rightFilter = FilterChainComposer.convertToPropertyFilter(orCondition.getRightCondition());
                return new OrFilter(leftFilter, rightFilter);
            }
            case NOT: {
                NotCondition notCondition = (NotCondition)condition;
                PropertiesFilter filter = FilterChainComposer.convertToPropertyFilter(notCondition);
                return new NotFilter(filter);
            }
            case BOOLEAN_PROPERTY_VALUE: {
                BooleanPropertyValueCondition booleanCondition = (BooleanPropertyValueCondition)condition;
                return new BooleanPropertyValueFilter(booleanCondition.getPropertyName(), booleanCondition.getPropertyValue());
            }
            case STRING_PROPERTY_VALUE: {
                StringPropertyValueCondition stringCondition = (StringPropertyValueCondition)condition;
                return new StringPropertyValueFilter(stringCondition.getPropertyName(), stringCondition.getPropertyValue());
            }
            case TIME_IN_MILLISECONDS_PROPERTY_VALUE: {
                TimeInMillisecondsPropertyValueCondition timeCondition = (TimeInMillisecondsPropertyValueCondition)condition;
                return new TimeInMillisecondsPropertyValueFilter(timeCondition.getPropertyName(), timeCondition.getPropertyValue());
            }
            case TIME_IN_MILLISECONDS_PROPERTY_VALUE_BETWEEN: {
                TimeInMillisecondsPropertyValueBetweenCondition timeCondition = (TimeInMillisecondsPropertyValueBetweenCondition)condition;
                return new TimeInMillisecondsPropertyValueBetweenFilter(timeCondition.getPropertyName(), timeCondition.getLowerBound(), timeCondition.getUpperBound());
            }
            case PROPERTY_EXIST: {
                PropertyExistenceCondition existenceCondition = (PropertyExistenceCondition)condition;
                return new PropertyExistFilter(existenceCondition.getPropertyName());
            }
        }
        throw new IllegalArgumentException("Unknown condition " + condition);
    }
}

