/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBean;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicReferenceDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.StorageManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.exception.InvalidHintException;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.SMSServiceContext;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.ConversionUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.FaultUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.HintsUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfBulkReferenceResultItem;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfByPropertyValueSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfCreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfFailedObjects;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfFileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfFlexibleReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfInfoOIDAndHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfInfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfPropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfReferenceDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfSourceReferenceResultItem;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfSourceReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfString;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfTargetReferenceResultItem;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ArrayOfTargetReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.BulkReferenceResultItem;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ByPropertyValueSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreatePropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateReferenceDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FailedObject;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FlexibleReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBERetryEquivalentIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBERetrySameIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableObjectNotFoundFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GetVolatileInformationParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectIDAndConsumedHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.NameAndType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertySelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SourceReferenceResultItem;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SourceReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.TargetReferenceResultItem;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.TargetReferenceSelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.VoidType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.VolatileInformation;

public class SMSPortType1
extends GCUBEPortType {
    public static final String REQUEST_FAILED_NAME = null;
    public static final String ERROR_ELEMENTNAME = "DiligentErrorType";
    public static final String ERROR_RETRY_SAME = "RETRY_SAME";
    public static final String ERROR_RETRY_EQUIVALENT = "RETRY_EQUIVALENT";
    public static final String ERROR_UNRECOVERABLE = "UNRECOVERABLE";
    public static final String SUBSYSTEM_RS = "ResultSet handling";
    private final int BULK_INPUTS_PER_PART = -1;
    private final int RS_READ_TIMEOUT = 900000;
    private static final VoidType VOID = new VoidType();
    private static final ArrayOfString EMPTY_ARRAY_OF_STRING = new ArrayOfString(new String[0]);
    public static final BasicStorageHints NO_REFRENCES;
    private static final ArrayOfInfoObjectDescription NO_INFO_OBJECT_DESCRIPTIONS;
    private static final Log log;

    protected GCUBEServiceContext getServiceContext() {
        return SMSServiceContext.getContext();
    }

    public String createInfoObject(NameAndType parameters) throws GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        BasicStorageHints hints;
        log.info((Object)"Creating new info object with name and type");
        String name = parameters.getName();
        String type = parameters.getType();
        log.trace((Object)("name: " + name));
        log.trace((Object)("type: " + type));
        try {
            hints = ConversionUtil.convertHints(parameters.getHints());
        }
        catch (InvalidHintException e) {
            log.error((Object)"Error converting hints", (Throwable)e);
            GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
            throw vnvft;
        }
        String oid = null;
        try {
            oid = StorageManager.createInfoObject((String)name, (String)type, (BasicStorageHints)hints);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return oid;
    }

    public InfoObjectIDAndConsumedHints createInfoObjectWithContent(CreateInfoObjectReferencesProperties parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        CreatePropertyDescription[] props;
        BasicStorageHints hints;
        log.info((Object)"Creating new info object for creation with content ...");
        String name = parameters.getName();
        String type = parameters.getType();
        log.trace((Object)("name: " + name + " type: " + type));
        try {
            hints = ConversionUtil.convertHints(parameters.getStorageHints());
        }
        catch (InvalidHintException e) {
            log.error((Object)"Error converting hints", (Throwable)e);
            GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
            throw vnvft;
        }
        String newObjectID = null;
        try {
            newObjectID = StorageManager.createInfoObject((String)name, (String)type, (BasicStorageHints)hints);
        }
        catch (StorageLayerException sle) {
            log.error((Object)"Error creating the info object", (Throwable)sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        InfoObjectIDAndConsumedHints r = new InfoObjectIDAndConsumedHints();
        r.setObjectID(newObjectID);
        r.setConsumedHints(ConversionUtil.convertHints(hints.getConsumedHints()));
        r.setSuccessful(true);
        log.debug((Object)("New info object with ID " + newObjectID + " created."));
        CreateReferenceDescription[] refs = parameters.getReferences();
        if (refs != null) {
            log.debug((Object)("Adding " + refs.length + " references for new object '" + newObjectID + "'..."));
            for (int i = 0; i < refs.length; ++i) {
                ReferenceDescription rd = new ReferenceDescription();
                if (refs[i].isNewObjectSource()) {
                    rd.setSourceObjectID(newObjectID);
                    rd.setTargetObjectID(refs[i].getOtherObjectID());
                } else {
                    rd.setTargetObjectID(newObjectID);
                    rd.setSourceObjectID(refs[i].getOtherObjectID());
                }
                rd.setRole(refs[i].getRole());
                rd.setSecondaryRole(refs[i].getSecondaryRole());
                rd.setPosition(refs[i].getPosition());
                rd.setPropagationRule(refs[i].getPropagationRule());
                try {
                    this.internalAddReference(rd);
                    continue;
                }
                catch (StorageLayerException sle) {
                    log.error((Object)("Error adding the reference " + i), (Throwable)sle);
                    this.cleanUp(newObjectID);
                    FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
                    FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
                    FaultUtil.throwIOFault(sle, true);
                }
            }
        }
        if (parameters.getRawContent() != null || parameters.getFileLocation() != null && !"/dev/null".equalsIgnoreCase(parameters.getFileLocation())) {
            log.debug((Object)"Adding raw content.");
            FileTransferParameters ftp = new FileTransferParameters();
            ftp.setObjectID(newObjectID);
            ftp.setFileLocation(parameters.getFileLocation());
            ftp.setRawContent(parameters.getRawContent());
            ftp.setStorageHints(parameters.getStorageHints());
            try {
                StorageHint[] consumedHints = this.iternalAssociateRawContent(ftp);
                r.setConsumedHints(consumedHints);
            }
            catch (StorageLayerException e) {
                log.error((Object)"Error adding raw content", (Throwable)e);
                this.cleanUp(newObjectID);
                FaultUtil.throwObjectNotFoundFaultIfAppropriate(e);
                FaultUtil.throwValuaNotValidFaultIfAppropriate(e);
                FaultUtil.throwIOFault(e, true);
            }
            catch (InvalidHintException e) {
                log.error((Object)"Error adding raw content", (Throwable)e);
                this.cleanUp(newObjectID);
                throw ConversionUtil.convertToGCUBEFault(e);
            }
        }
        if ((props = parameters.getProperties()) != null) {
            log.debug((Object)("Setting " + props.length + " properties for new object '" + newObjectID + "'..."));
            PropertyDescription pd = new PropertyDescription();
            pd.setObjectID(newObjectID);
            for (int i = 0; i < props.length; ++i) {
                pd.setName(props[i].getName());
                pd.setType(props[i].getType());
                pd.setValue(props[i].getValue());
                try {
                    this.setStorageProperty(pd);
                    continue;
                }
                catch (GCUBEUnrecoverableObjectNotFoundFault onf) {
                    this.cleanUp(newObjectID);
                    throw onf;
                }
                catch (GCUBEUnrecoverableValueNotValidFault vnv) {
                    this.cleanUp(newObjectID);
                    throw vnv;
                }
                catch (GCUBERetrySameIOFault iof) {
                    this.cleanUp(newObjectID);
                    throw iof;
                }
                catch (GCUBERetryEquivalentIOFault iof) {
                    this.cleanUp(newObjectID);
                    throw iof;
                }
                catch (GCUBEUnrecoverableIOFault iof) {
                    this.cleanUp(newObjectID);
                    throw iof;
                }
            }
        }
        log.debug((Object)"Done creating info object with content.");
        return r;
    }

    public ArrayOfInfoOIDAndHints createInfoObjectsWithContent(ArrayOfCreateInfoObjectReferencesProperties parameters) throws GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfInfoOIDAndHints results = new ArrayOfInfoOIDAndHints();
        if (parameters != null) {
            CreateInfoObjectReferencesProperties[] requests = parameters.getCreateInfoObjects();
            InfoObjectIDAndConsumedHints[] answer = new InfoObjectIDAndConsumedHints[requests.length];
            for (int i = 0; i < requests.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + requests.length + " of bulk..."));
                try {
                    answer[i] = this.createInfoObjectWithContent(requests[i]);
                    answer[i].setSuccessful(true);
                    continue;
                }
                catch (RemoteException re) {
                    answer[i] = new InfoObjectIDAndConsumedHints();
                    answer[i].setSuccessful(false);
                    log.error((Object)("Could not fulfill request " + i + "."), (Throwable)re);
                    answer[i].setObjectID(null);
                    answer[i].setConsumedHints(this.generateHintArrayWithErrorMsg(re));
                }
            }
            results.setInfoOIDAndHints(answer);
        }
        return results;
    }

    public String createInfoObjectsWithContentRS(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        return this.processInBackground(parameters, new CreateObjectWithContentProcessor());
    }

    public boolean removeInfoObject(String objectID) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            log.debug((Object)("Removing info object " + objectID));
            return StorageManager.removeInfoObject((String)objectID);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    public boolean removeInfoObjectAsync(String objectID) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        log.debug((Object)("removing info object " + objectID + " asynchronously"));
        try {
            StorageManager.existsInfoObject((String)objectID);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwIOFault(sle, true);
        }
        Thread t = new Thread(new BackgroundObjectRemover(objectID));
        this.getServiceContext().setScope(t, this.getServiceContext().getScope());
        t.start();
        return true;
    }

    public ArrayOfFailedObjects removeInfoObjects(ArrayOfString parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfFailedObjects results = new ArrayOfFailedObjects();
        if (parameters != null) {
            String[] oids = parameters.getStrings();
            ArrayList<FailedObject> failed = new ArrayList<FailedObject>();
            for (int i = 0; i < oids.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + oids.length + " of bulk..."));
                try {
                    this.removeInfoObject(oids[i]);
                    continue;
                }
                catch (RemoteException re) {
                    FailedObject f = new FailedObject();
                    f.setObjectID(oids[i]);
                    log.error((Object)("Could not fulfill request " + i + "."), (Throwable)re);
                    f.setErrorMessage(this.generateHintArrayWithErrorMsg(re)[0]);
                    failed.add(f);
                }
            }
            results.setFailedObjects(failed.toArray(new FailedObject[failed.size()]));
        } else {
            results.setFailedObjects(new FailedObject[0]);
        }
        return results;
    }

    public String removeInfoObjectsRS(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        return this.processInBackground(parameters, new RemoveObjectProcessor());
    }

    public InfoObjectDescription getInfoObject(FileTransferParameters params) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        InfoObjectDescription newinfo;
        BasicStorageHints hints;
        String oid = params.getObjectID();
        String location = params.getFileLocation();
        try {
            hints = ConversionUtil.convertHints(params.getStorageHints());
        }
        catch (InvalidHintException e) {
            log.error((Object)"Error converting hints", (Throwable)e);
            GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
            throw vnvft;
        }
        log.debug((Object)("Getting object (" + oid + ") and storing at location '" + location + "' using hints " + hints));
        BasicInfoObjectDescription info = null;
        try {
            info = StorageManager.getInfoObject((String)oid, (String)location, (BasicStorageHints)hints);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        if (HintsUtil.requestsFor("return-plain-object", hints)) {
            hints.addHint("do-not-return-hints", BasicStorageHints.HINT_VALUE_TRUE);
            newinfo = ConversionUtil.convertReduced(info);
        } else {
            newinfo = ConversionUtil.convertInfoObject(info);
        }
        if (info.transportsRawContent()) {
            newinfo.setRawContent(info.getTemporaryRawContent());
        }
        if (!HintsUtil.requestsFor("do-not-return-hints", hints)) {
            BasicStorageHints consumed = hints.getConsumedHints();
            newinfo.setConsumedHints(ConversionUtil.convertHints(consumed));
            if (log.isDebugEnabled()) {
                for (String hintName : consumed.getHintNames()) {
                    String hintValue = consumed.getHintValue(hintName);
                    log.debug((Object)("Used hint: " + hintName + "=" + hintValue));
                }
            }
        }
        return newinfo;
    }

    public ArrayOfInfoObjectDescription getInfoObjects(ArrayOfFileTransferParameters parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfInfoObjectDescription r = new ArrayOfInfoObjectDescription();
        if (parameters != null && parameters.getFileTransferParameters() != null) {
            FileTransferParameters[] ftps = parameters.getFileTransferParameters();
            InfoObjectDescription[] result = new InfoObjectDescription[ftps.length];
            for (int i = 0; i < ftps.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + ftps.length + " of bulk..."));
                try {
                    result[i] = this.getInfoObject(ftps[i]);
                    continue;
                }
                catch (RemoteException re) {
                    log.warn((Object)("Excpetion for getInfoObjects[" + i + "]:" + re.getMessage()));
                    log.debug((Object)re);
                    result[i] = new InfoObjectDescription();
                    result[i].setObjectID(ftps[i].getObjectID());
                    result[i].setName(REQUEST_FAILED_NAME);
                    result[i].setConsumedHints(this.generateHintArrayWithErrorMsg(re));
                }
            }
            r.setInfoObjectDescriptions(result);
        }
        return r;
    }

    public String getInfoObjectsRS(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        return this.processInBackground(parameters, new GetObjectProcessor());
    }

    public VoidType associateRawContent(FileTransferParameters params) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        StorageHint[] hints = null;
        try {
            hints = this.iternalAssociateRawContent(params);
        }
        catch (StorageLayerException sle) {
            log.error((Object)"Error associating the raw content", (Throwable)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        catch (InvalidHintException e) {
            log.error((Object)"Error converting hints", (Throwable)e);
            GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
            throw vnvft;
        }
        return new VoidType(hints);
    }

    public StorageHint[] iternalAssociateRawContent(FileTransferParameters params) throws StorageLayerException, InvalidHintException {
        String oid = params.getObjectID();
        String location = params.getFileLocation();
        BasicStorageHints hints = ConversionUtil.convertHints(params.getStorageHints());
        log.debug((Object)("Associating Raw Content at " + location + " to  " + oid + " with hints " + hints));
        byte[] rawContent = params.getRawContent();
        if (rawContent != null) {
            StorageManager.associateRawContent((String)oid, (byte[])rawContent, (BasicStorageHints)hints);
        } else {
            StorageManager.associateRawContent((String)oid, (String)location, (BasicStorageHints)hints);
        }
        return ConversionUtil.convertHints(hints.getConsumedHints());
    }

    public VoidType updateRawContent(FileTransferParameters params) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        BasicStorageHints hints;
        log.info((Object)"updateRawContent");
        String oid = params.getObjectID();
        String location = params.getFileLocation();
        try {
            hints = ConversionUtil.convertHints(params.getStorageHints());
        }
        catch (InvalidHintException e) {
            log.error((Object)"Error converting hints", (Throwable)e);
            GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
            throw vnvft;
        }
        log.debug((Object)("Updating Raw Document at " + location + " to  " + oid + " with hints " + hints));
        byte[] rawContent = params.getRawContent();
        log.debug((Object)"Got raw content ...");
        try {
            if (rawContent != null) {
                StorageManager.updateRawContent((String)oid, (byte[])rawContent, (BasicStorageHints)hints);
            } else {
                StorageManager.updateRawContent((String)oid, (String)location, (BasicStorageHints)hints);
            }
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        log.debug((Object)"Done updating.");
        VoidType newinfo = new VoidType();
        if (!HintsUtil.requestsFor("do-not-return-hints", hints)) {
            BasicStorageHints consumed = hints.getConsumedHints();
            newinfo.setConsumedHints(ConversionUtil.convertHints(consumed));
            if (log.isDebugEnabled()) {
                for (String hintName : consumed.getHintNames()) {
                    String hintValue = consumed.getHintValue(hintName);
                    log.debug((Object)("Used hint: " + hintName + "=" + hintValue));
                }
            }
        }
        return newinfo;
    }

    public ArrayOfInfoOIDAndHints updateRawContentBulk(ArrayOfFileTransferParameters parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfInfoOIDAndHints results = new ArrayOfInfoOIDAndHints();
        if (parameters != null) {
            FileTransferParameters[] ftps = parameters.getFileTransferParameters();
            InfoObjectIDAndConsumedHints[] answer = new InfoObjectIDAndConsumedHints[ftps.length];
            for (int i = 0; i < ftps.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + ftps.length + " of bulk..."));
                answer[i] = new InfoObjectIDAndConsumedHints();
                answer[i].setObjectID(ftps[i].getObjectID());
                try {
                    VoidType response = this.updateRawContent(ftps[i]);
                    answer[i].setSuccessful(true);
                    answer[i].setConsumedHints(response.getConsumedHints());
                    continue;
                }
                catch (RemoteException re) {
                    answer[i].setSuccessful(false);
                    log.error((Object)("Could not fulfill request " + i + "."), (Throwable)re);
                    answer[i].setConsumedHints(this.generateHintArrayWithErrorMsg(re));
                }
            }
            results.setInfoOIDAndHints(answer);
        }
        return results;
    }

    public String updateRawContentRS(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        return this.processInBackground(parameters, new UpdateRawContentProcessor());
    }

    public boolean removeRawContent(String objectID) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            return StorageManager.removeRawContent((String)objectID, (BasicStorageHints)new BasicStorageHints());
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    public VoidType addReference(ReferenceDescription ref) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        log.info((Object)"addReference");
        try {
            this.internalAddReference(ref);
        }
        catch (StorageLayerException sle) {
            log.error((Object)"Error adding the reference", (Throwable)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return VOID;
    }

    public void internalAddReference(ReferenceDescription ref) throws StorageLayerException {
        log.info((Object)"internalAddReference");
        String sourceOid = ref.getSourceObjectID();
        String targetOid = ref.getTargetObjectID();
        String role = ref.getRole();
        String secondaryRole = ref.getSecondaryRole();
        Integer position = ref.getPosition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding reference with (sourceOid: " + sourceOid + ", targetOid: " + targetOid + ", role: " + role + ", secondaryRole: " + secondaryRole + ", position: " + position + ")..."));
        }
        int pos = position == null ? -1 : position;
        String propagationRule = ref.getPropagationRule();
        StorageManager.addReference((String)sourceOid, (String)targetOid, (String)role, (String)secondaryRole, (int)pos, (String)propagationRule);
    }

    public ArrayOfBulkReferenceResultItem addReferences(ArrayOfReferenceDescription parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfBulkReferenceResultItem r = new ArrayOfBulkReferenceResultItem();
        if (parameters != null && parameters.getReferenceDescriptions() != null) {
            ReferenceDescription[] rds = parameters.getReferenceDescriptions();
            BulkReferenceResultItem[] result = new BulkReferenceResultItem[rds.length];
            for (int i = 0; i < rds.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + rds.length + " of bulk..."));
                result[i] = new BulkReferenceResultItem();
                result[i].setBulkSequenceNumber(i);
                result[i].setSourceObjectID(rds[i].getSourceObjectID());
                result[i].setTargetObjectID(rds[i].getTargetObjectID());
                result[i].setRole(rds[i].getRole());
                if (rds[i].getSecondaryRole() != null) {
                    result[i].setSecondaryRole(rds[i].getSecondaryRole());
                }
                result[i].setPropagationRule(rds[i].getPropagationRule());
                if (rds[i].getPosition() != null) {
                    result[i].setPosition(rds[i].getPosition());
                }
                try {
                    this.addReference(rds[i]);
                    result[i].setSuccessful(true);
                    continue;
                }
                catch (RemoteException re) {
                    log.warn((Object)("Excpetion for addReferences[" + i + "]:" + re.getMessage()));
                    log.debug((Object)re);
                    result[i].setSuccessful(false);
                    result[i].setErrorMsg(re.getMessage());
                }
            }
            r.setResults(result);
        }
        return r;
    }

    public String addReferencesRS(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        return this.processInBackground(parameters, new AddReferenceProcessor());
    }

    public boolean removeReference(ReferenceSelector selector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String source = selector.getSourceObjectID();
        String target = selector.getTargetObjectID();
        String role = selector.getRole();
        String secondaryRole = selector.getSecondaryRole();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing reference with (" + source + ", " + target + ", " + role + ", " + secondaryRole + ")..."));
        }
        try {
            return StorageManager.removeReference((String)source, (String)target, (String)role, (String)secondaryRole);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    public ArrayOfBulkReferenceResultItem removeReferences(ArrayOfReferenceSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfBulkReferenceResultItem r = new ArrayOfBulkReferenceResultItem();
        if (parameters != null && parameters.getSelectors() != null) {
            ReferenceSelector[] rss = parameters.getSelectors();
            BulkReferenceResultItem[] result = new BulkReferenceResultItem[rss.length];
            for (int i = 0; i < rss.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + rss.length + " of bulk..."));
                result[i] = new BulkReferenceResultItem();
                result[i].setBulkSequenceNumber(i);
                result[i].setSourceObjectID(rss[i].getSourceObjectID());
                result[i].setTargetObjectID(rss[i].getTargetObjectID());
                result[i].setRole(rss[i].getRole());
                if (rss[i].getSecondaryRole() != null) {
                    result[i].setSecondaryRole(rss[i].getSecondaryRole());
                }
                try {
                    this.removeReference(rss[i]);
                    result[i].setSuccessful(true);
                    continue;
                }
                catch (RemoteException re) {
                    log.warn((Object)("Excpetion for removeReferences[" + i + "]:" + re.getMessage()));
                    log.debug((Object)re);
                    result[i].setSuccessful(false);
                    result[i].setErrorMsg(re.getMessage());
                }
            }
            r.setResults(result);
        }
        return r;
    }

    public String removeReferencesRS(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        return this.processInBackground(parameters, new RemoveReferenceProcessor());
    }

    public ArrayOfReferenceDescription retrieveReferences(SourceReferenceSelector sourceSelector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String secondaryRole;
        String source = sourceSelector.getSourceObjectID();
        String role = sourceSelector.getRole();
        if (role == null) {
            role = "*";
        }
        if ((secondaryRole = sourceSelector.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        LinkedList<BasicReferenceDescription> references = new LinkedList<BasicReferenceDescription>();
        try {
            if (sourceSelector.isOrderByPosition()) {
                references.addAll(StorageManager.retrieveReferencesOrderedByPosition((String)source, (String)role, (String)secondaryRole));
            } else {
                references.addAll(StorageManager.retrieveReferences((String)source, (String)role, (String)secondaryRole));
            }
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return new ArrayOfReferenceDescription(ConversionUtil.convertReferences(references));
    }

    public ArrayOfBulkReferenceResultItem retrieveReferencesBulk(ArrayOfSourceReferenceSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfBulkReferenceResultItem r = new ArrayOfBulkReferenceResultItem();
        int sequenceNumber = 0;
        if (parameters != null && parameters.getSelectors() != null) {
            SourceReferenceSelector[] ss = parameters.getSelectors();
            ArrayList<BulkReferenceResultItem> resultList = new ArrayList<BulkReferenceResultItem>();
            for (int i = 0; i < ss.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + ss.length + " of bulk..."));
                try {
                    ArrayOfReferenceDescription refs = this.retrieveReferences(ss[i]);
                    if (refs != null && refs.getReferenceDescriptions().length > 0) {
                        for (int j = 0; j < refs.getReferenceDescriptions().length; ++j) {
                            BulkReferenceResultItem result = new BulkReferenceResultItem();
                            result.setBulkSequenceNumber(sequenceNumber);
                            result.setSuccessful(true);
                            result.setSourceObjectID(refs.getReferenceDescriptions(j).getSourceObjectID());
                            result.setTargetObjectID(refs.getReferenceDescriptions(j).getTargetObjectID());
                            result.setRole(refs.getReferenceDescriptions(j).getRole());
                            if (refs.getReferenceDescriptions(j).getSecondaryRole() != null) {
                                result.setSecondaryRole(refs.getReferenceDescriptions(j).getSecondaryRole());
                            }
                            result.setPropagationRule(refs.getReferenceDescriptions(j).getPropagationRule());
                            if (refs.getReferenceDescriptions(j).getPosition() == null) continue;
                            result.setPosition(refs.getReferenceDescriptions(j).getPosition());
                        }
                    }
                }
                catch (RemoteException re) {
                    log.warn((Object)("Excpetion for addReferences[" + i + "]:" + re.getMessage()));
                    log.debug((Object)re);
                    BulkReferenceResultItem result = new BulkReferenceResultItem();
                    result.setBulkSequenceNumber(sequenceNumber);
                    result.setSuccessful(false);
                    result.setErrorMsg(re.toString());
                    result.setSourceObjectID(ss[i].getSourceObjectID());
                    result.setRole(ss[i].getRole());
                    if (ss[i].getSecondaryRole() != null) {
                        result.setSecondaryRole(ss[i].getSecondaryRole());
                    }
                    resultList.add(result);
                }
                ++sequenceNumber;
            }
            r.setResults(resultList.toArray(new BulkReferenceResultItem[resultList.size()]));
        }
        return r;
    }

    public ArrayOfString retrieveReferenceTargetOIDs(SourceReferenceSelector sourceSelector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String secondaryRole;
        String source = sourceSelector.getSourceObjectID();
        String role = sourceSelector.getRole();
        if (role == null) {
            role = "*";
        }
        if ((secondaryRole = sourceSelector.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        List oids = null;
        try {
            oids = StorageManager.retrieveReferredTargetOIDs((String)source, (String)role, (String)secondaryRole);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return ConversionUtil.convertStringCollection(oids);
    }

    public ArrayOfSourceReferenceResultItem retrieveReferenceTargetOIDsBulk(ArrayOfSourceReferenceSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfSourceReferenceResultItem r = new ArrayOfSourceReferenceResultItem();
        if (parameters != null && parameters.getSelectors() != null) {
            SourceReferenceSelector[] ss = parameters.getSelectors();
            SourceReferenceResultItem[] result = new SourceReferenceResultItem[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + ss.length + " of bulk..."));
                result[i] = new SourceReferenceResultItem();
                result[i].setSourceObjectID(ss[i].getSourceObjectID());
                result[i].setRole(ss[i].getRole());
                if (ss[i].getSecondaryRole() != null) {
                    result[i].setSecondaryRole(ss[i].getSecondaryRole());
                }
                try {
                    ArrayOfString oids = this.retrieveReferenceTargetOIDs(ss[i]);
                    result[i].setTargetObjectIDs(oids.getStrings());
                    continue;
                }
                catch (RemoteException re) {
                    log.warn((Object)("Excpetion for addReferences[" + i + "]:" + re.getMessage()));
                    log.debug((Object)re);
                    result[i].setErrorMsg(re.toString());
                }
            }
            r.setResults(result);
        }
        return r;
    }

    public ArrayOfString retrieveReferredSourceOIDs(TargetReferenceSelector targetSelector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String secondaryRole;
        String target = targetSelector.getTargetObjectID();
        String role = targetSelector.getRole();
        if (role == null) {
            role = "*";
        }
        if ((secondaryRole = targetSelector.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        List oids = null;
        try {
            oids = StorageManager.retrieveReferredSourceOIDs((String)target, (String)role, (String)secondaryRole);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return ConversionUtil.convertStringCollection(oids);
    }

    public ArrayOfTargetReferenceResultItem retrieveReferredSourceOIDsBulk(ArrayOfTargetReferenceSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        ArrayOfTargetReferenceResultItem r = new ArrayOfTargetReferenceResultItem();
        if (parameters != null && parameters.getSelectors() != null) {
            TargetReferenceSelector[] ts = parameters.getSelectors();
            TargetReferenceResultItem[] result = new TargetReferenceResultItem[ts.length];
            for (int i = 0; i < ts.length; ++i) {
                log.debug((Object)("Processing request " + (i + 1) + " of " + ts.length + " of bulk..."));
                result[i] = new TargetReferenceResultItem();
                result[i].setTargetObjectID(ts[i].getTargetObjectID());
                result[i].setRole(ts[i].getRole());
                if (ts[i].getSecondaryRole() != null) {
                    result[i].setSecondaryRole(ts[i].getSecondaryRole());
                }
                try {
                    ArrayOfString oids = this.retrieveReferredSourceOIDs(ts[i]);
                    result[i].setSourceObjectIDs(oids.getStrings());
                    continue;
                }
                catch (RemoteException re) {
                    log.warn((Object)("Excetion for addReferences[" + i + "]:" + re.toString()));
                    log.debug((Object)re);
                    result[i].setErrorMsg(re.toString());
                }
            }
            r.setResults(result);
        }
        return r;
    }

    public ArrayOfReferenceDescription retrieveReferredAll(TargetReferenceSelector targetSelector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String secondaryRole;
        String target = targetSelector.getTargetObjectID();
        String role = targetSelector.getRole();
        if (role == null) {
            role = "*";
        }
        if ((secondaryRole = targetSelector.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        List references = null;
        try {
            references = StorageManager.retrieveReferred((String)target, (String)role, (String)secondaryRole);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return new ArrayOfReferenceDescription(ConversionUtil.convertReferences(references));
    }

    public ArrayOfString retrieveOIDInRelationWithAll(ArrayOfFlexibleReferenceSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String secondaryRole;
        if (parameters == null || parameters.getSelectors().length == 0) {
            return EMPTY_ARRAY_OF_STRING;
        }
        HashSet goodOnes = new HashSet();
        log.debug((Object)"Evaluating first constraint...");
        FlexibleReferenceSelector selector = parameters.getSelectors(0);
        String role = selector.getRole();
        if (role == null) {
            role = "*";
        }
        if ((secondaryRole = selector.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        try {
            if (selector.isSearchedObjectSource()) {
                goodOnes.addAll(StorageManager.retrieveReferredSourceOIDs((String)selector.getOtherObjectID(), (String)role, (String)secondaryRole));
            } else {
                goodOnes.addAll(StorageManager.retrieveReferredTargetOIDs((String)selector.getOtherObjectID(), (String)role, (String)secondaryRole));
            }
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        for (int i = 1; i < parameters.getSelectors().length; ++i) {
            String secondaryRole2;
            log.debug((Object)("Evaluating constraint " + i + " out of " + parameters.getSelectors().length + "... "));
            HashSet otherSet = new HashSet();
            FlexibleReferenceSelector selector2 = parameters.getSelectors(i);
            String role2 = selector2.getRole();
            if (role2 == null) {
                role2 = "*";
            }
            if ((secondaryRole2 = selector2.getSecondaryRole()) == null) {
                secondaryRole2 = "*";
            }
            try {
                if (selector2.isSearchedObjectSource()) {
                    otherSet.addAll(StorageManager.retrieveReferredSourceOIDs((String)selector2.getOtherObjectID(), (String)role2, (String)secondaryRole2));
                } else {
                    otherSet.addAll(StorageManager.retrieveReferredTargetOIDs((String)selector2.getOtherObjectID(), (String)role2, (String)secondaryRole2));
                }
            }
            catch (StorageLayerException sle) {
                log.error((Object)sle);
                FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
                FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
                FaultUtil.throwIOFault(sle, true);
            }
            goodOnes.retainAll(otherSet);
            if (!goodOnes.isEmpty()) continue;
            return EMPTY_ARRAY_OF_STRING;
        }
        return new ArrayOfString(goodOnes.toArray(new String[goodOnes.size()]));
    }

    public ArrayOfInfoObjectDescription retrieveObjectsInRelationWithAll(ArrayOfFlexibleReferenceSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String[] oids = this.retrieveOIDInRelationWithAll(parameters).getStrings();
        if (oids.length == 0) {
            return NO_INFO_OBJECT_DESCRIPTIONS;
        }
        String location = parameters.getFileLocation();
        if (location == null) {
            location = "/dev/null";
        }
        InfoObjectDescription[] result = new InfoObjectDescription[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            try {
                BasicStorageHints hints = ConversionUtil.convertHints(parameters.getStorageHints());
                result[i] = ConversionUtil.convertInfoObject(StorageManager.getInfoObject((String)oids[i], (String)location, (BasicStorageHints)hints));
                continue;
            }
            catch (StorageLayerException sle) {
                log.error((Object)sle);
                FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
                FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
                FaultUtil.throwIOFault(sle, true);
                continue;
            }
            catch (InvalidHintException e) {
                log.error((Object)"Error converting hints", (Throwable)e);
                GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
                throw vnvft;
            }
        }
        return new ArrayOfInfoObjectDescription(result);
    }

    public VoidType setStorageProperty(PropertyDescription prop) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            StorageManager.setStorageProperty((String)prop.getObjectID(), (String)prop.getName(), (String)prop.getType(), (String)prop.getValue());
        }
        catch (StorageLayerException sle) {
            log.error((Object)"Error setting the storage property", (Throwable)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return VOID;
    }

    public boolean unsetStorageProperty(PropertySelector selector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            return StorageManager.unsetStorageProperty((String)selector.getObjectID(), (String)selector.getName());
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    public PropertyDescription retrieveStorageProperty(PropertySelector selector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            return ConversionUtil.convertProperty(StorageManager.retrieveStorageProperty((String)selector.getObjectID(), (String)selector.getName()));
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
            return null;
        }
    }

    public ArrayOfPropertyDescription retrieveStorageProperties(String objectID) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        HashMap<String, BasicPropertyDescription> properties = new HashMap();
        try {
            properties = StorageManager.retrieveObjectStorageProperties((String)objectID);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return new ArrayOfPropertyDescription(ConversionUtil.convertProperties(properties));
    }

    public ArrayOfString retrieveOIDsByStorageProperty(ByPropertyValueSelector selector) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        List oids = null;
        try {
            oids = StorageManager.retrieveObjectIDsByStorageProperty((String)selector.getName(), (String)selector.getValue());
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        return ConversionUtil.convertStringCollection(oids);
    }

    public ArrayOfString retrieveOIDsHavingAllStorageProperties(ArrayOfByPropertyValueSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        if (parameters == null || parameters.getSelectors().length == 0) {
            return EMPTY_ARRAY_OF_STRING;
        }
        HashSet goodOnes = new HashSet();
        log.debug((Object)"Evaluating first constraint...");
        try {
            goodOnes.addAll(StorageManager.retrieveObjectIDsByStorageProperty((String)parameters.getSelectors(0).getName(), (String)parameters.getSelectors(0).getValue()));
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        for (int i = 1; i < parameters.getSelectors().length; ++i) {
            log.debug((Object)("Evaluating constraint " + i + " out of " + parameters.getSelectors().length + "... "));
            HashSet otherSet = new HashSet();
            try {
                otherSet.addAll(StorageManager.retrieveObjectIDsByStorageProperty((String)parameters.getSelectors(i).getName(), (String)parameters.getSelectors(i).getValue()));
            }
            catch (StorageLayerException sle) {
                log.error((Object)sle);
                FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
                FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
                FaultUtil.throwIOFault(sle, true);
            }
            goodOnes.retainAll(otherSet);
            if (!goodOnes.isEmpty()) continue;
            return EMPTY_ARRAY_OF_STRING;
        }
        return new ArrayOfString(goodOnes.toArray(new String[goodOnes.size()]));
    }

    public ArrayOfInfoObjectDescription retrieveObjectsHavingAllStorageProperties(ArrayOfByPropertyValueSelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        String[] oids = this.retrieveOIDsHavingAllStorageProperties(parameters).getStrings();
        if (oids.length == 0) {
            return NO_INFO_OBJECT_DESCRIPTIONS;
        }
        String location = parameters.getFileLocation();
        if (location == null) {
            location = "/dev/null";
        }
        InfoObjectDescription[] result = new InfoObjectDescription[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            try {
                BasicStorageHints hints = ConversionUtil.convertHints(parameters.getStorageHints());
                result[i] = ConversionUtil.convertInfoObject(StorageManager.getInfoObject((String)oids[i], (String)location, (BasicStorageHints)hints));
                continue;
            }
            catch (StorageLayerException sle) {
                log.error((Object)sle);
                FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
                FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
                FaultUtil.throwIOFault(sle, true);
                continue;
            }
            catch (InvalidHintException e) {
                log.error((Object)"Error converting hints", (Throwable)e);
                GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
                throw vnvft;
            }
        }
        return new ArrayOfInfoObjectDescription(result);
    }

    public boolean hasStorageProperty(PropertySelector parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            return StorageManager.hasStorageProperty((String)parameters.getObjectID(), (String)parameters.getName());
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    public boolean hasRawContent(String objectID) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            return StorageManager.hasRawContent((String)objectID);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    public VolatileInformation getVolatileInformation(GetVolatileInformationParameters parameters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBEUnrecoverableValueNotValidFault, GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        BasicPropertyDescription propModifiedBy;
        BasicPropertyDescription propModified;
        BasicInfoObjectDescription info = null;
        try {
            info = StorageManager.getInfoObject((String)parameters.getObjectID(), (String)"/dev/null", (BasicStorageHints)NO_REFRENCES);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
            FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
            FaultUtil.throwIOFault(sle, true);
        }
        VolatileInformation result = new VolatileInformation();
        result.setObjectID(info.getObjectID());
        result.setName(info.getName());
        BasicPropertyDescription propType = info.getProperty("contentmanagement:ObjectType");
        result.setType(propType.getValue());
        BasicPropertyDescription propFlavour = info.getProperty("contentmanagement:ObjectFlavour");
        if (propFlavour != null) {
            result.setCreatedBy(propFlavour.getValue());
        }
        BasicPropertyDescription propCreated = info.getProperty("contentmanagement:ObjectCreatedMillis");
        result.setCreated(BasicPropertyDescription.convertLongStringToCalendar((String)propCreated.getValue()));
        BasicPropertyDescription propCreatedBy = info.getProperty("contentmanagement:ObjectCreatedBy");
        if (propCreatedBy != null) {
            result.setCreatedBy(propCreatedBy.getValue());
        }
        if ((propModified = info.getProperty("contentmanagement:ObjectLastModificationMillis")) != null) {
            result.setLastModified(BasicPropertyDescription.convertLongStringToCalendar((String)propModified.getValue()));
        }
        if ((propModifiedBy = info.getProperty("contentmanagement:ObjectLastModifiedBy")) != null) {
            result.setCreatedBy(propModifiedBy.getValue());
        }
        if (parameters.getIsSource() != null || parameters.getRole() != null || parameters.getSecondaryRole() != null) {
            String secRole;
            long refs = 0L;
            String role = parameters.getRole();
            if (role == null) {
                role = "*";
            }
            if ((secRole = parameters.getSecondaryRole()) == null) {
                secRole = "*";
            }
            try {
                if (parameters.getIsSource() == null || Boolean.TRUE.equals(parameters.getIsSource())) {
                    refs += StorageManager.countReferences((String)parameters.getObjectID(), (boolean)true, (String)role, (String)secRole);
                }
                if (parameters.getIsSource() == null || Boolean.FALSE.equals(parameters.getIsSource())) {
                    refs += StorageManager.countReferences((String)parameters.getObjectID(), (boolean)false, (String)role, (String)secRole);
                }
            }
            catch (StorageLayerException sle) {
                log.error((Object)sle);
                FaultUtil.throwObjectNotFoundFaultIfAppropriate(sle);
                FaultUtil.throwValuaNotValidFaultIfAppropriate(sle);
                FaultUtil.throwIOFault(sle, true);
            }
            result.setNumberOfReferences(Long.valueOf(refs));
            if (parameters.getIncludeProperties() == null || parameters.getIncludeProperties().booleanValue()) {
                result.setProperties(ConversionUtil.convertProperties(info.getPropertyMap()));
            }
        }
        return result;
    }

    public boolean existsInfoObject(String parameters) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            return StorageManager.existsInfoObject((String)parameters);
        }
        catch (StorageLayerException sle) {
            log.error((Object)sle);
            FaultUtil.throwIOFault(sle, true);
            return false;
        }
    }

    private StorageHint[] generateHintArrayWithErrorMsg(Throwable t) {
        StorageHint error = new StorageHint();
        error.setName("error-message");
        error.setValue(t.getMessage());
        return new StorageHint[]{error};
    }

    private void cleanUp(String newObjectID) {
        try {
            log.debug((Object)("Cleaning up " + newObjectID));
            this.removeInfoObject(newObjectID);
            log.debug((Object)"Object removed.");
        }
        catch (RemoteException re2) {
            log.warn((Object)("Cleaning up of " + newObjectID + " causes exception."), (Throwable)re2);
        }
    }

    public String processInBackground(String inputResultSetEPR, Processor processor) throws GCUBERetrySameIOFault, GCUBERetryEquivalentIOFault, GCUBEUnrecoverableIOFault {
        try {
            log.debug((Object)("Reading parameters from ResultSet at " + inputResultSetEPR + "..."));
            RSXMLIterator inputIterator = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(inputResultSetEPR)).getRSIterator(900000);
            RSXMLWriter output = RSXMLWriter.getRSXMLWriter();
            Thread bulkGetter = new Thread(new BackgroundPerInputProcessor(inputIterator, output, processor));
            this.getServiceContext().setScope(bulkGetter, this.getServiceContext().getScope());
            bulkGetter.start();
            String outputRSLocation = output.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
            log.debug((Object)("Background thread started, result will be written to ResultSet at " + outputRSLocation + "."));
            return outputRSLocation;
        }
        catch (Exception e) {
            log.debug((Object)"Error initiating background process.", (Throwable)e);
            StorageLayerException sle = new StorageLayerException("Could not set up background thread to process ResultSet.", (Throwable)e, SUBSYSTEM_RS);
            FaultUtil.throwIOFault(sle, false);
            return null;
        }
    }

    static {
        NO_INFO_OBJECT_DESCRIPTIONS = new ArrayOfInfoObjectDescription(new InfoObjectDescription[0]);
        NO_REFRENCES = new BasicStorageHints();
        NO_REFRENCES.addHint("return-object-without-references", BasicStorageHints.HINT_VALUE_TRUE);
        log = LogFactory.getLog(SMSPortType1.class);
    }

    static class BackgroundObjectRemover
    implements Runnable {
        private final String victim;

        BackgroundObjectRemover(String oidToDelete) {
            this.victim = oidToDelete;
        }

        @Override
        public void run() {
            try {
                StorageManager.removeInfoObject((String)this.victim);
            }
            catch (StorageLayerException e) {
                log.error((Object)e);
            }
        }
    }

    private class RemoveReferenceProcessor
    extends Processor
    implements SingleInputSingleOutputProcessor {
        int sequenceNum;

        private RemoveReferenceProcessor() {
            this.sequenceNum = 0;
        }

        @Override
        public ResultElementBean process(ResultElementBean inputBean) throws Exception {
            BulkReferenceResultItem result = new BulkReferenceResultItem();
            ReferenceSelector request = null;
            try {
                request = (ReferenceSelector)inputBean.getBean();
                result.setBulkSequenceNumber(++this.sequenceNum);
                result.setSourceObjectID(request.getSourceObjectID());
                result.setTargetObjectID(request.getTargetObjectID());
                result.setRole(request.getRole());
                if (request.getSecondaryRole() != null) {
                    result.setSecondaryRole(request.getSecondaryRole());
                }
                SMSPortType1.this.removeReference(request);
                result.setSuccessful(true);
            }
            catch (Exception e) {
                log.error((Object)e);
                result.setSuccessful(false);
                result.setErrorMsg(e.getMessage());
            }
            return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
        }
    }

    private class AddReferenceProcessor
    extends Processor
    implements SingleInputSingleOutputProcessor {
        int sequenceNum;

        private AddReferenceProcessor() {
            this.sequenceNum = 0;
        }

        @Override
        public ResultElementBean process(ResultElementBean inputBean) throws Exception {
            BulkReferenceResultItem result = new BulkReferenceResultItem();
            ReferenceDescription request = null;
            try {
                request = (ReferenceDescription)inputBean.getBean();
                result.setBulkSequenceNumber(++this.sequenceNum);
                result.setSourceObjectID(request.getSourceObjectID());
                result.setTargetObjectID(request.getTargetObjectID());
                result.setRole(request.getRole());
                if (request.getSecondaryRole() != null) {
                    result.setSecondaryRole(request.getSecondaryRole());
                }
                result.setPropagationRule(request.getPropagationRule());
                if (request.getPosition() != null) {
                    result.setPosition(request.getPosition());
                }
                SMSPortType1.this.addReference(request);
                result.setSuccessful(true);
            }
            catch (Exception e) {
                log.error((Object)e);
                result.setSuccessful(false);
                result.setErrorMsg(e.getMessage());
            }
            return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
        }
    }

    private class UpdateRawContentProcessor
    extends Processor
    implements SingleInputSingleOutputProcessor {
        private UpdateRawContentProcessor() {
        }

        @Override
        public ResultElementBean process(ResultElementBean inputBean) throws Exception {
            InfoObjectIDAndConsumedHints result = new InfoObjectIDAndConsumedHints();
            FileTransferParameters request = null;
            try {
                request = (FileTransferParameters)inputBean.getBean();
                result.setObjectID(request.getObjectID());
                VoidType directResponse = SMSPortType1.this.updateRawContent(request);
                result.setSuccessful(true);
                result.setConsumedHints(directResponse.getConsumedHints());
            }
            catch (Exception e) {
                log.error((Object)"Could not update content.", (Throwable)e);
                result.setSuccessful(false);
                result.setConsumedHints(SMSPortType1.this.generateHintArrayWithErrorMsg(e));
            }
            return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
        }
    }

    private static class BackgroundPerInputProcessor
    implements Runnable {
        final RSXMLIterator inputIterator;
        final RSXMLWriter output;
        final Processor proc;

        BackgroundPerInputProcessor(RSXMLIterator inputIterator, RSXMLWriter output, Processor processor) {
            log.debug((Object)"Initiating background thread for processing input ResultSet / generating output ResultSet.");
            this.inputIterator = inputIterator;
            this.output = output;
            this.proc = processor;
        }

        @Override
        public void run() {
            log.debug((Object)"Background thread started.");
            int itemNum = 0;
            while (this.inputIterator.hasNext()) {
                log.debug((Object)("Processing item " + ++itemNum + " of result set."));
                ResultElementBean inputBean = (ResultElementBean)this.inputIterator.next(ResultElementBean.class);
                ResultElementBean result = null;
                try {
                    if (this.proc instanceof SingleInputSingleOutputProcessor) {
                        SingleInputSingleOutputProcessor siso = (SingleInputSingleOutputProcessor)((Object)this.proc);
                        result = siso.process(inputBean);
                        this.output.addResults((ResultElementBase)result);
                        log.debug((Object)("Added result of item " + itemNum + " to ResultSet."));
                        continue;
                    }
                    if (this.proc instanceof SingleInputMultiOutputProcessor) {
                        SingleInputMultiOutputProcessor simo = (SingleInputMultiOutputProcessor)((Object)this.proc);
                        long num = simo.process(inputBean, this.output);
                        log.debug((Object)("Added result " + num + " results for item " + itemNum + " to ResultSet."));
                        continue;
                    }
                    log.warn((Object)("Don't know how to handle processor of class " + this.proc.getClass().getCanonicalName()));
                }
                catch (Exception e) {
                    if (result == null) {
                        log.error((Object)("Couldn't generate result for id " + inputBean.getRecordAttributes("DocID")[0].getAttrValue()), (Throwable)e);
                    } else {
                        log.error((Object)("Couldn't write result for id " + result.getRecordAttributes("DocID")[0].getAttrValue()), (Throwable)e);
                    }
                    if (!log.isInfoEnabled()) continue;
                    try {
                        log.info((Object)("XML Serialization of input bean was:\n" + inputBean.RS_toXML()));
                    }
                    catch (Exception e1) {
                        log.info((Object)e1);
                    }
                    try {
                        log.info((Object)("XML Serialization of result bean was:\n" + result.RS_toXML()));
                    }
                    catch (Exception e1) {
                        log.info((Object)e1);
                    }
                }
            }
            try {
                this.output.close();
            }
            catch (Exception e) {
                log.error((Object)"Couldn't close result set writer. ", (Throwable)e);
            }
            log.debug((Object)("Background thread ended sucessfully after processing " + itemNum + " items."));
        }
    }

    private static abstract class Processor {
        private Processor() {
        }

        String getInputID(ResultElementBean inputBean) {
            return inputBean.getRecordAttributes("DocID")[0].getAttrValue();
        }

        String getCollectionID(ResultElementBean inputBean) {
            return inputBean.getRecordAttributes("CollID")[0].getAttrValue();
        }
    }

    private static interface SingleInputMultiOutputProcessor {
        public long process(ResultElementBean var1, RSXMLWriter var2) throws Exception;
    }

    private static interface SingleInputSingleOutputProcessor {
        public ResultElementBean process(ResultElementBean var1) throws Exception;
    }

    private class GetObjectProcessor
    extends Processor
    implements SingleInputSingleOutputProcessor {
        private GetObjectProcessor() {
        }

        @Override
        public ResultElementBean process(ResultElementBean inputBean) throws Exception {
            InfoObjectDescription result = null;
            FileTransferParameters ftp = null;
            try {
                ftp = (FileTransferParameters)inputBean.getBean();
            }
            catch (Exception cce) {
                log.error((Object)"Malformed input ResultSet.", (Throwable)cce);
                result = new InfoObjectDescription();
                result.setObjectID(null);
                result.setName(REQUEST_FAILED_NAME);
                result.setConsumedHints(SMSPortType1.this.generateHintArrayWithErrorMsg(cce));
                return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
            }
            try {
                result = SMSPortType1.this.getInfoObject(ftp);
            }
            catch (Exception e) {
                log.error((Object)"Could not get object.", (Throwable)e);
                result = new InfoObjectDescription();
                result.setObjectID(ftp.getObjectID());
                result.setName(REQUEST_FAILED_NAME);
                result.setConsumedHints(SMSPortType1.this.generateHintArrayWithErrorMsg(e));
                return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
            }
            return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
        }
    }

    private class RemoveObjectProcessor
    extends Processor
    implements SingleInputMultiOutputProcessor {
        private RemoveObjectProcessor() {
        }

        @Override
        public long process(ResultElementBean inputBean, RSXMLWriter output) throws Exception {
            String victim = null;
            try {
                victim = (String)inputBean.getBean();
                SMSPortType1.this.removeInfoObject(victim);
                return 0L;
            }
            catch (Exception e) {
                log.error((Object)"Could not create object.", (Throwable)e);
                FailedObject f = new FailedObject();
                f.setObjectID(victim);
                f.setErrorMessage(SMSPortType1.this.generateHintArrayWithErrorMsg(e)[0]);
                try {
                    output.addResults((ResultElementBase)new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)f));
                }
                catch (Exception ow) {
                    log.error((Object)"Couldn't wrap error in ResultSet.", (Throwable)ow);
                    log.info((Object)"Original error was: ", (Throwable)e);
                }
                return 1L;
            }
        }
    }

    private class CreateObjectWithContentProcessor
    extends Processor
    implements SingleInputSingleOutputProcessor {
        private CreateObjectWithContentProcessor() {
        }

        @Override
        public ResultElementBean process(ResultElementBean inputBean) throws Exception {
            InfoObjectIDAndConsumedHints result = null;
            CreateInfoObjectReferencesProperties request = null;
            try {
                request = (CreateInfoObjectReferencesProperties)inputBean.getBean();
                result = SMSPortType1.this.createInfoObjectWithContent(request);
            }
            catch (Exception e) {
                log.error((Object)"Could not create object.", (Throwable)e);
                result = new InfoObjectIDAndConsumedHints();
                result.setSuccessful(false);
                result.setObjectID(null);
                result.setConsumedHints(SMSPortType1.this.generateHintArrayWithErrorMsg(e));
                return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
            }
            return new ResultElementBean(this.getInputID(inputBean), this.getCollectionID(inputBean), (Object)result);
        }
    }
}

