/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.StorageLayerException;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.exception.InvalidHintException;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.SMSPortTypeContext;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.SMSServiceContext;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.filter.FilterChainComposer;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs.InfoObjectDescriptionIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs.InfoObjectDescriptionTreeIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.rs.RSSenderIterator;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.ConversionUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.impl.util.InfoObjectTreeUtil;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.RetrieveFilteredIOsParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.RetrieveTreeParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSInformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilterType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util.WSToObjectFiltersConverter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.SMSResponseConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.util.WSToObjectResponseConverter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.rs.RSConfiguration;

public class SMSPortType
extends GCUBEPortType {
    protected static final SimpleDateFormat sdf = new SimpleDateFormat();
    protected static final Comparator<SMSFilter> filterComparator = new Comparator<SMSFilter>(){

        @Override
        public int compare(SMSFilter f1, SMSFilter f2) {
            if (f1.getType() == SMSFilterType.REFERENCE_FILTER && f2.getType() == SMSFilterType.PROPERTY_FILTER) {
                return -1;
            }
            if (f1.getType() == SMSFilterType.PROPERTY_FILTER && f2.getType() == SMSFilterType.REFERENCE_FILTER) {
                return 1;
            }
            return 0;
        }
    };
    protected Executor executor;
    protected int threadPoolSize;
    protected int RSBufferSize;
    protected long RSFlowTimeout;

    protected GCUBEServiceContext getServiceContext() {
        return SMSServiceContext.getContext();
    }

    protected void onInitialisation() throws Exception {
        this.loadConfig();
        this.executor = Executors.newFixedThreadPool(this.threadPoolSize);
        RSConfiguration.initializeRSTCPConnectionManager();
        this.logger.info((Object)"initialization complete");
    }

    protected void loadConfig() {
        this.logger.info((Object)"loadConfig");
        this.threadPoolSize = this.getProperty("threadPoolSize", 10);
        this.logger.debug((Object)("threadPoolSize: " + this.threadPoolSize));
        this.RSBufferSize = this.getProperty("RSBufferSize", 20);
        this.logger.debug((Object)("RSBufferSize: " + this.RSBufferSize));
        this.RSFlowTimeout = this.getProperty("RSFlowTimeout", 3600000);
        this.logger.debug((Object)("RSFlowTimeout: " + this.RSFlowTimeout));
    }

    protected int getProperty(String name, int defaultValue) {
        try {
            return (Integer)SMSPortTypeContext.getPortTypeContext().getProperty(name, new boolean[]{false});
        }
        catch (Exception e) {
            this.logger.error((Object)("Error getting property " + name), (Throwable)e);
            return defaultValue;
        }
    }

    public InfoObjectTree retrieveTree(RetrieveTreeParameters parameters) throws GCUBEUnrecoverableValueNotValidFault, StorageLayerException {
        BasicStorageHints hints;
        this.logger.info((Object)"retrieveTree");
        String id = parameters.getOid();
        WSInformationObjectTreeResponse wsInformationObjectTreeResponse = parameters.getInformationObjectTreeResponse();
        InformationObjectTreeResponse responseConfig = WSToObjectResponseConverter.convertToInformationObjectTreeResponse(wsInformationObjectTreeResponse);
        RawContentLocationConfig locationConfig = responseConfig.getContentLocation();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("oid: " + id));
            this.logger.trace((Object)("responseConfig: " + responseConfig));
        }
        try {
            hints = ConversionUtil.convertHints(responseConfig.getHints());
        }
        catch (InvalidHintException e) {
            this.logger.error((Object)"Error converting hints", (Throwable)e);
            GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
            throw vnvft;
        }
        return InfoObjectTreeUtil.getInfoObjectTree(id, locationConfig, hints, responseConfig.getWalkRules(), responseConfig.getHops());
    }

    public String retrieveFilteredIOs(RetrieveFilteredIOsParameters parameters) throws Exception {
        this.logger.info((Object)"retrieveFilteredIOs");
        long start = System.currentTimeMillis();
        List<SMSFilter> filters = null;
        SMSResponseConfig responseConfig = null;
        try {
            WSResponseConfig wsResponseConfig = parameters.getResponseConfig();
            WSFilter[] wsFilters = parameters.getFilters();
            filters = WSToObjectFiltersConverter.convertToFilters(wsFilters);
            responseConfig = WSToObjectResponseConverter.convertToResponseConfig(wsResponseConfig);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error converting parameters", (Throwable)e);
            throw e;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Filters to apply:");
            for (SMSFilter filter : filters) {
                this.logger.trace((Object)filter.toString());
            }
        }
        Collections.sort(filters, filterComparator);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Ordered filters:");
            for (SMSFilter filter : filters) {
                this.logger.trace((Object)filter.toString());
            }
        }
        this.logger.trace((Object)"preparing chain");
        FilterChainComposer chainComposer = new FilterChainComposer(this.logger);
        Iterator<String> chain = chainComposer.composeChain(filters);
        this.logger.trace((Object)"iterator chain complete");
        URI locator = null;
        try {
            locator = this.startResponseRSSender(responseConfig, chain);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error starting the sender", (Throwable)e);
        }
        this.logger.info((Object)("RS setup complete " + (System.currentTimeMillis() - start)));
        return locator.toString();
    }

    protected URI startResponseRSSender(SMSResponseConfig config, Iterator<String> source) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("starting the RespondeRSSender SMSResponseConfig: " + config));
        }
        switch (config.getResponseType()) {
            case OID: {
                return this.startRSSender(source);
            }
            case INFORMATION_OBJECT: {
                BasicStorageHints hints;
                InformationObjectResponse informationObjectResponse = (InformationObjectResponse)config;
                try {
                    hints = ConversionUtil.convertHints(informationObjectResponse.getHints());
                }
                catch (InvalidHintException e) {
                    this.logger.error((Object)"Error converting hints", (Throwable)e);
                    GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
                    throw vnvft;
                }
                InfoObjectDescriptionIterator infoObjectRetriever = new InfoObjectDescriptionIterator(this.logger, source, informationObjectResponse.getLocation(), hints);
                return this.startRSSender(infoObjectRetriever);
            }
            case INFORMATION_OBJECT_TREE: {
                BasicStorageHints hints;
                InformationObjectTreeResponse informationObjectTreeResponse = (InformationObjectTreeResponse)config;
                RawContentLocationConfig locationConfig = informationObjectTreeResponse.getContentLocation();
                try {
                    hints = ConversionUtil.convertHints(informationObjectTreeResponse.getHints());
                }
                catch (InvalidHintException e) {
                    this.logger.error((Object)"Error converting hints", (Throwable)e);
                    GCUBEUnrecoverableValueNotValidFault vnvft = ConversionUtil.convertToGCUBEFault(e);
                    throw vnvft;
                }
                InfoObjectDescriptionTreeIterator infoObjectRetriever = new InfoObjectDescriptionTreeIterator(this.logger, source, locationConfig, hints, informationObjectTreeResponse.getWalkRules(), informationObjectTreeResponse.getHops());
                return this.startRSSender(infoObjectRetriever);
            }
        }
        throw new IllegalArgumentException("Impossible to configure the RSSender for the given response configuration " + (Object)((Object)config.getResponseType()));
    }

    protected <T> URI startRSSender(Iterator<T> source) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"starting the RS sender");
        }
        RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), RSConfiguration.RECORD_DEFINITION, this.RSBufferSize, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, this.RSFlowTimeout, TimeUnit.SECONDS);
        RSSenderIterator<T> sender = new RSSenderIterator<T>(source, (RecordWriter<GenericRecord>)writer, this.RSFlowTimeout);
        this.executor.execute(sender);
        return writer.getLocator();
    }
}

