package org.gcube.contentmanager.storageserver.accounting;


import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

	public class ReportAccountingImpl implements Report {
	final Logger logger = LoggerFactory.getLogger(ReportAccountingImpl.class);
// storage usage record	
//	public RawUsageRecord sur;
// storage status record	
	public RawUsageRecord ssr;
	public ResourceAccounting raFactory;

	
	@Override
	public void init(){
		  raFactory = null;
		  try {
			  raFactory = ResourceAccountingFactory.getResourceAccountingInstance();
		  } 
		  catch (IOException e) {
			  e.printStackTrace();
		  }
		  catch (Exception e) {
			  e.printStackTrace();
		  }  
	}
	
	@Override
	public RawUsageRecord setGenericProperties(String resourceType, String consumerId, String resourceScope, String creationTime, String lastAccess, String owner) {
		  logger.info("set accounting generic properties: resourceType: "+resourceType+" consumerId "+consumerId+" scope: "+resourceScope+ " creationTime "+creationTime+" lastAccess "+lastAccess+" owner "+ owner);
		  if(raFactory==null) init();
		  RawUsageRecord sr = new RawUsageRecord();
		  //	generic properties
//		   sur.setResourceType("storage-usage");
		  sr.setResourceType(resourceType);
		   if(consumerId!=null)  sr.setConsumerId(consumerId);
		   //   ur.setResourceOwner("paolo.fabriani");
		   if(resourceScope !=null) sr.setResourceScope(resourceScope);
		   //set creation time	   
		   if(creationTime!=null){
			   SimpleDateFormat formatter = new SimpleDateFormat("dd MM yyyy 'at' hh:mm:ss z");
			   Date date=null;
			   try {
				   date = formatter.parse(creationTime);
			   } catch (ParseException e) {
				   logger.error("Error in parsing date: "+creationTime+" exc msg: "+e.getMessage());
			   }
			   sr.setCreateTime(date);
			// set the mandatory fields
			try {
				date = new SimpleDateFormat("dd MM yyyy 'at' hh:mm:ss z").parse(lastAccess);
				sr.setStartTime(date);
				sr.setEndTime(date);
			} catch (Exception e) {
				e.printStackTrace();
			}
			//specific properties
			   if(owner != null) sr.setResourceOwner(owner);
		// end mandatory files	   
		   }
		   return sr;
	}

	
	@Override
	public RawUsageRecord setSpecificProperties( RawUsageRecord sur, String operation, String size, String filePath, String callerIP, String dataType, String dataCount) {
		logger.info("set accounting properties: operation: "+operation+" size: "+size+ " remotePath: "+filePath+" callerIP "+callerIP+" dataType "+dataType+" dataCount "+dataCount);
		if(sur==null) sur = new RawUsageRecord();
	   if (operation!=null) sur.setResourceSpecificProperty("operationType",operation);
	   if(size!= null) sur.setResourceSpecificProperty("dataVolume", size);
	   if(filePath != null) sur.setResourceSpecificProperty("remotePath", filePath);
//	   if(id!= null) sur.setResourceSpecificProperty("id", id);
	   if(callerIP!=null) sur.setResourceSpecificProperty("callerIP", callerIP);
//	   if(lastAccess!=null){
//		   sur.setResourceSpecificProperty("lastAccess", lastAccess);
//	
//	   }
	   sur.setResourceSpecificProperty("dataType",dataType);
	   sur.setResourceSpecificProperty("dataCount", dataCount);
	   return sur;
	}

	@Override
	public void send(RawUsageRecord sur) {
		logger.info("report sending...");
		if(raFactory!=null)
			raFactory.sendAccountingMessage(sur);
		else
			logger.error("Problem on building accounting record: Factory Object is null ");
	}

}
