/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateGuesser {
    private static final String[] formats = new String[]{"MM\\dd\\yyyy", "MM\\dd\\yy", "MM/dd/yy", "MM/dd/yyyy", "MM/yy", "MM/yyyy", "yyyy.MM.dd G 'at' HH:mm:ss z", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy HH:mm:ss aaa", "dd/MM/yyyy HH:mm:ss", "EEE, MMM d, ''yy", "h:mm a", "hh 'o''clock' a, zzzz", "K:mm a, z", "MM-dd-yy", "MM-dd-yyyy", "dd-MMM-yy", "yyyy.MM.dd.HH.mm.ss", "E, dd MMM yyyy HH:mm:ss Z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "EEE, d MMM yyyy HH:mm:ss Z", "yyMMddHHmmssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "h:mm a", "yyyy"};
    private static final String[] formatiITA = new String[]{"dd\\MM\\yyyy", "dd\\MM\\yy", "dd/MM/yy", "dd/MM/yyyy", "dd/MM/yy", "dd/MM/yyyy", "dd/MM/yyyy HH:mm:ss", "dd/MM/yy HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "MM/yy", "MM/yyyy", "dd.MM.yyyy G 'alle' HH:mm:ss z", "EEE, MMM d, ''yy", "h:mm a", "hh a, zzzz", "K:mm a, z", "dd-MMM-yy", "dd.MM.yyyy.HH.mm.ss", "E, dd MMM yyyy HH:mm:ss Z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "EEE, d MMM yyyy HH:mm:ss Z", "yyMMddHHmmssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "dd-MMM-yyyy HH:mm", "h:mm a", "yyyy"};
    public static final String YEAR = "YEAR";
    public static final String MONTH = "MONTH";
    public static final String DAY = "DAY";

    public static void main(String[] args) {
        Calendar c = DateGuesser.convertDate("20/2/2010 0:49:00");
        System.out.println("giorno " + c.get(5) + " mese " + (c.get(2) + 1) + " anno " + c.get(1));
        System.out.println("pattern " + DateGuesser.getPattern("20/2/2010 0:49:00"));
        System.out.println("pattern " + DateGuesser.getPattern("2009-05-12 15:42:10"));
        System.out.println("pattern " + DateGuesser.getPattern("1970"));
        System.out.println("pattern " + DateGuesser.getPattern("2009-05-12"));
        System.out.println("pattern " + DateGuesser.getPattern("prova"));
        System.out.println("pattern " + DateGuesser.getPattern("9/26/2010 1:49:00"));
        c = DateGuesser.convertDate("2009-05-12");
        System.out.println("giorno " + c.get(5) + " mese " + (c.get(2) + 1) + " anno " + c.get(1));
    }

    public static Calendar convertDate(String data) {
        return DateGuesser.convertDate(data, null);
    }

    public static String getPattern(String data) {
        return DateGuesser.getPattern(data, null);
    }

    public static String getPattern(String data, String language) {
        Locale l = Locale.UK;
        if (language != null && language.equalsIgnoreCase("it")) {
            l = Locale.ITALY;
        }
        Date dat = null;
        SimpleDateFormat formatter = null;
        String[] formati = formats;
        if (l.equals(Locale.ITALY)) {
            formati = formatiITA;
        }
        int index = -1;
        for (int i = 0; i < formati.length; ++i) {
            try {
                formatter = new SimpleDateFormat(formati[i], l);
                dat = formatter.parse(data);
                if (index == -1) {
                    index = i;
                    continue;
                }
                if (formati[index].length() > formati[i].length()) continue;
                index = i;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (dat != null) {
            return formati[index];
        }
        return null;
    }

    public static Calendar convertDate(String data, String language) {
        Locale l = Locale.UK;
        if (language != null && language.equalsIgnoreCase("it")) {
            l = Locale.ITALY;
        }
        Date dat = null;
        SimpleDateFormat formatter = null;
        String[] formati = formats;
        if (l.equals(Locale.ITALY)) {
            formati = formatiITA;
        }
        int index = -1;
        Date bestDate = null;
        for (int i = 0; i < formati.length; ++i) {
            try {
                formatter = new SimpleDateFormat(formati[i], l);
                dat = formatter.parse(data);
                if (index == -1) {
                    bestDate = dat;
                    index = i;
                    continue;
                }
                if (formati[index].length() > formati[i].length()) continue;
                bestDate = dat;
                index = i;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bestDate != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(bestDate);
            return c;
        }
        return null;
    }

    public static String granularity(String pattern) {
        SimpleDateFormat formatter = null;
        try {
            formatter = new SimpleDateFormat("MM/dd/yyyy");
            formatter.parse(pattern);
            return DAY;
        }
        catch (Exception e) {
            try {
                formatter = new SimpleDateFormat("MM/yyyy");
                formatter.parse(pattern);
                return MONTH;
            }
            catch (Exception e2) {
                try {
                    formatter = new SimpleDateFormat("MM/yy");
                    formatter.parse(pattern);
                    return MONTH;
                }
                catch (Exception exception) {
                    return YEAR;
                }
            }
        }
    }
}

