/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.gcube.portlets.user.timeseries.charts.support.types.ValueEntry;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class NumericSeriesGraph
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;

    public NumericSeriesGraph(String title) {
        super(title);
    }

    @Override
    protected Dataset generateDataset() {
        XYSeries xyseries = new XYSeries((Comparable)((Object)"Series 1"));
        xyseries.add(2.0, 56.27);
        xyseries.add(3.0, 41.32);
        xyseries.add(4.0, 31.45);
        xyseries.add(5.0, 30.05);
        xyseries.add(6.0, 24.69);
        xyseries.add(7.0, 19.78);
        xyseries.add(8.0, 20.94);
        xyseries.add(9.0, 16.73);
        xyseries.add(10.0, 14.21);
        xyseries.add(11.0, 12.44);
        XYSeriesCollection xyseriescollection = new XYSeriesCollection(xyseries);
        XYSeries xyseries1 = new XYSeries((Comparable)((Object)"Series 2"));
        xyseries1.add(11.0, 56.27);
        xyseries1.add(10.0, 41.32);
        xyseries1.add(9.0, 31.45);
        xyseries1.add(8.0, 30.05);
        xyseries1.add(7.0, 24.69);
        xyseries1.add(6.0, 19.78);
        xyseries1.add(5.0, 20.94);
        xyseries1.add(4.0, 16.73);
        xyseries1.add(3.0, 14.21);
        xyseries1.add(2.0, 12.44);
        xyseriescollection.addSeries(xyseries1);
        return xyseriescollection;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        NumberAxis numberaxis = new NumberAxis("X");
        numberaxis.setAutoRangeIncludesZero(true);
        NumberAxis numberaxis1 = new NumberAxis("Y");
        numberaxis1.setAutoRangeIncludesZero(true);
        XYSplineRenderer xysplinerenderer = new XYSplineRenderer();
        XYPlot xyplot = new XYPlot((XYDataset)dataset, (ValueAxis)numberaxis, (ValueAxis)numberaxis1, (XYItemRenderer)xysplinerenderer);
        xyplot.setBackgroundPaint((Paint)Color.lightGray);
        xyplot.setDomainGridlinePaint((Paint)Color.white);
        xyplot.setRangeGridlinePaint((Paint)Color.white);
        xyplot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        JFreeChart chart = new JFreeChart("Numeric Series", JFreeChart.DEFAULT_TITLE_FONT, (Plot)xyplot, true);
        return chart;
    }

    @Override
    protected Dataset convert2Dataset(GraphData st) {
        List pointslist = st.getData();
        int numbOfRows = pointslist.size();
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        if (numbOfRows > 0) {
            int numbOfCols = ((Point)pointslist.get(0)).getEntries().size();
            for (int x = 0; x < numbOfRows; ++x) {
                String serieslabel = ((Point)pointslist.get(x)).getLabel();
                XYSeries xyseries = new XYSeries((Comparable)((Object)serieslabel));
                for (int y = 0; y < numbOfCols; ++y) {
                    double value = ((ValueEntry)((Point)pointslist.get(x)).getEntries().get(y)).getValue().doubleValue();
                    xyseries.add((double)(y + 1), value);
                }
                xyseriescollection.addSeries(xyseries);
            }
        }
        return xyseriescollection;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        return new NumericSeriesGraph(title);
    }
}

