/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.data.databases;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.abstracts.GenericDBExtractor;
import org.gcube.contentmanagement.graphtools.abstracts.SamplesTable;
import org.gcube.contentmanagement.graphtools.core.filters.Filter;
import org.gcube.contentmanagement.graphtools.data.BigSamplesTable;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.hibernate.SessionFactory;

public class CommonDBExtractor
implements GenericDBExtractor {
    SessionFactory dbSession;
    private static final String staticQuery = "select distinct %1$s from  %2$s where (%3$s) ";
    private static final String staticOrderBy = " order by %1$s;";
    private static final String descriptionQuery = "SELECT ordinal_position,column_name,data_type FROM information_schema.COLUMNS WHERE table_name ='%1$s'";

    public CommonDBExtractor(SessionFactory DbSession) {
        this.dbSession = DbSession;
    }

    @Override
    public SamplesTable getMonoDimTable(String table, String column) {
        BigSamplesTable monoSamples = new BigSamplesTable();
        String query = "select distinct " + column + " from " + table + ";";
        List resultSet = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.dbSession);
        for (Object result : resultSet) {
            try {
                Double resultcount = (Double)result;
                monoSamples.addSampleRow(column, resultcount);
            }
            catch (Exception e) {}
        }
        return monoSamples;
    }

    private String generateSelectionString(String ... columns) {
        String delimiter = " , ";
        StringBuffer sb = new StringBuffer();
        int numbOfColumns = columns.length;
        for (int i = 0; i < numbOfColumns; ++i) {
            String column = columns[i];
            sb.append(column);
            if (i >= numbOfColumns - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private Map<String, String> getTypes(SessionFactory dbSession, String table) {
        HashMap<String, String> typesMap = new HashMap<String, String>();
        String queryDesc = String.format(descriptionQuery, table);
        AnalysisLogger.getLogger().trace((Object)("Query for Description: " + queryDesc));
        List resultSet = DatabaseFactory.executeSQLQuery((String)queryDesc, (SessionFactory)dbSession);
        for (Object result : resultSet) {
            Object[] resultArray = (Object[])result;
            String column_name = (String)resultArray[1];
            String data_type = (String)resultArray[2];
            typesMap.put(column_name, DataTypeRecognizer.transformTypeFromDB((String)data_type));
        }
        return typesMap;
    }

    private void updateSequence(SamplesTable sequence, Map<String, String> columnTypes, String xDimension, Object[] row, int index) {
        String xLabel = "";
        Double xValue = 0.0;
        xLabel = "" + row[0];
        xValue = index;
        String label = xLabel + ";";
        String yLabel = "";
        Double yValue = 0.0;
        try {
            yLabel = yLabel + (String)row[3];
            yValue = Double.valueOf("" + row[2]);
        }
        catch (Exception e) {
            // empty catch block
        }
        label = label + yLabel;
        sequence.addSampleRow(label, xValue, yValue);
    }

    public Map<String, SamplesTable> getMultiDimTemporalTables(List<Filter> filters, Filter YRangeFilter, String table, String xDimension, String groupDimension, String yValue, String speciesColumn, String ... yFilters) {
        LinkedHashMap<String, SamplesTable> temporalSequence = new LinkedHashMap<String, SamplesTable>();
        String selection = this.generateSelectionString(xDimension, groupDimension, yValue, speciesColumn);
        StringBuffer whereclause = new StringBuffer();
        int i = 0;
        for (String columnFilter : yFilters) {
            whereclause.append(speciesColumn + "='" + columnFilter + "'");
            if (i < yFilters.length - 1) {
                whereclause.append(" or ");
            }
            ++i;
        }
        String query = String.format(staticQuery, selection, table, whereclause);
        if (filters != null && filters.size() > 0) {
            query = query + "and (";
            int kk = 0;
            for (Filter f : filters) {
                query = kk == 0 ? query + f.toString("") : query + f.toString("or");
                ++kk;
            }
            query = query + ")";
        }
        if (YRangeFilter != null) {
            query = query + "and " + yValue + ">" + YRangeFilter.getFirstNumber() + " and " + yValue + "<" + YRangeFilter.getSecondNumber() + " ";
        }
        query = query + String.format(staticOrderBy, xDimension);
        AnalysisLogger.getLogger().trace((Object)("Query: " + query));
        List resultSet = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.dbSession);
        Map<String, String> columnTypes = this.getTypes(this.dbSession, table);
        if (resultSet != null) {
            for (Object result : resultSet) {
                Object[] resultArray = (Object[])result;
                String temporalInfo = (String)resultArray[1];
                SamplesTable sequence = temporalSequence.get(temporalInfo);
                if (sequence == null) {
                    sequence = new BigSamplesTable();
                    temporalSequence.put(temporalInfo, sequence);
                    for (String columnFilter : yFilters) {
                        sequence.addSampleRow("header;" + columnFilter, Double.NEGATIVE_INFINITY, 0.0);
                    }
                }
                this.updateSequence(sequence, columnTypes, xDimension, resultArray, sequence.getNumOfDataRows() - yFilters.length);
            }
        }
        return temporalSequence;
    }

    @Override
    public Map<String, SamplesTable> getMultiDimTemporalTables(String table, String xDimension, String groupDimension, String yValue, String speciesColumn, String ... yFilters) {
        return this.getMultiDimTemporalTables((List<Filter>)null, (Filter)null, table, xDimension, groupDimension, yValue, speciesColumn, yFilters);
    }
}

