/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;

public abstract class NextIterator<O, I>
implements RemoteIterator<O> {
    protected GCUBELog logger;
    protected RemoteIterator<I> inputIterator;
    protected O next = null;
    protected boolean nextConsumed = true;

    public NextIterator(GCUBELog logger, final Iterator<I> inputIterator) {
        this.logger = logger;
        this.inputIterator = new RemoteIterator<I>(){

            public void close() {
            }

            public String locator() {
                return "local";
            }

            public boolean hasNext() {
                return inputIterator.hasNext();
            }

            public I next() throws Exception, NoSuchElementException {
                return inputIterator.next();
            }
        };
    }

    public NextIterator(GCUBELog logger, RemoteIterator<I> inputIterator) {
        this.logger = logger;
        this.inputIterator = inputIterator;
    }

    public abstract O generateNext(I var1);

    protected boolean updateNext() {
        this.next = this.getNext();
        this.nextConsumed = false;
        return this.next != null;
    }

    protected O getNext() {
        while (this.inputIterator.hasNext()) {
            try {
                Object input = this.inputIterator.next();
                O output = this.generateNext(input);
                if (output == null) continue;
                return output;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.nextConsumed) {
            return this.updateNext();
        }
        return this.next != null;
    }

    public O next() {
        boolean updated;
        if (this.nextConsumed && !(updated = this.updateNext())) {
            throw new NoSuchElementException();
        }
        this.nextConsumed = true;
        return this.next;
    }

    public void close() {
        this.inputIterator.close();
    }

    public String locator() {
        return this.inputIterator.locator();
    }
}

