package org.gcube.contentmanagement.codelistmanager.util.opensdmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.codelistmanager.entities.TableField.ColumnType;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeRefType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.HierarchyType;

public class HCLSDMXImport extends SDMXImport {

	
	private String childColumn="hlchild_code";
	private String parentColumn="hlparent_code";
	
	private HierarchicalCodelistType codeList;
	
	public HCLSDMXImport(HierarchicalCodelistType codelist) {
		super();
		this.codeList = codelist;
	}
	
	
	/**
	 * @return the agencyId
	 */
	@Override
	public String getAgencyId() {
		return codeList.getAgencyID();
	}
	
	@Override
	public String getName() {
		if (codeList.getNames().size()>0) return codeList.getNames().get(0).getValue();
		else return "undefined";
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		if (codeList.getDescriptions().size()>0) return codeList.getDescriptions().get(0).getValue();
		else return "undefined";
	}
	
	/**
	 * @return the validFrom
	 */
	public String getValidFrom() {
		if (codeList.getValidFrom()!=null) return codeList.getValidFrom();
		else return "undefined";
	}

	/**
	 * @return the validTo
	 */
	public String getValidTo() {
		if (codeList.getValidTo()!=null) return codeList.getValidTo();
		else return "undefined";
	}

	/**
	 * @return the version
	 */
	public float getVersion() {
		if (codeList.getVersion()!=null) return Float.parseFloat(codeList.getVersion());
		else return 0.0f;
	}

	/**
	 * @return the isFinal
	 */
	public boolean isFinal() {
		 if(codeList.getIsFinal()==null) return false;
		 else return codeList.getIsFinal();
	}


	@Override
	protected List<FieldDefinition> retrieveFieldsDefinition() {
		List<FieldDefinition> fieldsDefinition = new ArrayList<FieldDefinition>();
		
		parentColumn = codeList.getCodelistReves().get(0).getAlias();
		childColumn = codeList.getCodelistReves().get(1).getAlias();
		
		fieldsDefinition.add(new FieldDefinition(parentColumn, new int[]{1,0}, new ColumnReference(ColumnType.HLParentCode, codeList.getCodelistReves().get(0).getAlias())));
		fieldsDefinition.add(new FieldDefinition(childColumn, new int[]{1,0}, new ColumnReference(ColumnType.HLChildCode, codeList.getCodelistReves().get(1).getAlias())));

			
		for (HierarchyType hyType :codeList.getHierarchies()){
			for(CodeRefType codeRef:hyType.getCodeReves()){
				FieldDefinition parentDef = fieldsDefinition.get(fieldsDefinition.indexOf(new FieldDefinition(parentColumn)));
				if(codeRef.getCodeID().length()>parentDef.getLength()[0]) parentDef.setLength(new int[]{codeRef.getCodeID().length(), parentDef.getLength()[1]});
				if(ImportUtil.getAfterDotLength(codeRef.getCodeID())>parentDef.getLength()[1]) parentDef.setLength(new int[]{parentDef.getLength()[0], ImportUtil.getAfterDotLength(codeRef.getCodeID())});
				FieldDefinition childDef = fieldsDefinition.get(fieldsDefinition.indexOf(new FieldDefinition(childColumn)));
				for (CodeRefType subCodeRef :codeRef.getCodeReves()){
					if (subCodeRef.getCodeID().length()>childDef.getLength()[0])childDef.setLength(new int[]{subCodeRef.getCodeID().length(), childDef.getLength()[1]});
					if (ImportUtil.getAfterDotLength(subCodeRef.getCodeID())>childDef.getLength()[1])childDef.setLength(new int[]{childDef.getLength()[0], ImportUtil.getAfterDotLength(subCodeRef.getCodeID())});
					totalLine++;
				}
			}
		}
		return fieldsDefinition;
	}
	
	@Override
	public void process(SimpleTable table, ProgresChangedEvent event)
	throws Exception {
		Insert insertQuery = DBSession.getImplementation(Insert.class);
		insertQuery.setTable(table);
		DBSession session = DBSession.connect()	;
		session.disableAutoCommit();
		try{
			for (HierarchyType hyType :codeList.getHierarchies()){
				String[] line = new String[this.fieldsDefinition.size()+1];
				line[0] ="DEFAULT";
				Arrays.fill(line, null);
				for(CodeRefType codeRef:hyType.getCodeReves()){
					line[fieldsDefinition.indexOf(new FieldDefinition(parentColumn))+1]= codeRef.getCodeID();
					for (CodeRefType subCodeRef :codeRef.getCodeReves()){
						line[fieldsDefinition.indexOf(new FieldDefinition(childColumn))+1]= subCodeRef.getCodeID();
						insertQuery.setInsertValues((Object[])line);
						insertQuery.execute(session);
						progress++;
						event.onProgresChanged(progress);
					}
				}
			}
			session.commit();
		}finally{
			if (session !=null) session.release();
		}
	}

}
