package org.gcube.contentmanagement.codelistmanager.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;

public class RowIterator implements Iterator<List<String>> {

	private DBSession session;
	
	private ResultSet rs;
	
	public RowIterator(Select select) throws Exception{
		super();
		session= DBSession.connect();
		try{
			rs = select.getResults(session); 
		} catch (Exception e){
			session.release();
			throw e;
		}
	}

	public boolean hasNext() {
		try{
			return rs.next();
		}catch (Exception e) {
			return false;
		}
	}

	public List<String> next(){
		try{
			ArrayList<String> returnList= new ArrayList<String>();
			for (int i=1;i<=rs.getMetaData().getColumnCount(); i++)
				returnList.add(rs.getString(i));
			return returnList;
		}catch (Exception e) {
			return null;
		}
	}

	public void remove() {
		try{
			rs.close();
		}catch (Exception e) {}
		session.release();
	}

}
