/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.managers.handlers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.BooleanAttribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ListSelect;
import org.gcube.common.dbinterface.conditions.Listable;
import org.gcube.common.dbinterface.conditions.NotInOperator;
import org.gcube.common.dbinterface.conditions.ORCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Update;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.exception.ColumnTypeNotSelectableException;
import org.gcube.contentmanagement.codelistmanager.exception.NullValuesOnCastException;
import org.gcube.contentmanagement.codelistmanager.exception.ValueNotFoundException;
import org.gcube.contentmanagement.codelistmanager.managers.handlers.CodeListCurationHandler;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalCodeListHandler
implements CodeListCurationHandler {
    private static final Logger logger = LoggerFactory.getLogger(HierarchicalCodeListHandler.class);
    private static HierarchicalCodeListHandler codelistHandler = new HierarchicalCodeListHandler();

    public static HierarchicalCodeListHandler get() {
        return codelistHandler;
    }

    @Override
    public Integer[] checkInvalidValues(String fieldId, ColumnReference columnReference, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) throws Exception {
        DBSession session = null;
        logger.debug("checking rows for columnReference " + columnReference.getCodelistReferenceId() + " " + columnReference.getCodelistReferenceName() + "  " + columnReference.getType().toString());
        if (columnReference.getType() != TableField.ColumnType.HLParentCode && columnReference.getType() != TableField.ColumnType.HLChildCode) {
            throw new Exception();
        }
        try {
            CodeList refCodelist = CodeList.get(columnReference.getCodelistReferenceId());
            Type type = new Type(refCodelist.getLabelFieldMapping().get(refCodelist.getCodeColumnId()).getDataType(), new int[0]);
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new SimpleAttribute("ID")});
            CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(fieldId), (Type)type);
            cast.setUseCastFunction(true);
            OperatorCondition cond = new OperatorCondition((Object)cast, null, " is ");
            Select opSelect = (Select)DBSession.getImplementation(Select.class);
            opSelect.setTables(new Table[]{refCodelist.getTable()});
            opSelect.setAttributes(new Attribute[]{new SimpleAttribute(refCodelist.getCodeColumnId())});
            cond = new ORCondition(new Condition[]{cond, new NotInOperator(new SimpleAttribute(cast.getCast()), (Listable)new ListSelect(opSelect))});
            select.setFilter((Condition)cond);
            select.setTables(new Table[]{table});
            logger.debug(select.getExpression());
            ResultSet result = select.getResults(session, new boolean[0]);
            ArrayList<Integer> toReturn = new ArrayList<Integer>();
            while (result.next()) {
                toReturn.add(result.getInt(1));
            }
            Integer[] integerArray = toReturn.toArray(new Integer[toReturn.size()]);
            return integerArray;
        }
        catch (Exception e) {
            logger.error("error evaluating the query", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    @Override
    public Integer[] checkInvalidValues(String fieldId, Type type, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new SimpleAttribute("ID")});
            CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(fieldId), (Type)type);
            cast.setUseCastFunction(true);
            OperatorCondition cond = new OperatorCondition((Object)cast, null, " is ");
            if (fieldLabelMapping.get(fieldId).getColumnReference().getType() == TableField.ColumnType.HLParentCode || fieldLabelMapping.get(fieldId).getColumnReference().getType() == TableField.ColumnType.HLChildCode) {
                CodeList refCodelist = CodeList.get(fieldLabelMapping.get(fieldId).getColumnReference().getCodelistReferenceId());
                Type externalType = new Type(refCodelist.getLabelFieldMapping().get(refCodelist.getCodeColumnId()).getDataType(), new int[0]);
                Select opSelect = (Select)DBSession.getImplementation(Select.class);
                opSelect.setTables(new Table[]{refCodelist.getTable()});
                opSelect.setAttributes(new Attribute[]{new SimpleAttribute(refCodelist.getCodeColumnId())});
                cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(fieldId), (Type)externalType);
                cast.setUseCastFunction(true);
                cond = new ORCondition(new Condition[]{cond, new NotInOperator(new SimpleAttribute(cast.getCast()), (Listable)new ListSelect(opSelect))});
            }
            select.setFilter((Condition)cond);
            select.setTables(new Table[]{table});
            logger.debug(select.getExpression());
            ResultSet result = select.getResults(session, new boolean[0]);
            ArrayList<Integer> toReturn = new ArrayList<Integer>();
            while (result.next()) {
                toReturn.add(result.getInt(1));
            }
            Integer[] integerArray = toReturn.toArray(new Integer[toReturn.size()]);
            return integerArray;
        }
        catch (Exception e) {
            logger.error("error evaluating the query", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    private boolean isRelationField(String fieldId, Hashtable<String, TableField> fieldLabelMapping) {
        return fieldLabelMapping.get(fieldId).getColumnReference().getType() == TableField.ColumnType.HLParentCode || fieldLabelMapping.get(fieldId).getColumnReference().getType() == TableField.ColumnType.HLChildCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceValue(String fieldId, String newValue, int rowId, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) throws Exception {
        if (this.isRelationField(fieldId, fieldLabelMapping)) {
            return this.setParent(fieldId, newValue, rowId, table, fieldLabelMapping);
        }
        Type type = (Type)table.getFieldsMapping().get(fieldId);
        Select select = (Select)DBSession.getImplementation(Select.class);
        CastObject cast = Utility.getCast((String)newValue, (Type)type);
        cast.setUseCastFunction(true);
        select.setAttributes(new Attribute[]{new BooleanAttribute("field", (Condition)new OperatorCondition((Object)cast, null, " IS NOT "))});
        DBSession session = null;
        try {
            session = DBSession.connect();
            ResultSet rs = select.getResults(session, new boolean[]{false});
            rs.next();
            if (!rs.getBoolean(1)) {
                boolean bl = false;
                return bl;
            }
            int[] tempLength = fieldLabelMapping.get(fieldId).getLength();
            if (newValue.length() > tempLength[0] || ImportUtil.getAfterDotLength(newValue) > tempLength[1]) {
                if (newValue.length() > tempLength[0]) {
                    tempLength[0] = newValue.length();
                }
                if (ImportUtil.getAfterDotLength(newValue) > tempLength[1]) {
                    tempLength[1] = ImportUtil.getAfterDotLength(newValue);
                }
                type.setPrecision(tempLength);
                this.changeColumnDataType(fieldId, type, table, fieldLabelMapping);
            }
            Update update = (Update)DBSession.getImplementation(Update.class);
            update.setTable((Table)table);
            update.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "=")});
            update.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute("ID"), (Object)rowId, "="));
            update.execute(session);
            boolean bl = update.getAffectedLines() > 0;
            return bl;
        }
        catch (Exception e) {
            logger.error("an error occuring trying to replace value", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setParent(String fieldId, String newValue, int rowId, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) throws ColumnTypeNotSelectableException, ValueNotFoundException, Exception {
        CodeList refCodelist = CodeList.get(fieldLabelMapping.get(fieldId).getColumnReference().getCodelistReferenceId());
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{table});
        select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
        CastObject castObject = Utility.getCast((String)newValue, (Type)((Type)refCodelist.getTable().getFieldsMapping().get(refCodelist.getCodeColumnId())));
        select.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(refCodelist.getCodeColumnId()), (Object)castObject, "="));
        DBSession session = null;
        try {
            session = DBSession.connect();
            ResultSet result = select.getResults(session, new boolean[0]);
            result.next();
            if (result.getInt(1) == 0) {
                throw new ValueNotFoundException();
            }
            Update update = (Update)DBSession.getImplementation(Update.class);
            update.setTable((Table)table);
            update.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)castObject, "=")});
            update.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute("ID"), (Object)rowId, "="));
            update.execute(session);
            if (update.getAffectedLines() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    @Override
    public void changeColumnType(String fieldId, TableField.ColumnType columnType, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping, String ... relatedCLId) throws ColumnTypeNotSelectableException, Exception {
        logger.debug("selected column type is " + columnType.toString());
        if (columnType == TableField.ColumnType.HLChildCode || columnType == TableField.ColumnType.HLParentCode) {
            if (relatedCLId.length == 0) {
                throw new ColumnTypeNotSelectableException();
            }
            logger.debug("related codelist selected is" + relatedCLId[0]);
            CodeList referenceCL = CodeList.get(relatedCLId[0]);
            fieldLabelMapping.get(fieldId).setColumnReference(new ColumnReference(columnType, referenceCL.getName(), referenceCL.getId()));
        } else if (columnType == TableField.ColumnType.Undefined) {
            fieldLabelMapping.get(fieldId).setColumnReference(new ColumnReference(columnType));
        } else {
            throw new ColumnTypeNotSelectableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeColumnDataType(String fieldId, Type type, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) throws NullValuesOnCastException {
        int nullValues;
        DBSession session = null;
        try {
            nullValues = this.checkInvalidValues(fieldId, type, table, fieldLabelMapping).length;
        }
        catch (Exception e) {
            return false;
        }
        if (nullValues > 0) {
            throw new NullValuesOnCastException();
        }
        try {
            session = DBSession.connect();
            ModifyColumnType changeColumnType = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
            changeColumnType.setColumn(new SimpleAttribute(fieldId));
            changeColumnType.setNewType(type);
            changeColumnType.setTable((Table)table);
            changeColumnType.setUseCast(true);
            changeColumnType.execute(session);
            fieldLabelMapping.get(fieldId).setDataType(type.getType());
            fieldLabelMapping.get(fieldId).setLength(type.getPrecisionArray());
            table.initializeFieldMapping(session);
        }
        catch (Exception e) {
            logger.error("error changeing column type ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRelationMatch(String fieldId, SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) {
        DBSession session = null;
        try {
            TableField relationCode = null;
            relationCode = fieldLabelMapping.get(fieldId);
            if (relationCode == null) {
                boolean bl = true;
                return bl;
            }
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            CodeList refCodelist = CodeList.get(fieldLabelMapping.get(fieldId).getColumnReference().getCodelistReferenceId());
            Type externalType = new Type(refCodelist.getLabelFieldMapping().get(refCodelist.getCodeColumnId()).getDataType(), new int[0]);
            Select subSelect = (Select)DBSession.getImplementation(Select.class);
            subSelect.setTables(new Table[]{refCodelist.getTable()});
            subSelect.setAttributes(new Attribute[]{new SimpleAttribute(Utility.getCast((SimpleAttribute)new SimpleAttribute(refCodelist.getCodeColumnId()), (Type)externalType).getCast())});
            refCodelist.getLabelFieldMapping().get(refCodelist.getCodeColumnId());
            CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(relationCode.getId()), (Type)externalType);
            cast.setUseCastFunction(true);
            select.setTables(new Table[]{table});
            select.setFilter((Condition)new NotInOperator(new SimpleAttribute(cast.getCast()), (Listable)new ListSelect(subSelect)));
            ResultSet rs = select.getResults(session, new boolean[]{false});
            rs.next();
            if (rs.getInt(1) > 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.debug("error matching parents", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return true;
    }

    @Override
    public boolean isMappingFinished(SimpleTable table, Hashtable<String, TableField> fieldLabelMapping) {
        for (TableField tf : fieldLabelMapping.values()) {
            if ((tf.getColumnReference().getType() == TableField.ColumnType.HLParentCode || tf.getColumnReference().getType() == TableField.ColumnType.HLChildCode) && this.checkRelationMatch(tf.getId(), table, fieldLabelMapping)) continue;
            return false;
        }
        return true;
    }
}

