/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapstransectgenerator.examples;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.preprocessing.sampling.AbsoluteSampling;
import com.rapidminer.tools.OperatorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.DBAquamapsExtractor;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.DBPostGISExtractror;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.tools.MapMerger;
import org.gcube.contentmanagement.graphtools.data.GraphSamplesTable;
import org.gcube.contentmanagement.graphtools.data.conversions.GraphConverter2D;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TransectLineGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;

public class ExampleDataBuiltGraph {
    private static final String LogFile = "ALog.properties";
    private static final String OperatorsFile = "operators.xml";

    public static void main(String[] args) throws Exception {
        String cfg = "./cfg/";
        String x1 = "0";
        String y1 = "0";
        String x2 = "+360";
        String y2 = "0";
        String SRID = "4326";
        String biodiversityfield = "maxspeciescountinacell";
        String tablename = "default2010_06_03_19_03_24_582";
        int maxelements = 1000;
        AnalysisLogger.setLogger((String)(cfg + LogFile));
        System.setProperty("rapidminer.init.operators", cfg + OperatorsFile);
        DBAquamapsExtractor dbaqua = new DBAquamapsExtractor(cfg);
        DBPostGISExtractror dbGis = new DBPostGISExtractror(cfg);
        RapidMiner.init();
        AnalysisLogger.getLogger().info((Object)"initialization complete");
        List<String> csquarecodes = dbGis.getAllInfo(x1, y1, x2, y2, SRID, tablename, biodiversityfield);
        int numbOfCodes = csquarecodes.size();
        if (numbOfCodes > 0) {
            Map<String, Double> biodiversityvalues = dbGis.getCalculatedBioValues();
            if (biodiversityvalues.size() > 0) {
                Map<String, String> longlat = dbaqua.getLongLatBioDiversity(csquarecodes, null);
                MapMerger mm = new MapMerger();
                mm.mergeMaps(longlat, biodiversityvalues);
                ArrayList longlatarray = mm.extractFirstVector();
                ArrayList biodivvalues = mm.extractSecondVector();
                GraphSamplesTable gts = null;
                GraphData grd = null;
                if (numbOfCodes > maxelements) {
                    AnalysisLogger.getLogger().trace((Object)"Resampling");
                    gts = new GraphSamplesTable("Biodiversity Transect", longlatarray, biodivvalues, false);
                    ExampleSet es = gts.generateExampleSet();
                    AbsoluteSampling asop = (AbsoluteSampling)OperatorService.createOperator((String)"AbsoluteSampling");
                    asop.setParameter("sample_size", "" + maxelements);
                    asop.setParameter("local_random_seed", "-1");
                    es = asop.apply(es);
                    gts = new GraphSamplesTable();
                    gts.generateSampleTable(es);
                    List singlegraph = GraphConverter2D.reorder((List)gts.getGraph());
                    grd = new GraphData(singlegraph, true);
                } else {
                    gts = new GraphSamplesTable("Biodiversity Transect", longlatarray, biodivvalues, true);
                    grd = new GraphData(gts.getGraph(), false);
                }
                GraphGroups graphgroups = new GraphGroups();
                graphgroups.addGraph("Distribution for " + tablename, grd);
                List pl = GraphConverter2D.getStationaryPoints((GraphData)grd);
                List lables = GraphConverter2D.getLablesFromPoints((Point)((Point)pl.get(0)));
                List<String> anotations = dbaqua.getAreaAnotations(lables);
                GraphConverter2D.anotateStationaryPoints((GraphGroups)graphgroups, anotations);
                TransectLineGraph series = new TransectLineGraph("");
                series.renderGraphGroup(graphgroups);
            } else {
                AnalysisLogger.getLogger().info((Object)"Empty Set Found");
            }
        }
    }
}

