/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.peer.message.Message;
import org.bitlet.wetorrent.peer.message.Piece;
import org.bitlet.wetorrent.util.stream.OutputStreamLimiter;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class MessageSender
implements ThreadTask {
    private Queue<Message> messagesToBeSent = new LinkedList<Message>();
    private boolean interrupted = false;
    private TorrentPeer peer;
    private long sentBytes;
    private long lastSentMessageMillis;
    private long uploaded = 0L;

    public MessageSender(TorrentPeer peer) {
        this.peer = peer;
    }

    public synchronized void addSentBytes(Integer byteNumber) {
        this.sentBytes += (long)byteNumber.intValue();
    }

    public synchronized long getSentBytes() {
        return this.sentBytes;
    }

    @Override
    public boolean execute() throws Exception {
        Message message = this.getMessage();
        if (message != null) {
            DataOutputStream os = new DataOutputStream(new OutputStreamLimiter(this.peer.getSocket().getOutputStream(), this.peer.getPeersManager().getTorrent().getUploadBandwidthLimiter()));
            if (message.getType() != -1) {
                byte[] payload = message.getPayload();
                if (payload != null) {
                    int payloadChunk;
                    os.writeInt(payload.length + 1);
                    os.writeByte(message.getType());
                    this.addSentBytes(5);
                    for (int payloadOffset = 0; payloadOffset < payload.length; payloadOffset += payloadChunk) {
                        int payloadMissing = payload.length - payloadOffset;
                        payloadChunk = payloadMissing > 1024 ? 1024 : payloadMissing;
                        os.write(payload, payloadOffset, payloadChunk);
                        this.addSentBytes(payloadChunk);
                        if (message.getType() != 7) continue;
                        this.uploaded += (long)(payloadChunk - (payloadOffset == 0 ? 13 : 0));
                    }
                } else {
                    os.writeInt(1);
                    os.writeByte(message.getType());
                    this.addSentBytes(5);
                }
            } else {
                os.writeInt(0);
                this.addSentBytes(4);
            }
            this.setLastSentMessageMillis(System.currentTimeMillis());
        }
        return true;
    }

    public synchronized void addMessage(Message message) {
        this.messagesToBeSent.add(message);
        this.notify();
    }

    private synchronized Message getMessage() {
        while (this.messagesToBeSent.size() == 0 && !this.interrupted) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.messagesToBeSent.poll();
    }

    @Override
    public synchronized void interrupt() {
        try {
            this.peer.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.messagesToBeSent.clear();
        this.interrupted = true;
        this.notify();
    }

    @Override
    public void exceptionCought(Exception e) {
        this.peer.interrupt();
        e.printStackTrace();
    }

    public synchronized void cancel(int index, int begin, int length) {
        LinkedList<Message> messagesToCancel = new LinkedList<Message>();
        for (Message elem : this.messagesToBeSent) {
            Piece block;
            if (elem.getType() != 7 || (block = (Piece)elem).getIndex() != index || block.getBegin() != begin || block.getLength() != length) continue;
            messagesToCancel.add(elem);
        }
        this.messagesToBeSent.removeAll(messagesToCancel);
    }

    public synchronized void cancelAll() {
        LinkedList<Message> messagesToCancel = new LinkedList<Message>();
        for (Message elem : this.messagesToBeSent) {
            if (elem.getType() != 7) continue;
            messagesToCancel.add(elem);
        }
        this.messagesToBeSent.removeAll(messagesToCancel);
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public synchronized long getLastSentMessageMillis() {
        return this.lastSentMessageMillis;
    }

    public synchronized void setLastSentMessageMillis(long lastSentMessageMillis) {
        this.lastSentMessageMillis = lastSentMessageMillis;
    }
}

