/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.bencode.Bencode;

public class Tracker {
    String announce;
    private Long lastRequestTime;
    private Long interval;
    private Long minInterval;
    private String trackerId;
    private String key;

    public Tracker(String announce) {
        this.announce = announce;
    }

    public Map trackerRequest(Torrent torrent, String event) throws MalformedURLException, IOException {
        String trackerUrlString = this.announce;
        trackerUrlString = trackerUrlString + "?info_hash=" + torrent.getMetafile().getInfoSha1Encoded();
        trackerUrlString = trackerUrlString + "&peer_id=" + torrent.getPeerIdEncoded();
        trackerUrlString = trackerUrlString + "&port=" + torrent.getIncomingPeerListener().getPort();
        trackerUrlString = trackerUrlString + "&uploaded=" + torrent.getPeersManager().getUploaded();
        trackerUrlString = trackerUrlString + "&downloaded=" + torrent.getPeersManager().getDownloaded();
        trackerUrlString = trackerUrlString + "&left=" + (torrent.getMetafile().getLength() - torrent.getTorrentDisk().getCompleted());
        trackerUrlString = trackerUrlString + "&compact=1";
        if (event != null) {
            trackerUrlString = trackerUrlString + "&event=" + event;
        }
        if (this.trackerId != null) {
            trackerUrlString = trackerUrlString + "&tracker_id=" + this.trackerId;
        }
        if (this.key != null) {
            trackerUrlString = trackerUrlString + "&key=" + this.key;
        }
        URL trackerUrl = new URL(trackerUrlString);
        HttpURLConnection conn = (HttpURLConnection)trackerUrl.openConnection();
        conn.setRequestProperty("User-Agent", "BitLet.org/0.1");
        Bencode trackerResponse = new Bencode(new BufferedInputStream(conn.getInputStream()));
        this.lastRequestTime = System.currentTimeMillis();
        Map responseDictionary = (Map)trackerResponse.getRootElement();
        byte[] failureReasonByteString = null;
        ByteBuffer failureReasonByteBuffer = (ByteBuffer)responseDictionary.get(ByteBuffer.wrap("failure reason".getBytes()));
        if (failureReasonByteBuffer != null) {
            failureReasonByteString = failureReasonByteBuffer.array();
        }
        if (failureReasonByteString != null) {
            return null;
        }
        try {
            byte[] warningMessageByteString = null;
            ByteBuffer warningMessageByteBuffer = (ByteBuffer)responseDictionary.get(ByteBuffer.wrap("warning message".getBytes()));
            if (warningMessageByteBuffer != null) {
                warningMessageByteString = warningMessageByteBuffer.array();
            }
            if (warningMessageByteString != null) {
                String warningMessage = new String(warningMessageByteString);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] trackerIdByteString = null;
        ByteBuffer trackerIdByteBuffer = (ByteBuffer)responseDictionary.get(ByteBuffer.wrap("tracker id".getBytes()));
        if (trackerIdByteBuffer != null) {
            trackerIdByteString = trackerIdByteBuffer.array();
        }
        if (trackerIdByteString != null) {
            this.trackerId = new String(trackerIdByteString);
        }
        this.interval = (Long)responseDictionary.get(ByteBuffer.wrap("interval".getBytes()));
        this.minInterval = (Long)responseDictionary.get(ByteBuffer.wrap("min interval".getBytes()));
        return responseDictionary;
    }

    public Long getInterval() {
        return this.interval;
    }

    public Long getMinInterval() {
        return this.minInterval;
    }

    public Long getLastRequestTime() {
        return this.lastRequestTime;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

