/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer.task;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class StartConnection
implements ThreadTask {
    boolean interrupted = false;
    private TorrentPeer peer;

    public StartConnection(TorrentPeer peer) {
        this.peer = peer;
    }

    @Override
    public boolean execute() throws Exception {
        Socket socket = this.connect(this.peer.getIp(), this.peer.getPort());
        this.peer.setSocket(socket);
        if (socket == null) {
            throw new Exception("Problem connecting to " + this.peer.getIp());
        }
        return false;
    }

    @Override
    public synchronized void interrupt() {
        this.interrupted = true;
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized Socket connect(InetAddress address, int port) throws Exception {
        if (!this.interrupted) {
            return new Socket(address, port);
        }
        throw new Exception("Interrupted before connecting");
    }

    @Override
    public void exceptionCought(Exception e) {
        if (e instanceof ConnectException) {
            // empty if block
        }
        this.peer.interrupt();
    }
}

