/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.disk;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bitlet.wetorrent.Metafile;
import org.bitlet.wetorrent.disk.FilePieceMapper;
import org.bitlet.wetorrent.disk.Piece;
import org.bitlet.wetorrent.disk.ResumeListener;
import org.bitlet.wetorrent.disk.TorrentDisk;

public class PlainFileSystemTorrentDisk
implements TorrentDisk {
    Metafile metafile;
    private List<Piece> pieces = new ArrayList<Piece>();
    List<RandomAccessFile> files = new LinkedList<RandomAccessFile>();
    File saveDirectory;

    public PlainFileSystemTorrentDisk(Metafile metafile, File saveDirectory) {
        this.metafile = metafile;
        this.saveDirectory = saveDirectory;
    }

    @Override
    public synchronized void resume() throws IOException {
        this.resume(null);
    }

    @Override
    public synchronized void resume(ResumeListener rl) throws IOException {
        long completed = 0L;
        long resumed = 0L;
        for (Piece p : this.pieces) {
            if (rl != null) {
                rl.percent(completed, resumed);
            }
            p.addPieceBlock(0, p.getLength());
            if (!p.checkSha1()) {
                p.clear();
            } else {
                resumed += (long)p.getLength();
            }
            completed += (long)p.getLength();
        }
        if (rl != null) {
            rl.percent(completed, resumed);
        }
    }

    @Override
    public synchronized boolean init() throws IOException {
        boolean resume = false;
        Long pieceNumber = 0L;
        for (Object elem : this.metafile.getPieces()) {
            byte[] sha1 = (byte[])elem;
            Piece piece = new Piece(sha1);
            if (pieceNumber < (long)(this.metafile.getPieces().size() - 1) && this.metafile.getLength() % this.metafile.getPieceLength() > 0L) {
                piece.setLength(this.metafile.getPieceLength().intValue());
            } else {
                piece.setLength(Long.valueOf(this.metafile.getLength() % this.metafile.getPieceLength()).intValue());
            }
            this.pieces.add(piece);
            Long l = pieceNumber;
            Long l2 = pieceNumber = Long.valueOf(pieceNumber + 1L);
        }
        this.saveDirectory.mkdirs();
        Long fileLength = 0L;
        if (this.metafile.isSingleFile()) {
            File persistentFile = new File(this.saveDirectory, this.metafile.getName());
            if (persistentFile.exists()) {
                resume = true;
            }
            RandomAccessFile raf = new RandomAccessFile(persistentFile, "rw");
            raf.setLength(this.metafile.getLength());
            this.files.add(raf);
        } else {
            if (!this.saveDirectory.getName().equals(this.metafile.getName())) {
                this.saveDirectory = new File(this.saveDirectory, this.metafile.getName());
                this.saveDirectory.mkdir();
            }
            for (Object elem : this.metafile.getFiles()) {
                Map file = (Map)elem;
                List path = (List)file.get(ByteBuffer.wrap("path".getBytes()));
                StringBuffer pathName = new StringBuffer();
                Iterator pathIterator = path.iterator();
                while (pathIterator.hasNext()) {
                    byte[] pathElem = ((ByteBuffer)pathIterator.next()).array();
                    pathName.append("/");
                    pathName.append(new String(pathElem));
                    if (!pathIterator.hasNext()) continue;
                    new File(this.saveDirectory, pathName.toString()).mkdir();
                }
                Long length = (Long)file.get(ByteBuffer.wrap("length".getBytes()));
                File persistentFile = new File(this.saveDirectory.getAbsolutePath() + pathName);
                if (persistentFile.exists()) {
                    resume = true;
                }
                RandomAccessFile raf = new RandomAccessFile(persistentFile, "rw");
                raf.setLength(length);
                fileLength = fileLength + length;
                this.files.add(raf);
            }
        }
        Iterator<RandomAccessFile> fileIterator = this.files.iterator();
        Iterator<Piece> pieceIterator = this.pieces.iterator();
        Long fileOffset = 0L;
        Long pieceOffset = 0L;
        Piece piece = pieceIterator.next();
        RandomAccessFile file = fileIterator.next();
        while (piece != null && file != null) {
            piece.addFilePointer(new FilePieceMapper(file, fileOffset, pieceOffset));
            Long pieceFreeBytes = (long)piece.getLength() - pieceOffset;
            Long fileMissingBytes = file.length() - fileOffset;
            if (pieceFreeBytes < fileMissingBytes) {
                fileOffset = fileOffset + pieceFreeBytes;
                piece = pieceIterator.hasNext() ? pieceIterator.next() : null;
                pieceOffset = 0L;
                continue;
            }
            if (pieceFreeBytes > fileMissingBytes) {
                pieceOffset = pieceOffset + fileMissingBytes;
                file = fileIterator.hasNext() ? fileIterator.next() : null;
                fileOffset = 0L;
                continue;
            }
            fileOffset = 0L;
            pieceOffset = 0L;
            file = fileIterator.hasNext() ? fileIterator.next() : null;
            if (pieceIterator.hasNext()) {
                piece = pieceIterator.next();
                continue;
            }
            piece = null;
        }
        return resume;
    }

    @Override
    public synchronized byte[] getBitfieldCopy() {
        byte[] bitField = new byte[(this.pieces.size() >> 3) + ((this.pieces.size() & 7) != 0 ? 1 : 0)];
        for (int i = 0; i < this.pieces.size(); ++i) {
            int n = i >> 3;
            bitField[n] = (byte)(bitField[n] | (this.pieces.get(i).isCompleted() ? 128 : 0) >> (i & 7));
        }
        return bitField;
    }

    @Override
    public synchronized void write(int index, int begin, byte[] block) throws IOException {
        Piece piece = this.pieces.get(index);
        if (!piece.isCompleted()) {
            piece.write(begin, block);
        }
    }

    @Override
    public synchronized byte[] read(int index, int begin, int length) throws IOException {
        Piece piece = this.pieces.get(index);
        return piece.read(begin, length);
    }

    @Override
    public synchronized Long getCompleted() {
        Long completed = 0L;
        for (Piece p : this.pieces) {
            completed = completed + (long)p.getCompleted();
        }
        return completed;
    }

    @Override
    public synchronized boolean isCompleted(int index) {
        return this.pieces.get(index).isCompleted();
    }

    @Override
    public synchronized int getDownloaded(int index) {
        return this.pieces.get(index).getCompleted();
    }

    @Override
    public synchronized boolean isAvaiable(int index, int begin, int length) {
        return this.pieces.get(index).isAvaiable(begin, length);
    }

    @Override
    public synchronized int getLength(int index) {
        return this.pieces.get(index).getLength();
    }

    @Override
    public synchronized int getFirstMissingByte(int index) {
        return this.pieces.get(index).getFirstMissingByte();
    }

    @Override
    public synchronized void close() {
        for (RandomAccessFile file : this.files) {
            try {
                file.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public synchronized long available(int index, int begin) {
        return this.available(index, begin, Long.MAX_VALUE);
    }

    @Override
    public synchronized long available(int index, int begin, long length) {
        boolean goOn = true;
        long avaiable = 0L;
        while (goOn) {
            Piece p = this.pieces.get(index);
            int pieceAvaiable = p.available(begin);
            avaiable += (long)pieceAvaiable;
            ++index;
            begin = 0;
            if (pieceAvaiable == p.getLength() - begin && (long)pieceAvaiable < length) continue;
            goOn = false;
        }
        return avaiable;
    }

    public synchronized File getFile() {
        return this.saveDirectory;
    }
}

