/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.model.app;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.xml.bind.JAXBException;
import org.gcube.rest.commons.db.dao.core.ConverterRecord;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.HostNode;
import org.hibernate.collection.internal.PersistentBag;
import org.w3c.dom.Node;

@Entity
@Table(name="host_node_model")
public class HostNodeModel
extends ConverterRecord<HostNode> {
    private static final long serialVersionUID = 1L;
    @Column(name="resourceId")
    private String resourceId;
    @Column(name="scopes")
    @ElementCollection
    private List<String> scopes;
    @Column(name="profile", columnDefinition="TEXT")
    private String profile;

    public HostNodeModel() {
    }

    public HostNodeModel(HostNode base) {
        this.copyFrom(base);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    public final void copyFrom(HostNode resource) {
        this.resourceId = resource.getId();
        if (resource.getScopes() != null) {
            this.scopes = Lists.newArrayList((Iterable)resource.getScopes());
        }
        if (resource.getProfile() != null) {
            try {
                this.profile = XMLConverter.convertToXML((Object)resource.getProfile());
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final HostNode copyTo() throws IllegalStateException {
        HostNode.Profile prof = null;
        try {
            prof = (HostNode.Profile)XMLConverter.fromXML((Node)XMLConverter.stringToNode((String)this.profile), HostNode.Profile.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        boolean scopesInit = false;
        try {
            if (!((PersistentBag)this.scopes).isEmpty()) {
                scopesInit = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList scopeListsList = scopesInit ? Lists.newArrayList(this.scopes) : new ArrayList();
        HostNode resource = new HostNode(this.resourceId, scopeListsList, prof);
        return resource;
    }
}

