/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.information.collector.rr;

import com.google.inject.Singleton;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gcube.rest.commons.db.dao.app.ResourceModelDao;
import org.gcube.rest.commons.db.dao.app.RunInstanceModelDao;
import org.gcube.rest.commons.db.dao.app.SerInstanceModelDao;
import org.gcube.rest.commons.db.model.app.ResourceModel;
import org.gcube.rest.commons.db.model.app.RunInstanceModel;
import org.gcube.rest.commons.db.model.app.SerInstanceModel;
import org.gcube.rest.commons.resourceawareservice.resources.HostNode;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance;
import org.gcube.rest.resourcemanager.discovery.InformationCollector;

@Singleton
public class RRInformationCollector
implements InformationCollector {
    private final ResourceModelDao resourceModelDao;
    private final RunInstanceModelDao runInstanceModelDao;
    private final SerInstanceModelDao serInstanceModelDao;

    @Inject
    public RRInformationCollector(ResourceModelDao resourceModelDao, RunInstanceModelDao runInstanceModelDao, SerInstanceModelDao serInstanceModelDao) {
        this.resourceModelDao = resourceModelDao;
        this.runInstanceModelDao = runInstanceModelDao;
        this.serInstanceModelDao = serInstanceModelDao;
    }

    public List<Resource> getGenericResourcesByID(String id, String scope) {
        List<ResourceModel> resources = this.resourceModelDao.getGenericResourcesByID(id, scope);
        return ResourceModelDao.convertToResourceList(resources);
    }

    public List<Resource> getGenericResourcesByName(String name, String scope) {
        List<ResourceModel> resources = this.resourceModelDao.getGenericResourcesByName(name, scope);
        return ResourceModelDao.convertToResourceList(resources);
    }

    public List<Resource> getGenericResourcesByType(String type, String scope) {
        List<ResourceModel> resources = this.resourceModelDao.getGenericResourcesByType(type, scope);
        return ResourceModelDao.convertToResourceList(resources);
    }

    public List<Resource> getGenericResourcesByTypeAndName(String type, String name, String scope) {
        List<ResourceModel> resources = this.resourceModelDao.getGenericResourcesByTypeAndName(type, name, scope);
        return ResourceModelDao.convertToResourceList(resources);
    }

    public List<String> listGenericResourceIDsByType(String type, String scope) {
        List<String> ids = this.resourceModelDao.listGenericResourceIDsByType(type, scope);
        return ids;
    }

    public Set<RunInstance> discoverRunningInstances(String serviceName, String serviceClass, String scope) {
        List<RunInstanceModel> results = this.runInstanceModelDao.getByServiceClassAndServiceNameAndScope(serviceClass, serviceName, scope);
        return RunInstanceModelDao.convertToRunInstanceSet(results);
    }

    public Set<RunInstance> discoverRunningInstancesFilteredByEndopointKey(String serviceName, String serviceClass, String endpointKey, String scope) {
        List<RunInstanceModel> results = this.runInstanceModelDao.getByServiceClassAndServiceNameAndScopeAndEndpointKey(serviceClass, serviceName, scope, endpointKey);
        return RunInstanceModelDao.convertToRunInstanceSet(results);
    }

    public List<SerInstance> discoverServiceInstances(String serviceName, String serviceClass, String scope) {
        List<SerInstanceModel> results = this.serInstanceModelDao.getByServiceClassAndServiceNameAndScope(serviceClass, serviceName, scope);
        return SerInstanceModelDao.convertToSerInstanceList(results);
    }

    public List<HostNode> discoverHostingNodes(String scope) {
        return null;
    }
}

