/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.is.publisher.is;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Singleton
public class PublisherISimpl<T extends GeneralResource>
extends ResourcePublisher<T> {
    private static final Logger logger = LoggerFactory.getLogger(PublisherISimpl.class);

    @Inject
    public PublisherISimpl() {
    }

    public static void main(String[] args) throws RegistryNotFoundException {
        String[] ids = new String[]{"46cd941b-7f8d-47f8-ac5d-b03ae7df1bb9", "54995120-1488-4936-a94f-22e76d0c154e", "5763138b-1925-4693-a48c-df3634173a7f", "869641eb-a9ca-4104-a573-552c237486b5", "b934d695-0f2f-45b7-aafb-6d56be7564c0", "bf27ca4f-1078-40e9-b872-c2afa23c6cfe", "d618fa42-3836-4b7c-a529-f3f41b27c836", "f95bd136-dfa7-4fb9-98d7-29402aad3b3c", "c5bd165b-41dc-4d43-bced-a4a524f4a078"};
        String[] scopes = new String[]{"/gcube/devNext/NextNext", "/gcube/devNext", "/gcube"};
        for (String id : ids) {
            for (String scope : scopes) {
                PublisherISimpl.remove(id, scope);
            }
        }
    }

    public static void remove(String id, String scope) throws RegistryNotFoundException {
        System.out.println("ID: " + id);
        System.out.println("scope: " + scope);
        GCoreEndpoint gce = null;
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/ID/text() eq '" + id + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 0) {
            gce = (GCoreEndpoint)resources.get(0);
            List<String> scopes = Arrays.asList(scope);
            ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
            publish.remove((org.gcube.common.resources.gcore.Resource)gce, scopes);
        }
    }

    public void deleteResource(String resourceID, String scope) throws ResourcePublisherException {
        logger.info("deleting resource with ID : " + resourceID + " from IS for scope : " + scope);
        GenericResource genericResource = PublisherISimpl.getResourceByID(resourceID, scope);
        if (genericResource == null) {
            throw new ResourcePublisherException("resource with id : " + resourceID + " not found");
        }
        this.deleteFromScopes(genericResource, scope);
    }

    private void deleteFromScopes(GenericResource genericResource, String scope) throws ResourcePublisherException {
        ScopeProvider.instance.set(scope);
        List<String> scopesList = Arrays.asList(scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        org.gcube.common.resources.gcore.Resource r = null;
        try {
            r = publish.remove((org.gcube.common.resources.gcore.Resource)genericResource, scopesList);
            logger.info("resource removed with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    public void publishResource(T resource, String resourceClass, String resourceNamePref, String scope, boolean includeIdInName, boolean onlyBody) throws ResourcePublisherException {
        block7: {
            logger.info("creating resource with ID : " + resource.getResourceID() + " to IS for scope : " + scope);
            GenericResource genericResource = null;
            try {
                genericResource = this.convertToGenericResource(resource, resourceClass, resourceNamePref, includeIdInName, onlyBody);
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                logger.error("error while converting resource to generic resource", e);
                throw new ResourcePublisherException("error while converting resource to generic resource", e);
            }
            logger.info(" resource to generic resource : " + genericResource);
            ScopeProvider.instance.set(scope);
            List<String> scopes = Arrays.asList(scope);
            ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
            org.gcube.common.resources.gcore.Resource r = null;
            try {
                r = publish.create((org.gcube.common.resources.gcore.Resource)genericResource, scopes);
                logger.info("resource updated with id : " + r.id());
                try {
                    String genericResourceXML = XMLConverter.convertToXML((Object)genericResource);
                    logger.trace("generic resource to be updated is        : " + genericResourceXML);
                    GenericResource isResource = PublisherISimpl.getResourceByID(resource.getResourceID(), scope);
                    if (isResource == null) {
                        logger.trace("generic resource has not been synced to IS yet. Comparisson is skipped");
                        break block7;
                    }
                    String genericResourceXMLFromIS = XMLConverter.convertToXML((Object)isResource);
                    logger.trace("generic resource as retrieved from IS is : " + genericResourceXMLFromIS);
                }
                catch (Exception e) {
                    logger.error("error while converting resource to generic resource", (Throwable)e);
                }
            }
            catch (RegistryNotFoundException e) {
                throw new ResourcePublisherException((Throwable)e);
            }
        }
    }

    public void updateResource(T resource, String resourceClass, String resourceNamePref, String scope, boolean includeIdinName, boolean onlyBody) throws ResourcePublisherException {
        block8: {
            logger.info("updating resource with ID : " + resource.getResourceID() + " to IS for scope : " + scope);
            ScopeProvider.instance.set(scope);
            ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
            GenericResource genericResource = null;
            try {
                genericResource = this.convertToGenericResource(resource, resourceClass, resourceNamePref, includeIdinName, onlyBody);
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                logger.error("error while converting resource to generic resource", e);
                throw new ResourcePublisherException(e);
            }
            try {
                org.gcube.common.resources.gcore.Resource r = null;
                if (!genericResource.scopes().asCollection().contains(scope)) {
                    genericResource.scopes().asCollection().add(scope);
                }
                r = publish.update((org.gcube.common.resources.gcore.Resource)genericResource);
                logger.info("resource updated with id : " + r.id());
                try {
                    String genericResourceXML = XMLConverter.convertToXML((Object)genericResource);
                    logger.trace("generic resource to be updated is        : " + genericResourceXML);
                    GenericResource isResource = PublisherISimpl.getResourceByID(resource.getResourceID(), scope);
                    if (isResource == null) {
                        logger.trace("generic resource has not been synced to IS yet. Comparisson is skipped");
                        break block8;
                    }
                    String genericResourceXMLFromIS = XMLConverter.convertToXML((Object)isResource);
                    logger.trace("generic resource as retrieved from IS is : " + genericResourceXMLFromIS);
                }
                catch (Exception e) {
                    logger.error("error while converting resource to generic resource", (Throwable)e);
                }
            }
            catch (RegistryNotFoundException e) {
                throw new ResourcePublisherException((Throwable)e);
            }
        }
    }

    private static GenericResource getResourceByID(String resourceID, String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + resourceID + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 0) {
            return (GenericResource)resources.get(0);
        }
        logger.warn("Could not find resource with ID : " + resourceID);
        return null;
    }

    private GCoreEndpoint convertToGcoreEndpoint(RunInstance ri) {
        Element node;
        GCoreEndpoint ge = null;
        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(XMLConverter.convertToXML((Object)ri).getBytes())).getDocumentElement();
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e1) {
            e1.printStackTrace();
            return ge;
        }
        node.getOwnerDocument().renameNode(node, null, "Resource");
        try {
            ge = (GCoreEndpoint)XMLConverter.fromXML((Node)node, GCoreEndpoint.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return ge;
    }

    public void updateResource(T ri, String scope) throws ResourcePublisherException {
        if (ri instanceof RunInstance) {
            ScopeProvider.instance.set(scope);
            ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
            try {
                publish.update((org.gcube.common.resources.gcore.Resource)this.convertToGcoreEndpoint((RunInstance)ri));
            }
            catch (RegistryNotFoundException e) {
                throw new ResourcePublisherException("could not update resource", (Throwable)e);
            }
        } else {
            throw new ResourcePublisherException("resource type not supported yet: " + ri.getClass().getCanonicalName());
        }
    }

    private GenericResource convertToGenericResource(T resource, String clazz, String name, boolean includeIdinName, boolean onlyBody) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        GenericResource genericResource = new GenericResource();
        ResourceMediator.setId((org.gcube.common.resources.gcore.Resource)genericResource, (String)resource.getResourceID());
        genericResource.newProfile();
        String genericResourceName = includeIdinName ? name + "." + resource.getResourceID() : name;
        logger.info("generic resource with id : " + resource.getResourceID() + " will have name : " + genericResourceName + " includeIdinName : " + includeIdinName + " : onlybody : " + onlyBody);
        genericResource.profile().name(genericResourceName);
        genericResource.profile().type(clazz);
        String serialization = resource.toXML();
        if (resource instanceof Resource) {
            Resource r = (Resource)resource;
            genericResource.profile().description(r.getDescription());
            genericResource.scopes().asCollection().addAll(r.getScopes());
            if (onlyBody) {
                serialization = r.getBodyAsString();
            }
        }
        logger.info("resource serialization : " + serialization);
        Element newBody = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization.getBytes())).getDocumentElement();
        genericResource.profile().newBody();
        Node importedNode = genericResource.profile().body().getOwnerDocument().importNode(newBody, true);
        genericResource.profile().body().appendChild(importedNode);
        return genericResource;
    }
}

