/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.resourceawareservice.resources;

import java.net.URI;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstanceStatus;
import org.w3c.dom.Node;

@XmlRootElement(name="RunInstance")
public class RunInstance
extends GeneralResource {
    private String id;
    private Set<String> scopes;
    private Profile profile;
    @XmlElement(name="Type")
    private String type = "RunningInstance";

    private RunInstance() {
    }

    public RunInstance(String id, Set<String> scopes, Profile profile) {
        this.id = id;
        this.scopes = scopes;
        this.profile = profile;
    }

    @XmlElement(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="Scope")
    @XmlElementWrapper(name="Scopes")
    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    @XmlElement(name="Profile")
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public static class DateFormatter {
        private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"){
            private static final long serialVersionUID = 1L;

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                StringBuffer toFix = super.format(date, toAppendTo, pos);
                return toFix.insert(toFix.length() - 2, ':');
            }
        };

        public static String formatDate(Date date) {
            return dateFormat.format(date).toString();
        }

        public static Date stringToDate(String dateString) throws ParseException {
            StringBuffer toFix = new StringBuffer(dateString);
            return dateFormat.parse(toFix.deleteCharAt(dateString.length() - 3).toString());
        }
    }

    @XmlRootElement(name="Profile")
    public static class Profile {
        @XmlElement(name="Description")
        public String description;
        @XmlElement(name="Version")
        public String version;
        @XmlElement(name="GHN")
        public GHN ghn = new GHN();
        @XmlElement(name="Service")
        public Service service = new Service();
        @XmlElement(name="ServiceName")
        public String serviceName;
        @XmlElement(name="ServiceClass")
        public String serviceClass;
        @XmlElement(name="DeploymentData")
        public DeploymentData deploymentData = new DeploymentData();
        @XmlElement(name="AccessPoint")
        public AccessPoint accessPoint = new AccessPoint();
        @XmlElement(name="SpecificData")
        public SpecificData specificData = new SpecificData();

        private Profile() {
        }

        public Profile(String description, String version, String ghnId, String serviceId, String serviceName, String serviceClass, Date activationTime, String status, Map<String, URI> accessPoint, Node specificData) {
            this.description = description;
            this.version = version;
            this.ghn.ghnId = ghnId;
            this.service.serviceId = serviceId;
            this.serviceName = serviceName;
            this.serviceClass = serviceClass;
            this.deploymentData.activationTime.value = activationTime != null ? DateFormatter.formatDate(activationTime) : "";
            this.deploymentData.status = RunInstanceStatus.valueOf(status);
            this.accessPoint.runningInstanceInterfaces = accessPoint;
            this.specificData.root = specificData;
        }

        @XmlRootElement
        public static class SpecificData {
            @XmlAnyElement
            public Node root;
        }

        public static class AccessPoint {
            @XmlJavaTypeAdapter(value=MapAdapter.class)
            @XmlElement(name="RunningInstanceInterfaces")
            public Map<String, URI> runningInstanceInterfaces = new HashMap<String, URI>();

            public static class MapElements {
                @XmlAttribute(name="EntryName")
                public String key;
                @XmlValue
                public URI value;

                private MapElements() {
                }

                public MapElements(String key, URI value) {
                    this.key = key;
                    this.value = value;
                }
            }

            public static class MyMap {
                @XmlElement(name="Endpoint")
                public List<MapElements> entries;
            }

            public static class MapAdapter
            extends XmlAdapter<MyMap, Map<String, URI>> {
                public Map<String, URI> unmarshal(MyMap value) throws Exception {
                    HashMap<String, URI> map = new HashMap<String, URI>();
                    for (MapElements entry : value.entries) {
                        map.put(entry.key, entry.value);
                    }
                    return map;
                }

                public MyMap marshal(Map<String, URI> value) throws Exception {
                    MyMap map = new MyMap();
                    map.entries = new ArrayList<MapElements>();
                    for (Map.Entry<String, URI> entry : value.entrySet()) {
                        map.entries.add(new MapElements(entry.getKey(), entry.getValue()));
                    }
                    return map;
                }
            }
        }

        public static class DeploymentData {
            @XmlElement(name="ActivationTime")
            public ActivationTime activationTime = new ActivationTime();
            @XmlElement(name="Status")
            public RunInstanceStatus status;

            public static class ActivationTime {
                @XmlAttribute(name="value")
                public String value;
            }
        }

        public static class Service {
            @XmlAttribute(name="UniqueID")
            public String serviceId;
        }

        public static class GHN {
            @XmlAttribute(name="UniqueID")
            public String ghnId;
        }
    }
}

