/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marytts.server.http.BaseHttpRequestHandler;
import marytts.server.http.MaryHttpServer;
import marytts.server.http.MaryHttpServerUtils;
import marytts.util.http.Address;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class FileRequestHandler
extends BaseHttpRequestHandler {
    private Set<String> validFiles = new HashSet<String>(Arrays.asList("favicon.ico", "index.html", "documentation.html", "mary.js"));

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) {
        String uri = request.getRequestLine().getUri();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (uri.equals("")) {
            uri = "index.html";
        }
        logger.debug("File requested: " + uri);
        if (this.validFiles.contains(uri)) {
            try {
                this.sendResourceAsStream(uri, response);
            }
            catch (IOException ioe) {
                logger.debug("Cannot send file", ioe);
                MaryHttpServerUtils.errorInternalServerError(response, "Cannot send file", ioe);
            }
        } else {
            MaryHttpServerUtils.errorFileNotFound(response, uri);
        }
    }

    @Override
    protected void handleClientRequest(String absPath, Map<String, String> queryItems, HttpResponse response, Address serverAddressAtClient) throws IOException {
    }

    private void sendResourceAsStream(String resourceFilename, HttpResponse response) throws IOException {
        InputStream stream = MaryHttpServer.class.getResourceAsStream(resourceFilename);
        String contentType = resourceFilename.endsWith(".html") ? "text/html; charset=UTF-8" : (resourceFilename.endsWith(".wav") ? "audio/wav" : (resourceFilename.endsWith(".m3u") ? "audio/x-mpegurl" : (resourceFilename.endsWith(".swf") ? "application/x-shockwave-flash" : "text/plain")));
        if (stream != null) {
            MaryHttpServerUtils.toHttpResponse(stream, response, contentType);
        } else {
            MaryHttpServerUtils.errorFileNotFound(response, resourceFilename);
        }
    }
}

