/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.DoubleSparseArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.wizards.PreviewListener;
import com.rapidminer.operator.DocumentSelectorListModel;
import com.rapidminer.operator.FeatureExtractionOperator;
import com.rapidminer.operator.FeaturesTableModel;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.extraction.AttributeQueryMap;
import com.rapidminer.operator.extraction.DefaultFeatureExtractor;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.util.FeatureExtractionUtil;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.tools.OperatorService;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTFileInputList;
import edu.udo.cs.wvtool.main.WVTool;
import edu.udo.cs.wvtool.util.WVToolException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WVToolPreviewer
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 8889036332147144390L;
    private String errorMessages = "You must specify at least one directory containing at least on text in \"texts\"";
    private final JTextArea textAreaOriginal;
    private final JList selectorList;
    private final FeaturesTableModel model;
    private final Parameters params;
    private final DocumentSelectorListModel listModel = new DocumentSelectorListModel();
    private WVTConfiguration config;

    public WVToolPreviewer(PreviewListener listener) {
        super(RapidMinerGUI.getMainFrame(), "WVTool Previewer", true);
        this.textAreaOriginal = new JTextArea();
        this.textAreaOriginal.setWrapStyleWord(true);
        this.textAreaOriginal.setLineWrap(true);
        this.textAreaOriginal.setMargin(new Insets(10, 10, 10, 10));
        this.model = new FeaturesTableModel();
        JTable featureTable = new JTable();
        featureTable.setModel(this.model);
        this.selectorList = new JList();
        this.selectorList.setSelectionMode(0);
        this.selectorList.addListSelectionListener(this);
        this.selectorList.setModel(this.listModel);
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WVToolPreviewer.this.dispose();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.gridy = -1;
        gbcLabel.fill = 2;
        gbcLabel.weightx = 1.0;
        gbcLabel.weighty = 0.0;
        gbcLabel.insets = new Insets(10, 10, 10, 10);
        JLabel label = new JLabel("Select a document");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.selectorList), gbc);
        label = new JLabel("Original text");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.textAreaOriginal), gbc);
        label = new JLabel("Stream of processed tokens");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        label = new JLabel("Extracted features");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(featureTable), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(7, 7, 7, 7);
        this.getContentPane().add((Component)okButton, gbc);
        this.setSize(Math.max(640, (int)(0.66 * (double)this.getOwner().getWidth())), Math.max(480, (int)(0.66 * (double)this.getOwner().getHeight())));
        this.setLocationRelativeTo(this.getOwner());
        this.params = listener.getParameters();
        try {
            Process process = listener.getProcess();
            FeatureExtractionOperator w = null;
            w = OperatorService.createOperator(FeatureExtractionOperator.class);
            if (process != null) {
                w.setExternalExperiment(process);
            }
            w.setParameters(listener.getParameters());
            List<String[]> textList = Parameters.transformString2List(listener.getParameters().getParameter("texts"));
            if (textList != null && textList.size() > 0) {
                this.config = new WVTConfiguration();
                WVTFileInputList inputList = (WVTFileInputList)w.createInputList();
                Iterator it = inputList.getEntries(true);
                while (it.hasNext()) {
                    this.listModel.addEntry((WVTDocumentInfo)it.next());
                }
                if (this.listModel.getSize() > 0) {
                    WVTDocumentInfo testDocument = this.listModel.getDocInfoAt(0);
                    this.selectorList.setSelectedIndex(0);
                    this.openTextDocument(testDocument);
                } else {
                    this.textAreaOriginal.setText(this.errorMessages);
                }
            } else {
                this.textAreaOriginal.setText(this.errorMessages);
            }
        }
        catch (OperatorCreationException e) {
            this.textAreaOriginal.setText(this.errorMessages);
        }
        catch (OperatorException e) {
            this.textAreaOriginal.setText(this.errorMessages);
        }
    }

    private void openTextDocument(WVTDocumentInfo testDocument) {
        try {
            WVTFileInputList inputList2 = new WVTFileInputList(0);
            inputList2.addEntry(testDocument);
            WVTool wvt = new WVTool(false);
            BufferedReader origIn = new BufferedReader(wvt.getReader(testDocument, this.config));
            StringBuffer originalText = new StringBuffer();
            String buf = null;
            while ((buf = origIn.readLine()) != null) {
                originalText.append(buf);
                originalText.append("\n");
            }
            origIn.close();
            this.textAreaOriginal.setText(originalText.toString());
            AttributeQueryMap aqMap = FeatureExtractionUtil.getAttributeQueryMap(this.params);
            new MemoryExampleTable(aqMap.getAttributes());
            DefaultFeatureExtractor defaultExtractor = new DefaultFeatureExtractor(aqMap, this.config);
            DoubleSparseArrayDataRow row = new DoubleSparseArrayDataRow(aqMap.getAttributes().size());
            defaultExtractor.extract(testDocument, row);
            for (Attribute att : aqMap.getAttributes()) {
                if (!Double.isNaN(row.get(att))) {
                    if (att.isNominal()) {
                        this.model.putValue(att.getName(), att.getMapping().mapIndex((int)row.get(att)));
                        continue;
                    }
                    this.model.putValue(att.getName(), String.valueOf(row.get(att)));
                    continue;
                }
                this.model.putValue(att.getName(), "unknown");
            }
        }
        catch (IOException e) {
            this.textAreaOriginal.setText(this.errorMessages);
        }
        catch (ExtractionException e) {
            this.textAreaOriginal.setText(this.errorMessages);
        }
        catch (WVToolException e) {
            this.textAreaOriginal.setText(this.errorMessages);
        }
        this.textAreaOriginal.setCaretPosition(0);
    }

    public void valueChanged(ListSelectionEvent arg0) {
        int index = this.selectorList.getSelectedIndex();
        if (index >= 0) {
            this.openTextDocument(this.listModel.getDocInfoAt(index));
        }
    }
}

