/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SimilarityKDistanceVisualization
extends PlotterAdapter
implements ActionListener {
    private static final long serialVersionUID = -3774235976141625821L;
    private static final int DEFAULT_K_NUMBER = 3;
    private static final int LABEL_MARGIN_X = 50;
    private static final int LABEL_MARGIN_Y = 15;
    private static final Font SCALED_LABEL_FONT = LABEL_FONT.deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double xTicSize;
    private double yTicSize;
    private DistanceMeasure measure = null;
    private ExampleSet exampleSet = null;
    private JTextField k_distance_jtext;
    private int updatePanelHeight;
    private LinkedList<Double> kDistanceValues;
    private int k = 3;

    public SimilarityKDistanceVisualization(DistanceMeasure measure, ExampleSet exampleSet) {
        this.measure = measure;
        this.exampleSet = exampleSet;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        JLabel label = null;
        label = new JLabel("k : ");
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(this);
        this.k_distance_jtext = new JTextField();
        this.k_distance_jtext.setText(Integer.toString(this.k));
        this.k_distance_jtext.setColumns(5);
        JPanel updatePanel = new JPanel(new FlowLayout());
        updatePanel.add(label);
        updatePanel.add(this.k_distance_jtext);
        updatePanel.add(updateButton);
        JPanel updatePanelAligned = new JPanel(new BorderLayout());
        updatePanelAligned.add((Component)updatePanel, "West");
        this.add((Component)updatePanelAligned, "North");
        this.updatePanelHeight = updatePanelAligned.getHeight();
    }

    public JComponent getOptionsComponent(int index) {
        JLabel label = new JLabel("K:");
        label.setToolTipText("Set the k which should be displayed.");
        return label;
    }

    public void setK(int k) {
        this.k = k;
        this.repaint();
    }

    protected void prepareData() {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        int numberOfExamples = this.exampleSet.size();
        if (this.k >= numberOfExamples) {
            LogService.getGlobal().log("KDistanceVisualization: k is larger than the number of examples", 5);
            this.k = numberOfExamples;
        }
        this.minX = 0.0;
        this.maxX = numberOfExamples;
        this.kDistanceValues = new LinkedList();
        for (Example example : this.exampleSet) {
            ArrayList<Double> sortList = new ArrayList<Double>();
            for (Example compExample : this.exampleSet) {
                sortList.add(this.measure.calculateDistance(example, compExample));
            }
            Collections.sort(sortList);
            double currentValue = (Double)sortList.get(this.k - 1);
            this.minY = Math.min(this.minY, currentValue);
            this.maxY = Math.max(this.maxY, currentValue);
            this.kDistanceValues.add(currentValue);
        }
        Collections.sort(this.kDistanceValues);
        Collections.reverse(this.kDistanceValues);
        this.xTicSize = this.getNumericalTicSize(this.minX, this.maxX);
        this.yTicSize = this.getNumericalTicSize(this.minY, this.maxY);
        this.minX = Math.floor(this.minX / this.xTicSize) * this.xTicSize;
        this.maxX = Math.ceil(this.maxX / this.xTicSize) * this.xTicSize;
        this.minY = Math.floor(this.minY / this.yTicSize) * this.yTicSize;
        this.maxY = Math.ceil(this.maxY / this.yTicSize) * this.yTicSize;
    }

    protected void drawPoints(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.kDistanceValues != null && this.kDistanceValues.size() <= 2) {
            LogService.getGlobal().log("KDistanceVisualization: No values in value map", 5);
            return;
        }
        if (this.kDistanceValues != null) {
            Iterator it = this.kDistanceValues.iterator();
            double offset = 0.0;
            while (it.hasNext()) {
                this.drawPoint(g, offset + dx, ((Double)it.next() + dy) * sy, Color.RED, Color.BLACK);
                offset += sx;
            }
        }
    }

    private void drawGrid(Graphics2D g, double dx, double dy, double sx, double sy) {
        DecimalFormat format = new DecimalFormat("0.00E0");
        g.setFont(SCALED_LABEL_FONT);
        int numberOfXTics = (int)Math.ceil((this.maxX - this.minX) / this.xTicSize) + 1;
        int i = 0;
        while (i < numberOfXTics) {
            this.drawVerticalTic(g, i, format, dx, dy, sx, sy);
            ++i;
        }
        int numberOfYTics = (int)Math.ceil((this.maxY - this.minY) / this.yTicSize) + 1;
        int i2 = 0;
        while (i2 < numberOfYTics) {
            this.drawHorizontalTic(g, i2, format, dx, dy, sx, sy);
            ++i2;
        }
    }

    private void drawVerticalTic(Graphics2D g, int ticNumber, DecimalFormat format, double dx, double dy, double sx, double sy) {
        double x = (double)ticNumber * this.xTicSize + this.minX;
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((x + dx) * sx, (this.minY + dy) * sy, (x + dx) * sx, (this.maxY + dy) * sy));
        g.setColor(Color.black);
    }

    private void drawHorizontalTic(Graphics2D g, int ticNumber, DecimalFormat format, double dx, double dy, double sx, double sy) {
        double y = (double)ticNumber * this.yTicSize + this.minY;
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((this.minX + dx) * sx, (y + dy) * sy, (this.maxX + dx) * sx, (y + dy) * sy));
        g.setColor(Color.black);
        String label = String.valueOf(format.format(y)) + " ";
        Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
        g.drawString(label, (float)((this.minX + dx) * sx - stringBounds.getWidth()), (float)((y + dy) * sy - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
    }

    private void drawPoints(Graphics2D g, int pixWidth, int pixHeight) {
        double sx = 0.0;
        double sy = 0.0;
        sx = ((double)pixWidth - 50.0) / (this.maxX - this.minX);
        sy = ((double)pixHeight - 15.0) / (this.maxY - this.minY);
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        coordinateSpace.translate(50, 15);
        this.drawGrid(coordinateSpace, -this.minX, -this.minY, sx, sy);
        this.drawPoints(coordinateSpace, -this.minX, -this.minY, sx, sy);
        coordinateSpace.dispose();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40 - this.updatePanelHeight - 50;
        Graphics2D translated = (Graphics2D)graphics.create();
        translated.translate(20, 20);
        this.paintGraph(translated, pixWidth, pixHeight);
    }

    public void paintGraph(Graphics graphics, int pixWidth, int pixHeight) {
        Graphics2D g = (Graphics2D)graphics;
        Graphics2D scaled = (Graphics2D)g.create();
        scaled.translate(0, pixHeight + 1 + this.updatePanelHeight + 50);
        this.prepareData();
        scaled.scale(1.0, -1.0);
        g.setColor(Color.black);
        this.drawPoints(scaled, pixWidth, pixHeight);
        scaled.dispose();
        String xAxisLabel = "sorted k-distances";
        Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(xAxisLabel, g.getFontRenderContext());
        g.drawString(xAxisLabel, 20.0f + (float)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0), 20.0f + (float)((double)pixHeight - 2.0 * stringBounds.getHeight()) + 3.0f);
        String yAxisLabel = "k-distance value";
        stringBounds = LABEL_FONT.getStringBounds(yAxisLabel, g.getFontRenderContext());
        g.drawString(yAxisLabel, 20, (int)(20.0 + stringBounds.getHeight() + 6.0));
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            Integer.parseInt(this.k_distance_jtext.getText());
        }
        catch (NumberFormatException e) {
            SwingTools.showVerySimpleErrorMessage("Please enter a integer value for k");
            return;
        }
        this.k = Integer.parseInt(this.k_distance_jtext.getText());
        this.kDistanceValues = null;
        this.repaint();
    }
}

