/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog.boxviewer;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.actions.BoxViewerExportAction;
import com.rapidminer.gui.dialog.actions.BoxViewerPrintAction;
import com.rapidminer.gui.dialog.boxviewer.ProcessRenderer;
import com.rapidminer.gui.tools.ComponentPrinter;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.freehep.util.export.ExportDialog;

public class BoxViewerDialog
extends JDialog {
    private static final long serialVersionUID = -1090928037950227038L;
    public final transient Action PRINT_ACTION_24 = new BoxViewerPrintAction(this, IconSize.SMALL);
    public final transient Action PRINT_ACTION_32 = new BoxViewerPrintAction(this, IconSize.MIDDLE);
    public final transient Action EXPORT_ACTION_24 = new BoxViewerExportAction(this, IconSize.SMALL);
    public final transient Action EXPORT_ACTION_32 = new BoxViewerExportAction(this, IconSize.MIDDLE);
    private ProcessRenderer processRenderer;
    private transient PrinterJob printerJob = PrinterJob.getPrinterJob();

    public BoxViewerDialog(Operator operator) {
        super(RapidMinerGUI.getMainFrame(), "Box View", false);
        this.setLayout(new BorderLayout());
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.add(this.PRINT_ACTION_32);
        toolBar.add(this.EXPORT_ACTION_32);
        this.add((Component)toolBar, "North");
        this.processRenderer = new ProcessRenderer();
        this.processRenderer.setOperator(RapidMinerGUI.getMainFrame().getProcess().getRootOperator());
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.processRenderer);
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxViewerDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.setSize(400, 600);
        this.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
    }

    protected Object readResolve() {
        this.printerJob = PrinterJob.getPrinterJob();
        return this;
    }

    public void printProcess() {
        this.printerJob.setPrintable(new ComponentPrinter(this.processRenderer));
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
            }
            catch (PrinterException pe) {
                SwingTools.showSimpleErrorMessage("Printer error", pe);
            }
        }
    }

    public void exportProcess() {
        ExportDialog exportDialog = new ExportDialog("RapidMiner");
        exportDialog.showExportDialog((Component)RapidMinerGUI.getMainFrame(), "Export", (Component)this.processRenderer, RapidMinerGUI.getMainFrame().getBaseName());
    }
}

