/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordTagSampleStreamFactory
implements ObjectStreamFactory<POSSample> {
    @Override
    public String getUsage() {
        return ArgumentParser.createUsage(Parameters.class);
    }

    @Override
    public boolean validateArguments(String[] args) {
        return ArgumentParser.validateArguments(args, Parameters.class);
    }

    ObjectStream<POSSample> create(Parameters params) {
        try {
            PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader((InputStream)CmdLineUtil.openInFile(new File(params.getData())), params.getEncoding()));
            return new WordTagSampleStream(lineStream);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Encoding not supported: " + params.getEncoding());
            throw new TerminateToolException(-1);
        }
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        return this.create(params);
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="sampleData")
        public String getData();

        @ArgumentParser.ParameterDescription(valueName="charsetName")
        public String getEncoding();
    }
}

