/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.Locale;
import marytts.cart.DirectedGraph;
import marytts.cart.io.DirectedGraphReader;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.TargetFeatureComputer;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.select.Target;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import marytts.util.math.ArrayUtils;
import marytts.util.math.Polynomial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class PolynomialF0Modeller
extends InternalModule {
    protected FeatureFileReader contourFeatures;
    protected DirectedGraph contourGraph;
    protected TargetFeatureComputer featureComputer;
    private String propertyPrefix;
    private FeatureProcessorManager featureProcessorManager;

    public PolynomialF0Modeller(String locale, String propertyPrefix, String featprocClassInfo) throws Exception {
        this(MaryUtils.string2locale(locale), propertyPrefix, (FeatureProcessorManager)MaryRuntimeUtils.instantiateObject(featprocClassInfo));
    }

    protected PolynomialF0Modeller(Locale locale, String propertyPrefix, FeatureProcessorManager featureProcessorManager) {
        super("PolynomialF0Modeller", MaryDataType.DURATIONS, MaryDataType.ACOUSTPARAMS, locale);
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + ".";
        this.featureProcessorManager = featureProcessorManager;
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        this.contourFeatures = new FeatureFileReader(MaryProperties.needFilename(this.propertyPrefix + "contours"));
        this.contourGraph = new DirectedGraphReader().load(MaryProperties.needFilename(this.propertyPrefix + "graph"));
        this.featureComputer = new TargetFeatureComputer(this.featureProcessorManager, this.contourGraph.getFeatureDefinition().getFeatureNames());
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        NodeIterator sentenceIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NameNodeFilter("s"), false);
        Element sentence = null;
        AllophoneSet allophoneSet = null;
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            Element syllable;
            DirectedGraph voiceGraph;
            Element voice = (Element)MaryDomUtils.getAncestor((Node)sentence, "voice");
            Voice maryVoice = Voice.getVoice(voice);
            if (maryVoice == null) {
                maryVoice = d.getDefaultVoice();
            }
            if (maryVoice == null) {
                Locale locale = MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
                maryVoice = Voice.getDefaultVoice(locale);
            }
            FeatureFileReader currentContours = this.contourFeatures;
            DirectedGraph currentGraph = this.contourGraph;
            TargetFeatureComputer currentFeatureComputer = this.featureComputer;
            if (maryVoice != null && (voiceGraph = maryVoice.getF0Graph()) != null) {
                FeatureFileReader voiceContourFeatures;
                currentGraph = voiceGraph;
                this.logger.debug("Using voice graph");
                FeatureDefinition voiceFeatDef = voiceGraph.getFeatureDefinition();
                currentFeatureComputer = new TargetFeatureComputer(this.featureProcessorManager, voiceFeatDef.getFeatureNames());
                currentContours = voiceContourFeatures = maryVoice.getF0ContourFeatures();
            }
            TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(sentence, 1, new NameNodeFilter("syllable"), false);
            Object previous = null;
            while ((syllable = (Element)tw.nextNode()) != null) {
                Element vowel = null;
                float sylDur = 0.0f;
                Element s = MaryDomUtils.getFirstChildElement(syllable);
                while (s != null) {
                    assert (s.getTagName().equals("ph")) : "expected phone element, found " + s.getTagName();
                    if (s.hasAttribute("d")) {
                        sylDur += Float.parseFloat(s.getAttribute("d"));
                    }
                    String phone = s.getAttribute("p");
                    if (allophoneSet == null) {
                        allophoneSet = MaryRuntimeUtils.determineAllophoneSet(s);
                    }
                    assert (allophoneSet != null);
                    Allophone allophone = allophoneSet.getAllophone(phone);
                    assert (allophone != null) : "Unknown allophone: [" + phone + "]";
                    if (allophone.isVowel()) {
                        vowel = s;
                    }
                    s = MaryDomUtils.getNextSiblingElement(s);
                }
                if (vowel == null) continue;
                String phone = vowel.getAttribute("p");
                Target t = new Target(phone, vowel);
                t.setFeatureVector(currentFeatureComputer.computeFeatureVector(t));
                int[] leafContours = (int[])currentGraph.interpret(t);
                if (leafContours == null) continue;
                double[] coeffs = this.getMeanContour(currentContours, leafContours);
                float posInSyl = 0.0f;
                float relStart = 0.0f;
                float relEnd = 0.0f;
                Element s2 = MaryDomUtils.getFirstChildElement(syllable);
                while (s2 != null) {
                    if (s2.hasAttribute("d")) {
                        float dur = Float.parseFloat(s2.getAttribute("d"));
                        relStart = posInSyl / sylDur;
                        relEnd = (posInSyl += dur) / sylDur;
                        double initialLogF0 = Polynomial.getValueAt(coeffs, relStart);
                        double midLogF0 = Polynomial.getValueAt(coeffs, (relStart + relEnd) / 2.0f);
                        double finalLogF0 = Polynomial.getValueAt(coeffs, relEnd);
                        StringBuilder f0String = new StringBuilder();
                        if (!Double.isNaN(initialLogF0)) {
                            f0String.append("(0,").append((int)Math.exp(initialLogF0)).append(")");
                        }
                        if (!Double.isNaN(midLogF0)) {
                            f0String.append("(50,").append((int)Math.exp(midLogF0)).append(")");
                        }
                        if (!Double.isNaN(finalLogF0)) {
                            f0String.append("(100,").append((int)Math.exp(finalLogF0)).append(")");
                        }
                        if (f0String.length() > 0) {
                            s2.setAttribute("f0", f0String.toString());
                        }
                    }
                    s2 = MaryDomUtils.getNextSiblingElement(s2);
                }
                assert (posInSyl == sylDur);
            }
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setDocument(doc);
        return output;
    }

    protected double[] getMeanContour(FeatureFileReader currentContours, int[] contourIDs) {
        double[] coeffs = null;
        for (int i = 0; i < contourIDs.length; ++i) {
            float[] oneCoeffs = currentContours.getFeatureVector(contourIDs[i]).getContinuousFeatures();
            assert (!ArrayUtils.isZero(oneCoeffs)) : "Feature vector " + contourIDs[i] + " is zero";
            if (coeffs == null) {
                coeffs = new double[oneCoeffs.length];
            }
            for (int j = 0; j < oneCoeffs.length; ++j) {
                int n = j;
                coeffs[n] = coeffs[n] + (double)oneCoeffs[j];
            }
        }
        int j = 0;
        while (j < coeffs.length) {
            int n = j++;
            coeffs[n] = coeffs[n] / (double)contourIDs.length;
        }
        return coeffs;
    }
}

