/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSParameterGeneration;
import marytts.signalproc.process.AmplitudeNormalizer;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.MaryUtils;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.ProducingDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.FileUtils;
import marytts.util.io.LEDataInputStream;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFT;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class HTSVocoder {
    public static final int RANDMAX = Short.MAX_VALUE;
    public static final int IPERIOD = 1;
    public static final int SEED = 1;
    public static final int B0 = 1;
    public static final int B28 = 0x10000000;
    public static final int B31 = Integer.MIN_VALUE;
    public static final int B31_ = Integer.MAX_VALUE;
    public static final int Z = 0;
    public static final boolean GAUSS = true;
    public static final int PADEORDER = 5;
    public static final int IRLENG = 96;
    public static final boolean NORMFLG1 = true;
    public static final boolean NORMFLG2 = false;
    public static final boolean MULGFLG1 = true;
    public static final boolean MULGFLG2 = false;
    public static final boolean NGAIN = false;
    public static final double ZERO = 1.0E-10;
    public static final double LZERO = -1.0E10;
    public static final double LTPI = 1.83787706640935;
    private Logger logger = MaryUtils.getLogger("Vocoder");
    Random rand;
    private int stage;
    private double gamma;
    private boolean use_log_gain;
    private int fprd;
    private int iprd;
    private boolean gauss;
    private double p1;
    private double pc;
    private double[] pade;
    private int ppade;
    private double[] C;
    private double[] CC;
    private double[] CINC;
    private double[] D1;
    private double[] freqt_buff;
    private int freqt_size;
    private double[] spectrum2en_buff;
    private int spectrum2en_size;
    private double[] postfilter_buff;
    private int postfilter_size;
    private double[] lsp2lpc_buff;
    private int lsp2lpc_size;
    private double[] gc2gc_buff;
    private int gc2gc_size;
    private double rate;
    int pt1;
    int pt2;
    int[] pt3;
    private int numM;
    private int orderM;
    private double[][] h;
    private double[] xpulseSignal;
    private double[] xnoiseSignal;
    private boolean mixedExcitation = false;
    private boolean fourierMagnitudes = false;
    private boolean lpcVocoder = false;

    public void setUseLpcVocoder(boolean bval) {
        this.lpcVocoder = bval;
    }

    private void initVocoder(int mcep_order, int mcep_vsize, HMMData htsData) {
        this.stage = htsData.getStage();
        this.gamma = this.stage != 0 ? -1.0 / (double)this.stage : 0.0;
        this.use_log_gain = htsData.getUseLogGain();
        this.fprd = htsData.getFperiod();
        this.rate = htsData.getRate();
        this.iprd = 1;
        this.gauss = true;
        this.rand = new Random();
        if (this.stage == 0) {
            int vector_size = mcep_vsize * 8 + 25 + 6 - 3 * (mcep_order + 1);
            this.C = new double[mcep_order + 1];
            this.CC = new double[mcep_order + 1];
            this.CINC = new double[mcep_order + 1];
            this.D1 = new double[vector_size];
            this.freqt_size = 0;
            this.spectrum2en_size = 0;
            this.postfilter_size = 0;
            this.lsp2lpc_size = 0;
            this.gc2gc_size = 0;
            vector_size = 21;
            this.pade = new double[vector_size];
            this.ppade = 15;
            this.pade[0] = 1.0;
            this.pade[1] = 1.0;
            this.pade[2] = 0.0;
            this.pade[3] = 1.0;
            this.pade[4] = 0.0;
            this.pade[5] = 0.0;
            this.pade[6] = 1.0;
            this.pade[7] = 0.0;
            this.pade[8] = 0.0;
            this.pade[9] = 0.0;
            this.pade[10] = 1.0;
            this.pade[11] = 0.4999273;
            this.pade[12] = 0.1067005;
            this.pade[13] = 0.01170221;
            this.pade[14] = 5.656279E-4;
            this.pade[15] = 1.0;
            this.pade[16] = 0.4999391;
            this.pade[17] = 0.1107098;
            this.pade[18] = 0.01369984;
            this.pade[19] = 9.564853E-4;
            this.pade[20] = 3.041721E-5;
            this.pt1 = 6;
            this.pt2 = 12 + 5 * (mcep_order + 2);
            this.pt3 = new int[6];
            for (int i = 5; i >= 1; --i) {
                this.pt3[i] = 12 + (i - 1) * (mcep_order + 2);
            }
        } else {
            int vector_size = (mcep_vsize + 1) * (this.stage + 3) - 3 * (mcep_order + 1);
            this.C = new double[mcep_order + 1];
            this.CC = new double[mcep_order + 1];
            this.CINC = new double[mcep_order + 1];
            this.D1 = new double[vector_size];
        }
        this.p1 = -1.0;
        this.pc = 0.0;
    }

    public AudioInputStream htsMLSAVocoder(HTSParameterGeneration pdf2par, HMMData htsData) throws Exception {
        int audioSize = this.computeAudioSize(pdf2par.getMcepPst(), htsData);
        HTSVocoderDataProducer producer = new HTSVocoderDataProducer(audioSize, pdf2par, htsData);
        producer.start();
        return new DDSAudioInputStream(producer, HTSVocoder.getHTSAudioFormat(htsData));
    }

    public static AudioFormat getHTSAudioFormat(HMMData htsData) {
        float sampleRate = htsData.getRate();
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        return af;
    }

    public double[] htsMLSAVocoder(HTSPStream lf0Pst, HTSPStream mcepPst, HTSPStream strPst, HTSPStream magPst, boolean[] voiced, HMMData htsData, HTSVocoderDataProducer audioProducer) throws Exception {
        int mcepframe;
        int i;
        double xp = 0.0;
        double xn = 0.0;
        double alpha = htsData.getAlpha();
        double beta = htsData.getBeta();
        double aa = 1.0 - alpha * alpha;
        double[] audio_double = null;
        double[] magPulse = null;
        boolean aperiodicFlag = false;
        boolean debug = false;
        DataOutputStream data_out = null;
        DataOutputStream data_out_mix = null;
        String excFile = "/project/mary/marcela/hmm-mag-experiment/gen-par/exc.bin";
        String mixExcFile = "/project/mary/marcela/hmm-mag-experiment/gen-par/exc-mix.bin";
        double[] mc = null;
        double[] hp = null;
        double[] hn = null;
        int m = mcepPst.getOrder();
        mc = new double[m];
        this.initVocoder(m - 1, mcepPst.getVsize() - 1, htsData);
        double[] pulse = new double[this.fprd];
        double[] noise = new double[this.fprd];
        double[] source = new double[this.fprd];
        double[] d = new double[m];
        if (this.lpcVocoder) {
            this.logger.debug("Using LPC vocoder");
            for (i = 0; i < m; ++i) {
                d[i] = 0.0;
            }
        }
        this.mixedExcitation = htsData.getUseMixExc();
        this.fourierMagnitudes = htsData.getUseFourierMag();
        if (this.mixedExcitation && htsData.getPdfStrStream() != null) {
            this.numM = htsData.getNumFilters();
            this.orderM = htsData.getOrderFilters();
            this.xpulseSignal = new double[this.orderM];
            this.xnoiseSignal = new double[this.orderM];
            for (i = 0; i < this.orderM; ++i) {
                this.xnoiseSignal[i] = 0.0;
                this.xpulseSignal[i] = 0.0;
            }
            this.h = htsData.getMixFilters();
            hp = new double[this.orderM];
            hn = new double[this.orderM];
            if (this.numM != strPst.getOrder()) {
                this.logger.debug("htsMLSAVocoder: error num mix-excitation filters =" + this.numM + " in configuration file is different from generated str order=" + strPst.getOrder());
                throw new Exception("htsMLSAVocoder: error num mix-excitation filters = " + this.numM + " in configuration file is different from generated str order=" + strPst.getOrder());
            }
            this.logger.debug("HMM speech generation with mixed-excitation.");
        } else {
            this.logger.debug("HMM speech generation without mixed-excitation.");
        }
        if (this.fourierMagnitudes && htsData.getPdfMagStream() != null) {
            this.logger.debug("Pulse generated with Fourier Magnitudes.");
        }
        if (beta != 0.0) {
            this.logger.debug("Postfiltering applied with beta=" + beta);
        } else {
            this.logger.debug("No postfiltering applied.");
        }
        if (debug) {
            data_out = new DataOutputStream(new FileOutputStream(excFile));
            data_out_mix = new DataOutputStream(new FileOutputStream(mixExcFile));
        }
        for (i = 0; i < this.C.length; ++i) {
            this.CINC[i] = 0.0;
            this.CC[i] = 0.0;
            this.C[i] = 0.0;
        }
        for (i = 0; i < this.D1.length; ++i) {
            this.D1[i] = 0.0;
        }
        double f0Std = htsData.getF0Std();
        double f0Shift = htsData.getF0Mean();
        double f0MeanOri = 0.0;
        int lf0frame = 0;
        for (mcepframe = 0; mcepframe < mcepPst.getT(); ++mcepframe) {
            if (!voiced[mcepframe]) continue;
            f0MeanOri += Math.exp(lf0Pst.getPar(lf0frame, 0));
            ++lf0frame;
        }
        f0MeanOri /= (double)lf0frame;
        boolean s = false;
        int s_double = 0;
        int audio_size = this.computeAudioSize(mcepPst, htsData);
        audio_double = new double[audio_size];
        int magSample = 1;
        int magPulseSize = 0;
        lf0frame = 0;
        for (mcepframe = 0; mcepframe < mcepPst.getT(); ++mcepframe) {
            double inc;
            int j;
            double f0;
            for (i = 0; i < m; ++i) {
                mc[i] = mcepPst.getPar(mcepframe, i);
            }
            if (voiced[mcepframe]) {
                f0 = f0Std * Math.exp(lf0Pst.getPar(lf0frame, 0)) + (1.0 - f0Std) * f0MeanOri + f0Shift;
                ++lf0frame;
                if (f0 < 0.0) {
                    f0 = 0.0;
                }
            } else {
                f0 = 0.0;
            }
            double str = 0.0;
            if (this.mixedExcitation) {
                for (j = 0; j < this.orderM; ++j) {
                    hn[j] = 0.0;
                    hp[j] = 0.0;
                    for (i = 0; i < this.numM; ++i) {
                        str = strPst.getPar(mcepframe, i);
                        int n = j;
                        hp[n] = hp[n] + str * this.h[i][j];
                        int n2 = j;
                        hn[n2] = hn[n2] + (1.0 - str) * this.h[i][j];
                    }
                }
            }
            if (f0 != 0.0) {
                f0 = this.rate / f0;
            }
            if (this.p1 < 0.0) {
                this.pc = this.p1 = f0;
                if (this.stage != 0) {
                    this.C[0] = this.use_log_gain ? -1.0E10 : 1.0E-10;
                    for (i = 0; i < m; ++i) {
                        this.C[i] = (double)i * Math.PI / (double)m;
                    }
                    this.lsp2mgc(this.C, this.C, m - 1, alpha);
                    this.mc2b(this.C, this.C, m - 1, alpha);
                    this.gnorm(this.C, this.C, m - 1, this.gamma);
                    i = 1;
                    while (i < m) {
                        int n = i++;
                        this.C[n] = this.C[n] * this.gamma;
                    }
                }
            }
            if (this.stage == 0) {
                this.postfilter_mgc(mc, m - 1, alpha, beta);
                this.mc2b(mc, this.CC, m - 1, alpha);
                for (i = 0; i < m; ++i) {
                    this.CINC[i] = (this.CC[i] - this.C[i]) * (double)this.iprd / (double)this.fprd;
                }
            } else {
                this.lsp2mgc(mc, this.CC, m - 1, alpha);
                this.mc2b(this.CC, this.CC, m - 1, alpha);
                this.gnorm(this.CC, this.CC, m - 1, this.gamma);
                i = 1;
                while (i < m) {
                    int n = i++;
                    this.CC[n] = this.CC[n] * this.gamma;
                }
                for (i = 0; i < m; ++i) {
                    this.CINC[i] = (this.CC[i] - this.C[i]) * (double)this.iprd / (double)this.fprd;
                }
            }
            if (this.p1 != 0.0 && f0 != 0.0) {
                inc = (f0 - this.p1) * (double)this.iprd / (double)this.fprd;
            } else {
                inc = 0.0;
                this.pc = f0;
                this.p1 = 0.0;
            }
            this.gauss = false;
            this.gauss = false;
            i = (this.iprd + 1) / 2;
            for (j = this.fprd - 1; j >= 0; --j) {
                int k;
                double x;
                if (this.p1 == 0.0) {
                    x = this.gauss ? this.rand.nextGaussian() : this.uniformRand();
                    if (this.mixedExcitation) {
                        xn = x;
                        xp = 0.0;
                    }
                } else {
                    double d2;
                    this.pc += 1.0;
                    if (d2 >= this.p1) {
                        if (this.fourierMagnitudes) {
                            magPulse = this.genPulseFromFourierMag(magPst, mcepframe, this.p1, aperiodicFlag);
                            magSample = 0;
                            magPulseSize = magPulse.length;
                            x = magPulse[magSample];
                            ++magSample;
                        } else {
                            x = Math.sqrt(this.p1);
                        }
                        this.pc -= this.p1;
                    } else if (this.fourierMagnitudes) {
                        x = magSample >= magPulseSize ? 0.0 : magPulse[magSample];
                        ++magSample;
                    } else {
                        x = 0.0;
                    }
                    if (this.mixedExcitation) {
                        xp = x;
                        xn = this.gauss ? this.rand.nextGaussian() : this.uniformRand();
                    }
                }
                if (this.mixedExcitation) {
                    double fxp = 0.0;
                    double fxn = 0.0;
                    for (k = this.orderM - 1; k > 0; --k) {
                        fxp += hp[k] * this.xpulseSignal[k];
                        fxn += hn[k] * this.xnoiseSignal[k];
                        this.xpulseSignal[k] = this.xpulseSignal[k - 1];
                        this.xnoiseSignal[k] = this.xnoiseSignal[k - 1];
                    }
                    this.xpulseSignal[0] = xp;
                    this.xnoiseSignal[0] = xn;
                    double mix = (fxp += hp[0] * xp) + (fxn += hn[0] * xn);
                    pulse[j] = fxp;
                    noise[j] = fxn;
                    source[j] = mix;
                    if (debug) {
                        data_out.writeFloat((float)x);
                        data_out_mix.writeFloat((float)mix);
                    }
                    x = mix;
                }
                if (this.lpcVocoder) {
                    x *= this.C[0];
                    for (k = m - 1; k > 1; --k) {
                        x -= this.C[k] * d[k];
                        d[k] = d[k - 1];
                    }
                    d[1] = x -= this.C[1] * d[1];
                } else if (this.stage == 0) {
                    if (x != 0.0) {
                        x *= Math.exp(this.C[0]);
                    }
                    x = this.mlsadf(x, this.C, m, alpha, aa, this.D1);
                } else {
                    x *= this.C[0];
                    x = this.mglsadf(x, this.C, m - 1, alpha, this.stage, this.D1);
                }
                audio_double[s_double] = x;
                if (audioProducer != null) {
                    audioProducer.putOneDataPoint(x);
                }
                ++s_double;
                if (--i != 0) continue;
                this.p1 += inc;
                for (k = 0; k < m; ++k) {
                    int n = k;
                    this.C[n] = this.C[n] + this.CINC[k];
                }
                i = this.iprd;
            }
            this.p1 = f0;
            for (i = 0; i < m; ++i) {
                this.C[i] = this.CC[i];
            }
        }
        if (debug) {
            data_out.close();
            data_out_mix.close();
        }
        this.logger.debug("Finish processing " + mcepframe + " mcep frames.");
        return audio_double;
    }

    private int computeAudioSize(HTSPStream mcepPst, HMMData htsData) {
        return mcepPst.getT() * htsData.getFperiod();
    }

    private void printVector(String val, int m, double[] vec) {
        System.out.println(val);
        for (int i = 0; i < m; ++i) {
            System.out.println("v[" + i + "]=" + vec[i]);
        }
    }

    private double mlsafir(double x, double[] b, int m, double a, double aa, double[] d, int _pt3) {
        int i;
        double y = 0.0;
        d[_pt3 + 0] = x;
        d[_pt3 + 1] = aa * d[_pt3 + 0] + a * d[_pt3 + 1];
        for (i = 2; i <= m; ++i) {
            int n = _pt3 + i;
            d[n] = d[n] + a * (d[_pt3 + i + 1] - d[_pt3 + i - 1]);
        }
        for (i = 2; i <= m; ++i) {
            y += d[_pt3 + i] * b[i];
        }
        for (i = m + 1; i > 1; --i) {
            d[_pt3 + i] = d[_pt3 + i - 1];
        }
        return y;
    }

    private double mlsadf1(double x, double[] b, int m, double a, double aa, double[] d) {
        double out = 0.0;
        for (int i = 5; i >= 1; --i) {
            int pt1_plus_i = this.pt1 + i;
            d[i] = aa * d[pt1_plus_i - 1] + a * d[i];
            d[pt1_plus_i] = d[i] * b[1];
            double v = d[pt1_plus_i] * this.pade[this.ppade + i];
            x = i == 1 || i == 3 || i == 5 ? (x += v) : (x += -v);
            out += v;
        }
        d[this.pt1] = x;
        return out += x;
    }

    private double mlsadf2(double x, double[] b, int m, double a, double aa, double[] d) {
        double out = 0.0;
        for (int i = 5; i >= 1; --i) {
            int pt2_plus_i = this.pt2 + i;
            d[pt2_plus_i] = this.mlsafir(d[pt2_plus_i - 1], b, m, a, aa, d, this.pt3[i]);
            double v = d[pt2_plus_i] * this.pade[this.ppade + i];
            x = i == 1 || i == 3 || i == 5 ? (x += v) : (x += -v);
            out += v;
        }
        d[this.pt2] = x;
        return out += x;
    }

    private double mlsadf(double x, double[] b, int m, double a, double aa, double[] d) {
        x = this.mlsadf1(x, b, m, a, aa, d);
        x = this.mlsadf2(x, b, m - 1, a, aa, d);
        return x;
    }

    private double uniformRand() {
        double x = this.rand.nextDouble();
        if (x >= 0.5) {
            return 1.0;
        }
        return -1.0;
    }

    private void mc2b(double[] mc, double[] b, int m, double a) {
        b[m] = mc[m];
        --m;
        while (m >= 0) {
            b[m] = mc[m] - a * b[m + 1];
            --m;
        }
    }

    private void b2mc(double[] b, double[] mc, int m, double a) {
        double d = mc[m] = b[m];
        for (int i = m--; i >= 0; --i) {
            double o = b[i] + a * d;
            d = b[i];
            mc[i] = o;
        }
    }

    private void freqt(double[] c1, int m1, double[] c2, int m2, double a) {
        int i;
        double b = 1.0 - a * a;
        if (m2 > this.freqt_size) {
            this.freqt_buff = new double[m2 + m2 + 2];
            this.freqt_size = m2;
        }
        int g = this.freqt_size + 1;
        for (i = 0; i < m2 + 1; ++i) {
            this.freqt_buff[g + i] = 0.0;
        }
        for (i = -m1; i <= 0; ++i) {
            if (0 <= m2) {
                this.freqt_buff[0] = this.freqt_buff[g + 0];
                this.freqt_buff[g + 0] = c1[-i] + a * this.freqt_buff[0];
            }
            if (1 <= m2) {
                this.freqt_buff[1] = this.freqt_buff[g + 1];
                this.freqt_buff[g + 1] = b * this.freqt_buff[0] + a * this.freqt_buff[1];
            }
            for (int j = 2; j <= m2; ++j) {
                this.freqt_buff[j] = this.freqt_buff[g + j];
                this.freqt_buff[g + j] = this.freqt_buff[j - 1] + a * (this.freqt_buff[j] - this.freqt_buff[g + j - 1]);
            }
        }
        for (i = 0; i < m2 + 1; ++i) {
            c2[i] = this.freqt_buff[g + i];
        }
    }

    private void c2ir(double[] c, int nc, double[] hh, int leng) {
        hh[0] = Math.exp(c[0]);
        for (int n = 1; n < leng; ++n) {
            double d = 0.0;
            int upl = n >= nc ? nc - 1 : n;
            for (int k = 1; k <= upl; ++k) {
                d += (double)k * c[k] * hh[n - k];
            }
            hh[n] = d / (double)n;
        }
    }

    private double b2en(double[] b, int m, double a) {
        double en = 0.0;
        int arrayLength = m + 1 + 192;
        if (this.spectrum2en_size < m) {
            this.spectrum2en_buff = new double[arrayLength];
            this.spectrum2en_size = m;
        }
        double[] cep = new double[arrayLength];
        double[] ir = new double[arrayLength];
        this.b2mc(b, this.spectrum2en_buff, m, a);
        this.freqt(this.spectrum2en_buff, m, cep, 95, -a);
        this.c2ir(cep, 96, ir, 96);
        en = 0.0;
        for (int i = 0; i < 96; ++i) {
            en += ir[i] * ir[i];
        }
        return en;
    }

    private void ignorm(double[] c1, double[] c2, int m, double ng) {
        if (ng != 0.0) {
            double k = Math.pow(c1[0], ng);
            for (int i = m; i >= 1; --i) {
                c2[i] = k * c1[i];
            }
            c2[0] = (k - 1.0) / ng;
        } else {
            for (int i = 1; i < m; ++i) {
                c2[i] = c1[i];
            }
            c2[0] = Math.log(c1[0]);
        }
    }

    private void gnorm(double[] c1, double[] c2, int m, double g) {
        if (g != 0.0) {
            double k = 1.0 + g * c1[0];
            while (m >= 1) {
                c2[m] = c1[m] / k;
                --m;
            }
            c2[0] = Math.pow(k, 1.0 / g);
        } else {
            for (int i = 1; i <= m; ++i) {
                c2[i] = c1[i];
            }
            c2[0] = Math.exp(c1[0]);
        }
    }

    private void lsp2lpc(double[] lsp, double[] a, int m) {
        int i;
        int mh1;
        int mh2;
        boolean flag_odd = false;
        if (m % 2 == 0) {
            mh1 = mh2 = m / 2;
        } else {
            mh1 = (m + 1) / 2;
            mh2 = (m - 1) / 2;
            flag_odd = true;
        }
        if (m > this.lsp2lpc_size) {
            this.lsp2lpc_buff = new double[5 * m + 6];
            this.lsp2lpc_size = m;
        }
        int p = m;
        int q = p + mh1;
        int a0 = q + mh2;
        int a1 = a0 + (mh1 + 1);
        int a2 = a1 + (mh1 + 1);
        int b0 = a2 + (mh1 + 1);
        int b1 = b0 + (mh2 + 1);
        int b2 = b1 + (mh2 + 1);
        for (i = 0; i < m; ++i) {
            this.lsp2lpc_buff[i] = lsp[i + 1];
        }
        for (i = 0; i < mh1 + 1; ++i) {
            this.lsp2lpc_buff[a0 + i] = 0.0;
        }
        for (i = 0; i < mh1 + 1; ++i) {
            this.lsp2lpc_buff[a1 + i] = 0.0;
        }
        for (i = 0; i < mh1 + 1; ++i) {
            this.lsp2lpc_buff[a2 + i] = 0.0;
        }
        for (i = 0; i < mh2 + 1; ++i) {
            this.lsp2lpc_buff[b0 + i] = 0.0;
        }
        for (i = 0; i < mh2 + 1; ++i) {
            this.lsp2lpc_buff[b1 + i] = 0.0;
        }
        for (i = 0; i < mh2 + 1; ++i) {
            this.lsp2lpc_buff[b2 + i] = 0.0;
        }
        int k = 0;
        i = 0;
        while (i < mh1) {
            this.lsp2lpc_buff[p + i] = -2.0 * Math.cos(this.lsp2lpc_buff[k]);
            ++i;
            k += 2;
        }
        k = 0;
        i = 0;
        while (i < mh2) {
            this.lsp2lpc_buff[q + i] = -2.0 * Math.cos(this.lsp2lpc_buff[k + 1]);
            ++i;
            k += 2;
        }
        double xx = 1.0;
        double xff = 0.0;
        double xf = 0.0;
        for (k = 0; k <= m; ++k) {
            if (flag_odd) {
                this.lsp2lpc_buff[a0 + 0] = xx;
                this.lsp2lpc_buff[b0 + 0] = xx - xff;
                xff = xf;
                xf = xx;
            } else {
                this.lsp2lpc_buff[a0 + 0] = xx + xf;
                this.lsp2lpc_buff[b0 + 0] = xx - xf;
                xf = xx;
            }
            for (i = 0; i < mh1; ++i) {
                this.lsp2lpc_buff[a0 + i + 1] = this.lsp2lpc_buff[a0 + i] + this.lsp2lpc_buff[p + i] * this.lsp2lpc_buff[a1 + i] + this.lsp2lpc_buff[a2 + i];
                this.lsp2lpc_buff[a2 + i] = this.lsp2lpc_buff[a1 + i];
                this.lsp2lpc_buff[a1 + i] = this.lsp2lpc_buff[a0 + i];
            }
            for (i = 0; i < mh2; ++i) {
                this.lsp2lpc_buff[b0 + i + 1] = this.lsp2lpc_buff[b0 + i] + this.lsp2lpc_buff[q + i] * this.lsp2lpc_buff[b1 + i] + this.lsp2lpc_buff[b2 + i];
                this.lsp2lpc_buff[b2 + i] = this.lsp2lpc_buff[b1 + i];
                this.lsp2lpc_buff[b1 + i] = this.lsp2lpc_buff[b0 + i];
            }
            if (k != 0) {
                a[k - 1] = -0.5 * (this.lsp2lpc_buff[a0 + mh1] + this.lsp2lpc_buff[b0 + mh2]);
            }
            xx = 0.0;
        }
        for (i = m - 1; i >= 0; --i) {
            a[i + 1] = -a[i];
        }
        a[0] = 1.0;
    }

    private void gc2gc(double[] c1, int m1, double g1, double[] c2, int m2, double g2) {
        int i;
        if (m1 > this.gc2gc_size) {
            this.gc2gc_buff = new double[m1 + 1];
            this.gc2gc_size = m1;
        }
        for (i = 0; i < m1 + 1; ++i) {
            this.gc2gc_buff[i] = c1[i];
        }
        c2[0] = this.gc2gc_buff[0];
        for (i = 1; i <= m2; ++i) {
            double ss2 = 0.0;
            double ss1 = 0.0;
            int min = m1 < i ? m1 : i - 1;
            for (int k = 1; k <= min; ++k) {
                int mk = i - k;
                double cc = this.gc2gc_buff[k] * c2[mk];
                ss2 += (double)k * cc;
                ss1 += (double)mk * cc;
            }
            c2[i] = i <= m1 ? this.gc2gc_buff[i] + (g2 * ss2 - g1 * ss1) / (double)i : (g2 * ss2 - g1 * ss1) / (double)i;
        }
    }

    private void mgc2mgc(double[] c1, int m1, double a1, double g1, double[] c2, int m2, double a2, double g2) {
        if (a1 == a2) {
            this.gnorm(c1, c1, m1, g1);
            this.gc2gc(c1, m1, g1, c2, m2, g2);
            this.ignorm(c2, c2, m2, g2);
        } else {
            double a = (a2 - a1) / (1.0 - a1 * a2);
            this.freqt(c1, m1, c2, m2, a);
            this.gnorm(c2, c2, m2, g1);
            this.gc2gc(c2, m2, g1, c2, m2, g2);
            this.ignorm(c2, c2, m2, g2);
        }
    }

    private void lsp2mgc(double[] lsp, double[] mgc, int m, double alpha) {
        this.lsp2lpc(lsp, mgc, m);
        mgc[0] = this.use_log_gain ? Math.exp(lsp[0]) : lsp[0];
        this.ignorm(mgc, mgc, m, this.gamma);
        int i = m;
        while (i >= 1) {
            int n = i--;
            mgc[n] = mgc[n] * (double)(-this.stage);
        }
        this.mgc2mgc(mgc, m, alpha, this.gamma, mgc, m, alpha, this.gamma);
    }

    private double mglsadf(double x, double[] b, int m, double a, int n, double[] d) {
        for (int i = 0; i < n; ++i) {
            x = this.mglsadff(x, b, m, a, d, i * (m + 1));
        }
        return x;
    }

    private double mglsadff(double x, double[] b, int m, double a, double[] d, int d_offset) {
        int i;
        double y = d[d_offset + 0] * b[1];
        for (i = 1; i < m; ++i) {
            int n = d_offset + i;
            d[n] = d[n] + a * (d[d_offset + i + 1] - d[d_offset + i - 1]);
            y += d[d_offset + i] * b[i + 1];
        }
        x -= y;
        for (i = m; i > 0; --i) {
            d[d_offset + i] = d[d_offset + i - 1];
        }
        d[d_offset + 0] = a * d[d_offset + 0] + (1.0 - a * a) * x;
        return x;
    }

    private void postfilter_mgc(double[] mgc, int m, double alpha, double beta) {
        if (beta > 0.0 && m > 1) {
            if (this.postfilter_size < m) {
                this.postfilter_buff = new double[m + 1];
                this.postfilter_size = m;
            }
            this.mc2b(mgc, this.postfilter_buff, m, alpha);
            double e1 = this.b2en(this.postfilter_buff, m, alpha);
            this.postfilter_buff[1] = this.postfilter_buff[1] - beta * alpha * mgc[2];
            int k = 2;
            while (k < m) {
                int n = k++;
                this.postfilter_buff[n] = this.postfilter_buff[n] * (1.0 + beta);
            }
            double e2 = this.b2en(this.postfilter_buff, m, alpha);
            this.postfilter_buff[0] = this.postfilter_buff[0] + Math.log(e1 / e2) / 2.0;
            this.b2mc(this.postfilter_buff, mgc, m, alpha);
        }
    }

    private double[] genPulseFromFourierMag(HTSPStream mag, int n, double f0, boolean aperiodicFlag) {
        int i;
        int numHarm = mag.getOrder();
        int currentF0 = (int)Math.round(f0);
        double[] pulse = null;
        double[] real = null;
        double[] imag = null;
        int T = currentF0 < 512 ? 512 : 1024;
        int T2 = 2 * T;
        pulse = new double[T];
        real = new double[T2];
        imag = new double[T2];
        real[T] = 0.0;
        real[0] = 0.0;
        for (i = 1; i <= numHarm; ++i) {
            double d = mag.getPar(n, i - 1);
            real[T2 - i] = d;
            real[T + i] = d;
            real[T - i] = d;
            real[i] = d;
            imag[T2 - i] = 0.0;
            imag[T + i] = 0.0;
            imag[T - i] = 0.0;
            imag[i] = 0.0;
        }
        for (i = numHarm + 1; i < T - numHarm; ++i) {
            real[T2 - i] = 1.0;
            real[T + i] = 1.0;
            real[T - i] = 1.0;
            real[i] = 1.0;
            imag[T2 - i] = 0.0;
            imag[T + i] = 0.0;
            imag[T - i] = 0.0;
            imag[i] = 0.0;
        }
        FFT.transform(real, imag, true);
        double sqrt_f0 = Math.sqrt(currentF0);
        for (i = 0; i < T; ++i) {
            pulse[i] = real[this.modShift(i - numHarm, T)] * sqrt_f0;
        }
        return pulse;
    }

    private double[] genPulseFromFourierMagRadix(HTSPStream mag, int n, double f0, boolean aperiodicFlag) {
        int i;
        int numHarm = mag.getOrder();
        int currentF0 = (int)Math.round(f0);
        double[] pulse = null;
        Object p = null;
        int T = currentF0;
        if (aperiodicFlag) {
            double erratic = this.uniformRand();
            double jitter = 0.25;
            T = (int)Math.round((double)T * (1.0 + jitter * erratic));
            System.out.print("  F0-jitter=" + T + "  jitter*erratic=" + jitter * erratic);
        }
        pulse = new double[T];
        ComplexArray magPulse = new ComplexArray(T * 2);
        pulse[0] = 0.0;
        for (i = 1; i <= numHarm; ++i) {
            pulse[i] = mag.getPar(n, i - 1);
            pulse[T - i] = pulse[i];
        }
        for (i = numHarm + 1; i < T - numHarm; ++i) {
            pulse[i] = 1.0;
        }
        for (i = 0; i < T; ++i) {
            double d = pulse[i];
            magPulse.real[i + T] = d;
            magPulse.real[i] = d;
        }
        ComplexArray ifftPulse = FFTMixedRadix.ifft(magPulse);
        for (i = 0; i < T; ++i) {
            pulse[i] = ifftPulse.real[2 * i];
        }
        this.circularShift(pulse, T, numHarm);
        double sqrt_f0 = Math.sqrt(currentF0);
        for (i = 0; i < T; ++i) {
            pulse[i] = pulse[i] * sqrt_f0;
        }
        return pulse;
    }

    private void circularShift(double[] y, int T, int n) {
        int i;
        double[] x = new double[T];
        for (i = 0; i < T; ++i) {
            x[i] = y[this.modShift(i - n, T)];
        }
        for (i = 0; i < T; ++i) {
            y[i] = x[i];
        }
    }

    private int modShift(int n, int N) {
        if (n < 0) {
            while (n < 0) {
                n += N;
            }
        } else {
            while (n >= N) {
                n -= N;
            }
        }
        return n;
    }

    public double[] htsMLSAVocoder_residual(HMMData htsData, HTSPStream mcepPst, String resFile) throws Exception {
        int mcepframe;
        int i;
        double alpha = htsData.getAlpha();
        double beta = htsData.getBeta();
        double aa = 1.0 - alpha * alpha;
        double[] audio_double = null;
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(resFile));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] res = signal.getAllData();
        inputAudio.close();
        double[] mc = null;
        int m = mcepPst.getOrder();
        mc = new double[m];
        this.initVocoder(m - 1, mcepPst.getVsize() - 1, htsData);
        double[] d = new double[m];
        if (this.lpcVocoder) {
            this.logger.debug("Using LPC vocoder");
            for (i = 0; i < m; ++i) {
                d[i] = 0.0;
            }
        }
        if (beta != 0.0) {
            this.logger.debug("Postfiltering applied with beta=" + beta);
        } else {
            this.logger.debug("No postfiltering applied.");
        }
        for (i = 0; i < this.C.length; ++i) {
            this.CINC[i] = 0.0;
            this.CC[i] = 0.0;
            this.C[i] = 0.0;
        }
        for (i = 0; i < this.D1.length; ++i) {
            this.D1[i] = 0.0;
        }
        int s = 0;
        int s_double = 0;
        int audio_size = this.computeAudioSize(mcepPst, htsData);
        audio_double = new double[audio_size];
        this.p1 = -1.0;
        int sample = 0;
        boolean lf0frame = false;
        for (mcepframe = 0; mcepframe < mcepPst.getT(); ++mcepframe) {
            for (i = 0; i < m; ++i) {
                mc[i] = mcepPst.getPar(mcepframe, i);
            }
            if (this.p1 < 0.0) {
                this.p1 = 1.0;
                if (this.stage != 0) {
                    this.C[0] = this.use_log_gain ? -1.0E10 : 1.0E-10;
                    for (i = 0; i < m; ++i) {
                        this.C[i] = (double)i * Math.PI / (double)m;
                    }
                    this.lsp2mgc(this.C, this.C, m - 1, alpha);
                    this.mc2b(this.C, this.C, m - 1, alpha);
                    this.gnorm(this.C, this.C, m - 1, this.gamma);
                    i = 1;
                    while (i < m) {
                        int n = i++;
                        this.C[n] = this.C[n] * this.gamma;
                    }
                }
            }
            if (this.stage == 0) {
                this.postfilter_mgc(mc, m - 1, alpha, beta);
                this.mc2b(mc, this.CC, m - 1, alpha);
                for (i = 0; i < m; ++i) {
                    this.CINC[i] = (this.CC[i] - this.C[i]) * (double)this.iprd / (double)this.fprd;
                }
            } else {
                this.lsp2mgc(mc, this.CC, m - 1, alpha);
                this.mc2b(this.CC, this.CC, m - 1, alpha);
                this.gnorm(this.CC, this.CC, m - 1, this.gamma);
                i = 1;
                while (i < m) {
                    int n = i++;
                    this.CC[n] = this.CC[n] * this.gamma;
                }
                for (i = 0; i < m; ++i) {
                    this.CINC[i] = (this.CC[i] - this.C[i]) * (double)this.iprd / (double)this.fprd;
                }
            }
            i = (this.iprd + 1) / 2;
            for (int j = this.fprd - 1; j >= 0; --j) {
                int k;
                double x = res[sample];
                if (this.lpcVocoder) {
                    for (k = m - 1; k > 1; --k) {
                        x -= this.C[k] * d[k];
                        d[k] = d[k - 1];
                    }
                    d[1] = x -= this.C[1] * d[1];
                } else if (this.stage == 0) {
                    if (x != 0.0) {
                        x *= Math.exp(this.C[0]);
                    }
                    x = this.mlsadf(x, this.C, m, alpha, aa, this.D1);
                } else {
                    x *= this.C[0];
                    x = this.mglsadf(x, this.C, m - 1, alpha, this.stage, this.D1);
                }
                audio_double[s_double] = x;
                ++s_double;
                if (--i == 0) {
                    for (k = 0; k < m; ++k) {
                        int n = k;
                        this.C[n] = this.C[n] + this.CINC[k];
                    }
                    i = this.iprd;
                }
                ++sample;
            }
            for (i = 0; i < m; ++i) {
                this.C[i] = this.CC[i];
            }
        }
        this.logger.debug("Finish processing " + mcepframe + " mcep frames." + "  Num samples in bytes s=" + s);
        return audio_double;
    }

    public static void main1(String[] args) throws IOException, InterruptedException, Exception {
        HMMData htsData = new HMMData();
        boolean[] voiced = null;
        String MaryBase = "/project/mary/marcela/openmary/";
        String outDir = "/project/mary/marcela/openmary/tmp/";
        String outFile = outDir + "tmp.wav";
        String voiceName = "hsmm-ot";
        String voiceConfig = "tr-hsmm-ot.config";
        String voiceExample = "ot0010";
        String hmmTrainDir = "/project/mary/marcela/HMM-voices/turkish/";
        htsData.initHMMData(voiceName, MaryBase, voiceConfig);
        htsData.setUseMixExc(true);
        htsData.setUseFourierMag(true);
        String lf0File = hmmTrainDir + "data/lf0/" + voiceExample + ".lf0";
        String mcepFile = hmmTrainDir + "data/mgc/" + voiceExample + ".mgc";
        String strFile = hmmTrainDir + "data/str/" + voiceExample + ".str";
        String magFile = hmmTrainDir + "data/mag/" + voiceExample + ".mag";
        int mcepVsize = htsData.getCartTreeSet().getMcepVsize();
        int strVsize = htsData.getCartTreeSet().getStrVsize();
        int lf0Vsize = htsData.getCartTreeSet().getLf0Stream();
        int magVsize = htsData.getCartTreeSet().getMagVsize();
        int totalFrame = 0;
        int lf0VoicedFrame = 0;
        LEDataInputStream lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
        try {
            while (true) {
                float fval = lf0Data.readFloat();
                ++totalFrame;
                if (!(fval > 0.0f)) continue;
                ++lf0VoicedFrame;
            }
        }
        catch (EOFException e) {
            int j;
            int i;
            lf0Data.close();
            System.out.println("Total number of Frames = " + (totalFrame -= 2));
            voiced = new boolean[totalFrame];
            HTSPStream lf0Pst = new HTSPStream(lf0Vsize, totalFrame, 1, 0);
            HTSPStream mcepPst = new HTSPStream(mcepVsize, totalFrame, 2, 0);
            HTSPStream strPst = new HTSPStream(strVsize, totalFrame, 3, 0);
            HTSPStream magPst = new HTSPStream(magVsize, totalFrame, 4, 0);
            lf0VoicedFrame = 0;
            lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
            for (i = 0; i < totalFrame; ++i) {
                float fval = lf0Data.readFloat();
                if (fval < 0.0f) {
                    voiced[i] = false;
                    continue;
                }
                voiced[i] = true;
                lf0Pst.setPar(lf0VoicedFrame, 0, fval);
                ++lf0VoicedFrame;
            }
            lf0Data.close();
            LEDataInputStream mcepData = new LEDataInputStream(new BufferedInputStream(new FileInputStream(mcepFile)));
            for (i = 0; i < totalFrame; ++i) {
                for (j = 0; j < mcepPst.getOrder(); ++j) {
                    mcepPst.setPar(i, j, mcepData.readFloat());
                }
            }
            mcepData.close();
            LEDataInputStream strData = new LEDataInputStream(new BufferedInputStream(new FileInputStream(strFile)));
            for (i = 0; i < totalFrame; ++i) {
                for (j = 0; j < strPst.getOrder(); ++j) {
                    strPst.setPar(i, j, strData.readFloat());
                }
            }
            strData.close();
            LEDataInputStream magData = new LEDataInputStream(new BufferedInputStream(new FileInputStream(magFile)));
            for (i = 0; i < totalFrame; ++i) {
                for (j = 0; j < magPst.getOrder(); ++j) {
                    magPst.setPar(i, j, magData.readFloat());
                }
            }
            magData.close();
            AudioFormat af = HTSVocoder.getHTSAudioFormat(htsData);
            double[] audio_double = null;
            HTSVocoder par2speech = new HTSVocoder();
            audio_double = par2speech.htsMLSAVocoder(lf0Pst, mcepPst, strPst, magPst, voiced, htsData, null);
            long lengthInSamples = audio_double.length * 2 / (af.getSampleSizeInBits() / 8);
            par2speech.logger.debug("length in samples=" + lengthInSamples);
            double MaxSample = MathUtils.getAbsMax(audio_double);
            for (i = 0; i < audio_double.length; ++i) {
                audio_double[i] = 0.3 * (audio_double[i] / MaxSample);
            }
            DDSAudioInputStream oais = new DDSAudioInputStream(new BufferedDoubleDataSource(audio_double), af);
            File fileOut = new File(outFile);
            System.out.println("saving to file: " + outFile);
            if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, oais)) {
                AudioSystem.write((AudioInputStream)oais, AudioFileFormat.Type.WAVE, fileOut);
            }
            System.out.println("Calling audioplayer:");
            AudioPlayer player = new AudioPlayer(fileOut);
            player.start();
            player.join();
            System.out.println("audioplayer finished...");
            return;
        }
    }

    public void htsMLSAVocoderCommand(String[] args) throws IOException, InterruptedException, Exception {
        int j;
        float fval;
        int i;
        long lengthMag;
        long lengthStr;
        HMMData htsData = new HMMData();
        HTSPStream strPst = null;
        HTSPStream magPst = null;
        boolean[] voiced = null;
        String strFile = "";
        String magFile = "";
        int strVsize = 0;
        int magVsize = 0;
        float f0LoudFemale = 0.01313791f;
        float[] strLoudFemale = new float[]{-0.002995137f, -0.042511884f, 0.072285675f, 0.12703018f, 0.00660317f};
        float[] magLoudFemale = new float[]{0.041733656f, 2.531457E-4f, -0.04368399f, -0.033519227f, -0.021750178f, -0.016627293f, -0.042482533f, -0.046011977f, -0.03071149f, -0.03273694f};
        float[] mcepLoudFemale = new float[]{-0.24540184f, -0.06282596f, -0.3609731f, 0.117120504f, 0.9172233f, 0.13892077f, 0.33855328f, -0.00485714f, 0.285192f, -0.35829273f, -0.06290734f, -0.008040502f, 0.029470561f, -0.48508f, -0.006727651f, -1.3138696f, -0.35379764f, 0.79709774f, -0.1646146f, -0.3111739f, -0.20513453f, -0.478117f, -0.31134018f, -1.4858553f, -0.045632627f};
        float f0SoftFemale = 0.3107256f;
        float[] strSoftFemale = new float[]{0.22054622f, 0.11091616f, 0.06378487f, 0.02110654f, -0.05118725f};
        float[] magSoftFemale = new float[]{0.5747024f, 0.3248238f, 0.2356782f, 0.2441387f, 0.2702851f, 0.2895966f, 0.2437654f, 0.2959747f, 0.2910529f, 0.2508167f};
        float[] mcepSoftFemale = new float[]{-0.10331817f, 0.31569844f, 0.17000097f, 0.22358972f, 0.26213965f, -0.06264676f, -4.9981604f, 0.008026212f, 1.7427409f, 1.9907197f, 0.54817754f, 0.99909383f, 0.26286837f, 1.7550194f, 0.3300586f, -5.2413054f, -0.021005178f, -5.8909426f, 0.3443851f, 0.24217945f, 0.20093668f, -1.6306833f, 0.1106742f, -53.525043f, -0.22368276f};
        float f0LoudMale = -0.08453168f;
        float[] strLoudMale = new float[]{0.070929f, 0.4114929f, 0.24479926f, 0.01326785f, -0.01517731f};
        float[] magLoudMale = new float[]{-0.2192362f, -0.1103112f, -0.02786084f, -0.10640244f, -0.12020442f, -0.08508762f, -0.08171423f, -0.08000552f, -0.07291968f, -0.09478534f};
        float[] mcepLoudMale = new float[]{0.15335238f, 0.30880293f, -0.22922052f, -0.01116095f, 1.0408835f, -0.3169363f, -19.365107f, -0.12210441f, 0.81743413f, -0.19799408f, 0.44572112f, -0.24845725f, -1.395454f, -0.8878849f, 8.830064f, -1.2662388f, 0.524281f, -1.026157f, -0.28092042f, -0.82543015f, 0.33081815f, 0.39498875f, 0.20100945f, 0.6089079f, -0.37892216f};
        float f0SoftMale = 0.05088677f;
        float[] strSoftMale = new float[]{0.07595702f, 0.02348965f, -0.02038628f, -0.0857297f, -0.06090386f};
        float[] magSoftMale = new float[]{0.08869109f, 0.05517088f, 0.08902098f, 0.09263865f, 0.04866824f, 0.04554406f, 0.04937004f, 0.05082076f, 0.04988959f, 0.0345944f};
        float[] mcepSoftMale = new float[]{0.09812939f, 0.12468682f, 0.195709f, -0.007066379f, -1.7956206f, 0.08998292f, 15.371712f, -0.05102383f, -0.21352194f, 0.009725292f, 0.36148873f, 0.118609995f, 1.7941431f, 0.100130945f, 0.005999542f, -0.5931289f, -0.1653853f, 0.10170568f, 0.17553416f, 0.049246304f, 0.009530379f, -0.27255705f, -0.043030772f, 0.15869488f, 0.09910797f};
        float f0Trans = 0.0f;
        float[] strTrans = null;
        float[] magTrans = null;
        float[] mcepTrans = null;
        int ind = 0;
        htsData.setStage(Integer.parseInt(args[ind++]));
        htsData.setAlpha(Float.parseFloat(args[ind++]));
        if (args[ind++].contentEquals("1")) {
            htsData.setUseLogGain(true);
        } else {
            htsData.setUseLogGain(false);
        }
        htsData.setBeta(Float.parseFloat(args[ind++]));
        htsData.setRate(Integer.parseInt(args[ind++]));
        htsData.setFperiod(Integer.parseInt(args[ind++]));
        String mcepFile = args[ind++];
        int mcepVsize = Integer.parseInt(args[ind++]);
        String lf0File = args[ind++];
        int lf0Vsize = Integer.parseInt(args[ind++]);
        String outFile = args[ind++];
        if (args.length > ind + 1) {
            htsData.setUseMixExc(true);
            strFile = args[ind++];
            strVsize = Integer.parseInt(args[ind++]);
            FileInputStream mixedFiltersStream = new FileInputStream(args[ind++]);
            htsData.setNumFilters(Integer.parseInt(args[ind++]));
            htsData.readMixedExcitationFilters(mixedFiltersStream);
            htsData.setPdfStrStream(null);
        } else {
            htsData.setUseMixExc(false);
        }
        if (args.length > ind + 1) {
            htsData.setUseFourierMag(true);
            magFile = args[ind++];
            magVsize = Integer.parseInt(args[ind++]);
            htsData.setPdfMagStream(null);
        } else {
            htsData.setUseFourierMag(false);
        }
        boolean play = Boolean.parseBoolean(args[ind++]);
        boolean trans = true;
        if (args[ind].contentEquals("loud")) {
            f0Trans = f0LoudFemale;
            strTrans = strLoudFemale;
            magTrans = magLoudFemale;
            mcepTrans = mcepLoudFemale;
            System.out.println("Generating loud voice");
        } else if (args[ind].contentEquals("soft")) {
            f0Trans = f0SoftFemale;
            strTrans = strSoftFemale;
            magTrans = magSoftFemale;
            mcepTrans = mcepSoftFemale;
            System.out.println("Generating soft voice");
        } else {
            trans = false;
            System.out.println("Generating modal voice");
        }
        htsData.setF0Std(1.0);
        htsData.setF0Mean(0.0);
        int totalFrame = 0;
        int lf0VoicedFrame = 0;
        LEDataInputStream lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
        File lf0 = new File(lf0File);
        long lengthLf0 = lf0.length();
        lengthLf0 /= (long)(lf0Vsize / 3 * 4);
        File mcep = new File(mcepFile);
        long lengthMcep = mcep.length();
        lengthMcep /= (long)(mcepVsize / 3 * 4);
        int numSize = 2;
        if (htsData.getUseMixExc()) {
            File str = new File(strFile);
            lengthStr = str.length();
            lengthStr /= (long)(strVsize / 3 * 4);
            ++numSize;
        } else {
            lengthStr = 0L;
        }
        if (htsData.getUseFourierMag()) {
            File mag = new File(magFile);
            lengthMag = mag.length();
            lengthMag /= (long)(magVsize / 3 * 4);
            ++numSize;
        } else {
            lengthMag = 0L;
        }
        float[] sizes = new float[numSize];
        int n = 0;
        sizes[n++] = lengthMcep;
        sizes[n++] = lengthLf0;
        if (lengthStr > 0L) {
            sizes[n++] = lengthStr;
        }
        if (lengthMag > 0L) {
            sizes[n++] = lengthMag;
        }
        totalFrame = (int)MathUtils.getMin(sizes);
        System.out.println("Total number of Frames = " + totalFrame);
        voiced = new boolean[totalFrame];
        HTSPStream lf0Pst = new HTSPStream(lf0Vsize, totalFrame, 1, 0);
        HTSPStream mcepPst = new HTSPStream(mcepVsize, totalFrame, 2, 0);
        lf0VoicedFrame = 0;
        lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
        for (i = 0; i < totalFrame; ++i) {
            fval = lf0Data.readFloat();
            if (fval < 0.0f) {
                voiced[i] = false;
                continue;
            }
            voiced[i] = true;
            if (trans) {
                fval = (float)Math.exp(fval);
                fval += fval * f0Trans;
                fval = (float)Math.log(fval);
            }
            lf0Pst.setPar(lf0VoicedFrame, 0, fval);
            ++lf0VoicedFrame;
        }
        lf0Data.close();
        LEDataInputStream mcepData = new LEDataInputStream(new BufferedInputStream(new FileInputStream(mcepFile)));
        for (i = 0; i < totalFrame; ++i) {
            for (j = 0; j < mcepPst.getOrder(); ++j) {
                fval = mcepData.readFloat();
                if (trans & j < 4) {
                    fval += fval * mcepTrans[j];
                }
                mcepPst.setPar(i, j, fval);
            }
        }
        mcepData.close();
        if (htsData.getUseMixExc()) {
            strPst = new HTSPStream(strVsize, totalFrame, 3, 0);
            LEDataInputStream strData = new LEDataInputStream(new BufferedInputStream(new FileInputStream(strFile)));
            for (i = 0; i < totalFrame; ++i) {
                for (j = 0; j < strPst.getOrder(); ++j) {
                    fval = strData.readFloat();
                    if (trans) {
                        fval += fval * strTrans[j];
                    }
                    strPst.setPar(i, j, fval);
                }
            }
            strData.close();
        }
        n = 0;
        if (htsData.getUseFourierMag()) {
            magPst = new HTSPStream(magVsize, totalFrame, 4, 0);
            LEDataInputStream magData = new LEDataInputStream(new BufferedInputStream(new FileInputStream(magFile)));
            for (i = 0; i < totalFrame; ++i) {
                for (j = 0; j < magPst.getOrder(); ++j) {
                    ++n;
                    fval = magData.readFloat();
                    if (trans) {
                        fval += fval * magTrans[j];
                    }
                    magPst.setPar(i, j, fval);
                }
            }
            magData.close();
        }
        AudioFormat af = HTSVocoder.getHTSAudioFormat(htsData);
        double[] audio_double = null;
        HTSVocoder par2speech = new HTSVocoder();
        audio_double = par2speech.htsMLSAVocoder(lf0Pst, mcepPst, strPst, magPst, voiced, htsData, null);
        long lengthInSamples = audio_double.length * 2 / (af.getSampleSizeInBits() / 8);
        par2speech.logger.debug("length in samples=" + lengthInSamples);
        double MaxSample = MathUtils.getAbsMax(audio_double);
        for (i = 0; i < audio_double.length; ++i) {
            audio_double[i] = audio_double[i] / MaxSample;
        }
        DDSAudioInputStream oais = new DDSAudioInputStream(new BufferedDoubleDataSource(audio_double), af);
        File fileOut = new File(outFile);
        System.out.println("saving to file: " + outFile);
        if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, oais)) {
            AudioSystem.write((AudioInputStream)oais, AudioFileFormat.Type.WAVE, fileOut);
        }
        if (play) {
            System.out.println("Calling audioplayer:");
            AudioPlayer player = new AudioPlayer(fileOut);
            player.start();
            player.join();
            System.out.println("audioplayer finished...");
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, Exception {
        BasicConfigurator.configure();
        String path = "/project/mary/marcela/HMM-voices/arctic_slt/hts/data/";
        String fileName = "modal0002";
        String[] args4 = new String[]{"0", "0.42", "0.05", "0.25", "16000", "80", path + "mgc/" + fileName + ".mgc", "75", path + "lf0/" + fileName + ".lf0", "3", path + "vocoder/" + fileName + "_vocoder_soft.wav", path + "str/" + fileName + ".str", "15", path + "filters/mix_excitation_filters.txt", "5", path + "mag/" + fileName + ".mag", "30", "true", "soft"};
        HTSVocoder vocoder = new HTSVocoder();
        vocoder.htsMLSAVocoderCommand(args4);
    }

    public void vocoderList(String[] args) throws IOException, InterruptedException, Exception {
        String path = "/project/mary/marcela/quality_parameters/necadbs/hts/data/";
        File outDir = new File(path + "vocoder");
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        File directory = new File(path + "raw");
        String[] files = FileUtils.listBasenames(directory, ".raw");
        HTSVocoder vocoder = new HTSVocoder();
        for (int i = 0; i < files.length; ++i) {
            System.out.println("file: " + files[i]);
            String[] args1 = new String[]{"0", "0.42", "0.05", "0.15", "16000", "80", path + "mgc/" + files[i] + ".mgc", "75", path + "lf0/" + files[i] + ".lf0", "3", path + "vocoder/" + files[i] + ".wav", path + "str/" + files[i] + ".str", "15", path + "filters/mix_excitation_filters.txt", "5", "true"};
            vocoder.htsMLSAVocoderCommand(args1);
        }
    }

    protected class HTSVocoderDataProducer
    extends ProducingDoubleDataSource {
        private static final double INITIAL_MAX_AMPLITUDE = 17000.0;
        private HTSPStream lf0Pst;
        private HTSPStream mcepPst;
        private HTSPStream strPst;
        private HTSPStream magPst;
        private boolean[] voiced;
        private HMMData htsData;

        public HTSVocoderDataProducer(int audioSize, HTSParameterGeneration pdf2par, HMMData htsData) {
            super(audioSize, (InlineDataProcessor)new AmplitudeNormalizer(17000.0));
            this.lf0Pst = pdf2par.getlf0Pst();
            this.mcepPst = pdf2par.getMcepPst();
            this.strPst = pdf2par.getStrPst();
            this.magPst = pdf2par.getMagPst();
            this.voiced = pdf2par.getVoicedArray();
            this.htsData = htsData;
        }

        @Override
        public void run() {
            try {
                HTSVocoder.this.htsMLSAVocoder(this.lf0Pst, this.mcepPst, this.strPst, this.magPst, this.voiced, this.htsData, this);
                this.putEndOfStream();
            }
            catch (Exception e) {
                HTSVocoder.this.logger.error("Cannot vocode", e);
            }
        }
    }
}

