/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.matrix;

import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.math.matrix.AbstractMatrix;
import com.rapidminer.tools.math.matrix.ExtendedMatrix;
import com.rapidminer.tools.math.matrix.SimpleSparseMatrix;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedSparseMatrix<Ex, Ey>
extends AbstractMatrix<Ex, Ey>
implements ExtendedMatrix<Ex, Ey> {
    private static final long serialVersionUID = -4863248877511747800L;
    private SimpleSparseMatrix<Ex, Ey> xIndexedMatrix = new SimpleSparseMatrix();
    private SimpleSparseMatrix<Ey, Ex> yIndexedMatrix = new SimpleSparseMatrix();

    @Override
    public IOObject copy() {
        ExtendedSparseMatrix<Ex, Ey> result = new ExtendedSparseMatrix<Ex, Ey>();
        Iterator<Ex> xLabels = this.getXLabels();
        while (xLabels.hasNext()) {
            Ex xLabel = xLabels.next();
            Iterator<Ey> yLabels = this.getYLabels();
            while (yLabels.hasNext()) {
                Ey yLabel = yLabels.next();
                result.setEntry(xLabel, yLabel, this.getEntry(xLabel, yLabel));
            }
        }
        return result;
    }

    @Override
    public int getNumYEntries(Ex x) {
        return this.xIndexedMatrix.getNumYEntries(x);
    }

    @Override
    public int getNumXEntries(Ey y) {
        return this.yIndexedMatrix.getNumYEntries(y);
    }

    @Override
    public Iterator<Ey> getYEntries(Ex x) {
        return this.xIndexedMatrix.getYEntries(x);
    }

    @Override
    public Iterator<Ex> getXEntries(Ey y) {
        return this.yIndexedMatrix.getYEntries(y);
    }

    @Override
    public int getNumXLabels() {
        return this.xIndexedMatrix.getNumXLabels();
    }

    @Override
    public int getNumYLabels() {
        return this.yIndexedMatrix.getNumXLabels();
    }

    @Override
    public Iterator<Ex> getXLabels() {
        return this.xIndexedMatrix.getXLabels();
    }

    @Override
    public Iterator<Ey> getYLabels() {
        return this.yIndexedMatrix.getXLabels();
    }

    @Override
    public void setEntry(Ex x, Ey y, double val) {
        this.xIndexedMatrix.setEntry(x, y, val);
        this.yIndexedMatrix.setEntry(y, x, val);
    }

    @Override
    public double getEntry(Ex x, Ey y) {
        return this.xIndexedMatrix.getEntry(x, y);
    }

    @Override
    public void incEntry(Ex x, Ey y, double val) {
        double currentValue = this.xIndexedMatrix.getEntry(x, y);
        this.setEntry(x, y, currentValue + val);
    }
}

