/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeNumber;

public class ParameterTypeDouble
extends ParameterTypeNumber {
    private static final long serialVersionUID = 2455026868706964187L;
    private double defaultValue = Double.NaN;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private boolean noDefault = true;
    private boolean optional = true;

    public ParameterTypeDouble(String key, String description, double min, double max) {
        this(key, description, min, max, Double.NaN);
        this.noDefault = true;
        this.optional = false;
    }

    public ParameterTypeDouble(String key, String description, double min, double max, boolean optional) {
        this(key, description, min, max, Double.NaN);
        this.noDefault = true;
        this.optional = optional;
    }

    public ParameterTypeDouble(String key, String description, double min, double max, double defaultValue) {
        super(key, description);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.optional = true;
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public boolean isOptional() {
        return super.isOptional() && this.optional;
    }

    public Object getDefaultValue() {
        if (Double.isNaN(this.defaultValue)) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = (Double)object;
    }

    public boolean isNumerical() {
        return true;
    }

    public String getRange() {
        String range = "real; ";
        range = this.min == Double.NEGATIVE_INFINITY ? String.valueOf(range) + "-\u221e" : String.valueOf(range) + this.min;
        range = String.valueOf(range) + "-";
        range = this.max == Double.POSITIVE_INFINITY ? String.valueOf(range) + "+\u221e" : String.valueOf(range) + this.max;
        if (!this.noDefault) {
            range = String.valueOf(range) + "; default: " + this.defaultValue;
        }
        return range;
    }
}

