/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterCloner
extends Operator {
    public static final String PARAMETER_NAME_MAP = "name_map";
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[0];

    public ParameterCloner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        List<String[]> nameList = this.getParameterList(PARAMETER_NAME_MAP);
        for (String[] keyValue : nameList) {
            String[] source = keyValue[0].split("\\.");
            String[] target = keyValue[1].split("\\.");
            if (source.length != 2) {
                throw new UserError((Operator)this, 907, keyValue[0]);
            }
            if (target.length != 2) {
                throw new UserError((Operator)this, 907, keyValue[1]);
            }
            Operator operator = this.getProcess().getOperator(source[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, source[0]);
            }
            String value = operator.getParameter(source[1]);
            if (value == null) {
                throw new UserError((Operator)this, 213, source[1], source[0], this.getName());
            }
            operator = this.getProcess().getOperator(target[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, target[0]);
            }
            operator.getParameters().setParameter(target[1], value);
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_NAME_MAP, "A list mapping operator parameters from the set to other operator parameters in the process setup.", new ParameterTypeString("operator_parameters", "Key and value are 'operator'.'parameter'. The key species the source parameter, the value the destination.")));
        return types;
    }
}

