/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.loganalysis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.IterationArrayList;
import com.rapidminer.tools.math.matrix.SimpleSparseMatrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLog2Transactions
extends Operator {
    public ServerLog2Transactions(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet es = this.getInput(ExampleSet.class);
        Attribute sessionId = es.getAttributes().get("session");
        Attribute uriAttr = es.getAttributes().get("uri");
        SimpleSparseMatrix<Integer, String> matrix = new SimpleSparseMatrix<Integer, String>();
        for (Example e : es) {
            int session = (int)e.getValue(sessionId);
            String uriStr = uriAttr.getMapping().mapIndex((int)e.getValue(uriAttr));
            matrix.incEntry(session, uriStr, 1.0);
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        HashMap<String, Attribute> attributeMap = new HashMap<String, Attribute>();
        IterationArrayList uris = new IterationArrayList(matrix.getYLabels());
        for (String uri : uris) {
            Attribute att = AttributeFactory.createAttribute(uri, 3);
            attributes.add(att);
            attributeMap.put(uri, att);
        }
        MemoryExampleTable et = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> dataRows = new LinkedList<DoubleArrayDataRow>();
        Iterator it = matrix.getXLabels();
        while (it.hasNext()) {
            int session = (Integer)it.next();
            DoubleArrayDataRow dataRow = new DoubleArrayDataRow(new double[attributes.size()]);
            for (Attribute att : attributes) {
                dataRow.set(att, matrix.getEntry(session, att.getName()));
            }
            dataRows.add(dataRow);
        }
        et.readExamples(new ListDataRowReader(dataRows.iterator()));
        ExampleSet es2 = et.createExampleSet();
        return new IOObject[]{es2};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

