/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.Icon;

public class ThresholdModel
extends PredictionModel {
    private static final long serialVersionUID = -4224958349396815500L;
    private static final String RESULT_ICON_NAME = "cut.png";
    private static Icon resultIcon = null;
    private double[] thresholds;
    private Model innerModel;

    static {
        resultIcon = SwingTools.createIcon("16/cut.png");
    }

    public ThresholdModel(ExampleSet exampleSet, Model innerModel, double[] thresholds) {
        super(exampleSet);
        this.innerModel = innerModel;
        this.thresholds = thresholds;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        exampleSet = this.innerModel.apply(exampleSet);
        for (Example example : exampleSet) {
            int predictionIndex = (int)example.getPredictedLabel();
            String className = this.getLabel().getMapping().mapIndex(predictionIndex);
            double confidence = example.getConfidence(className);
            if (!(confidence < this.thresholds[predictionIndex])) continue;
            example.setPredictedLabel(Double.NaN);
        }
        return exampleSet;
    }

    public Component getVisualizationComponent(IOContainer container) {
        return this.innerModel.getVisualizationComponent(container);
    }

    public Icon getResultIcon() {
        return resultIcon;
    }

    public String toString() {
        LinkedList<String> thresholdList = new LinkedList<String>();
        double[] dArray = this.thresholds;
        int n = this.thresholds.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            thresholdList.add(Tools.formatIntegerIfPossible(d));
            ++n2;
        }
        return "Thresholds: " + thresholdList + Tools.getLineSeparator() + this.innerModel.toString();
    }
}

