/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.BayBoostBaseModelInfo;
import com.rapidminer.operator.learner.meta.BayBoostModel;
import com.rapidminer.operator.learner.meta.ContingencyMatrix;
import com.rapidminer.operator.learner.meta.WeightedPerformanceMeasures;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayesianBoosting
extends AbstractMetaLearner {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_USE_SUBSET_FOR_TRAINING = "use_subset_for_training";
    public static final String PARAMETER_RESCALE_LABEL_PRIORS = "rescale_label_priors";
    public static final String PARAMETER_ALLOW_MARGINAL_SKEWS = "allow_marginal_skews";
    public static final double MIN_ADVANTAGE = 0.001;
    private Model startModel;
    protected int currentIteration;
    private double performance = 0.0;
    private double[] oldWeights;

    public BayesianBoosting(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The performance."){

            public double getDoubleValue() {
                return BayesianBoosting.this.performance;
            }
        });
        this.addValue(new ValueDouble("iteration", "The current iteration."){

            public double getDoubleValue() {
                return BayesianBoosting.this.currentIteration;
            }
        });
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_CLASS || lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return false;
        }
        if (lc == LearnerCapability.WEIGHTED_EXAMPLES) {
            return true;
        }
        return super.supportsCapability(lc);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.readOptionalParameters();
        double[] classPriors = this.prepareWeights(exampleSet);
        double maxPrior = Double.NEGATIVE_INFINITY;
        double sumPriors = 0.0;
        int i = 0;
        while (i < classPriors.length) {
            if (classPriors[i] > maxPrior) {
                maxPrior = classPriors[i];
            }
            sumPriors += classPriors[i];
            ++i;
        }
        BayBoostModel model = com.rapidminer.tools.Tools.isEqual(sumPriors, maxPrior) ? new BayBoostModel(exampleSet, new Vector<BayBoostBaseModelInfo>(), classPriors) : this.trainBoostingModel(exampleSet, classPriors);
        if (this.oldWeights != null) {
            Iterator reader = exampleSet.iterator();
            int i2 = 0;
            while (reader.hasNext() && i2 < this.oldWeights.length) {
                ((Example)reader.next()).setWeight(this.oldWeights[i2++]);
            }
        } else {
            Attribute weight = exampleSet.getAttributes().getWeight();
            exampleSet.getAttributes().remove(weight);
            exampleSet.getExampleTable().removeAttribute(weight);
        }
        return model;
    }

    protected double[] prepareWeights(ExampleSet exampleSet) {
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        if (weightAttr == null) {
            this.oldWeights = null;
            this.performance = exampleSet.size();
            return this.createNewWeightAttribute(exampleSet);
        }
        this.oldWeights = new double[exampleSet.size()];
        double[] priors = new double[exampleSet.getAttributes().getLabel().getMapping().size()];
        double totalWeight = 0.0;
        Iterator reader = exampleSet.iterator();
        int i = 0;
        while (reader.hasNext() && i < this.oldWeights.length) {
            Example example = (Example)reader.next();
            if (example != null) {
                double weight;
                this.oldWeights[i] = weight = example.getWeight();
                int label = (int)example.getLabel();
                if (label >= 0 && label < priors.length) {
                    int n = label;
                    priors[n] = priors[n] + weight;
                    totalWeight += weight;
                } else {
                    example.setWeight(0.0);
                }
            }
            ++i;
        }
        this.performance = totalWeight;
        i = 0;
        while (i < priors.length) {
            int n = i++;
            priors[n] = priors[n] / totalWeight;
        }
        return priors;
    }

    /*
     * Unable to fully structure code
     */
    private double[] createNewWeightAttribute(ExampleSet exampleSet) {
        block2: {
            Tools.createWeightAttribute(exampleSet);
            exRead = exampleSet.iterator();
            numClasses = exampleSet.getAttributes().getLabel().getMapping().getValues().size();
            classPriors = new double[numClasses];
            total = exampleSet.size();
            invTotal = 1.0 / (double)total;
            if (this.getParameterAsBoolean("rescale_label_priors")) ** GOTO lbl18
            while (exRead.hasNext()) {
                example = (Example)exRead.next();
                example.setWeight(1.0);
                v0 = (int)example.getLabel();
                classPriors[v0] = classPriors[v0] + invTotal;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                v1 = (int)((Example)exRead.next()).getLabel();
                classPriors[v1] = classPriors[v1] + invTotal;
lbl18:
                // 2 sources

                ** while (exRead.hasNext())
            }
lbl19:
            // 1 sources

            this.rescaleToEqualPriors(exampleSet, classPriors);
        }
        return classPriors;
    }

    private void rescaleToEqualPriors(ExampleSet exampleSet, double[] currentPriors) {
        double[] weights = new double[currentPriors.length];
        int i = 0;
        while (i < weights.length) {
            weights[i] = 1.0 / ((double)weights.length * currentPriors[i]);
            ++i;
        }
        for (Example example : exampleSet) {
            example.setWeight(weights[(int)example.getLabel()]);
        }
    }

    protected Model trainBaseModel(ExampleSet exampleSet) throws OperatorException {
        Model model = this.applyInnerLearner(exampleSet);
        return model;
    }

    private void readOptionalParameters() {
        try {
            this.startModel = this.getInput(Model.class);
        }
        catch (MissingIOObjectException e) {
            this.log(String.valueOf(this.getName()) + ": No model found in input.");
        }
    }

    private void applyPriorModel(ExampleSet trainingSet, List<BayBoostBaseModelInfo> modelInfo) throws OperatorException {
        if (this.startModel != null) {
            ExampleSet resultSet = this.startModel.apply((ExampleSet)trainingSet.clone());
            WeightedPerformanceMeasures wp = new WeightedPerformanceMeasures(resultSet);
            this.reweightExamples(wp, resultSet);
            modelInfo.add(new BayBoostBaseModelInfo(this.startModel, wp.getContingencyMatrix()));
            PredictionModel.removePredictedLabel(resultSet);
        }
    }

    private BayBoostModel trainBoostingModel(ExampleSet trainingSet, double[] classPriors) throws OperatorException {
        Vector<BayBoostBaseModelInfo> modelInfo = new Vector<BayBoostBaseModelInfo>();
        this.applyPriorModel(trainingSet, modelInfo);
        double splitRatio = this.getParameterAsDouble(PARAMETER_USE_SUBSET_FOR_TRAINING);
        boolean bootstrap = splitRatio > 0.0 && splitRatio < 1.0;
        this.log(bootstrap ? "Bootstrapping enabled." : "Bootstrapping disabled.");
        boolean allowSkew = this.getParameterAsBoolean(PARAMETER_ALLOW_MARGINAL_SKEWS);
        SplittedExampleSet splittedSet = null;
        if (bootstrap) {
            splittedSet = new SplittedExampleSet(trainingSet, splitRatio, 1, -1);
        }
        int iterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        int i = 0;
        while (i < iterations) {
            WeightedPerformanceMeasures wp;
            Model model;
            this.currentIteration = i;
            ExampleSet iterationSet = (ExampleSet)trainingSet.clone();
            if (bootstrap) {
                splittedSet.selectSingleSubset(0);
                model = this.trainBaseModel(splittedSet);
                iterationSet = model.apply(iterationSet);
                wp = new WeightedPerformanceMeasures(splittedSet);
                WeightedPerformanceMeasures.reweightExamples(splittedSet, wp.getContingencyMatrix(), allowSkew);
                splittedSet.selectSingleSubset(1);
                wp = new WeightedPerformanceMeasures(splittedSet);
                this.performance = WeightedPerformanceMeasures.reweightExamples(splittedSet, wp.getContingencyMatrix(), allowSkew);
            } else {
                model = this.trainBaseModel(iterationSet);
                iterationSet = model.apply(iterationSet);
                wp = new WeightedPerformanceMeasures(iterationSet);
                this.performance = this.reweightExamples(wp, iterationSet);
            }
            PredictionModel.removePredictedLabel(iterationSet);
            int cfr_ignored_0 = classPriors.length;
            if (wp.getNumberOfNonEmptyClasses() < 2) {
                modelInfo.add(new BayBoostBaseModelInfo(model, wp.getContingencyMatrix()));
                break;
            }
            ContingencyMatrix cm = wp.getContingencyMatrix();
            modelInfo.add(new BayBoostBaseModelInfo(model, cm));
            if (!this.isModelUseful(cm)) {
                this.log("Discard model because of low advantage on training data.");
                modelInfo.remove(modelInfo.size() - 1);
                break;
            }
            if (this.performance == 0.0) break;
            this.inApplyLoop();
            ++i;
        }
        return new BayBoostModel(trainingSet, modelInfo, classPriors);
    }

    protected double reweightExamples(WeightedPerformanceMeasures wp, ExampleSet exampleSet) throws OperatorException {
        boolean allowMarginalSkews = this.getParameterAsBoolean(PARAMETER_ALLOW_MARGINAL_SKEWS);
        double remainingWeight = WeightedPerformanceMeasures.reweightExamples(exampleSet, wp.getContingencyMatrix(), allowMarginalSkews);
        return remainingWeight;
    }

    private boolean isModelUseful(ContingencyMatrix cm) {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_RESCALE_LABEL_PRIORS, "Specifies whether the proportion of labels should be equal by construction after first iteration .", false));
        types.add(new ParameterTypeDouble(PARAMETER_USE_SUBSET_FOR_TRAINING, "Fraction of examples used for training, remaining ones are used to estimate the confusion matrix. Set to 1 to turn off test set.", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_ITERATIONS, "The maximum number of iterations.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean(PARAMETER_ALLOW_MARGINAL_SKEWS, "Allow to skew the marginal distribution (P(x)) during learning.", true));
        return types;
    }
}

