/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.functions.neuralnet.Node;

public class InputNode
extends Node {
    private Attribute attribute;
    private double attributeRange;
    private double attributeBase;
    private boolean normalize;

    public InputNode(String nodeName) {
        super(nodeName, -1, -1);
    }

    public void setAttribute(Attribute attribute, double attributeRange, double attributeBase, boolean normalize) {
        this.attribute = attribute;
        this.attributeRange = attributeRange;
        this.attributeBase = attributeBase;
        this.normalize = normalize;
    }

    public double calculateValue(boolean shouldCalculate, Example example) {
        if (Double.isNaN(this.currentValue) && shouldCalculate) {
            double value = example.getValue(this.attribute);
            this.currentValue = Double.isNaN(value) ? 0.0 : (this.normalize ? (this.attributeRange != 0.0 ? (value - this.attributeBase) / this.attributeRange : value - this.attributeBase) : value);
        }
        return this.currentValue;
    }

    public double calculateError(boolean shouldCalculate, Example example) {
        if (!Double.isNaN(this.currentValue) && Double.isNaN(this.currentError) && shouldCalculate) {
            this.currentError = 0.0;
            int i = 0;
            while (i < this.outputNodes.length) {
                this.currentError += this.outputNodes[i].calculateError(true, example);
                ++i;
            }
        }
        return this.currentError;
    }
}

